/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.optionhandling.parameterization;

import elki.utilities.optionhandling.ParameterException;
import elki.utilities.optionhandling.parameterization.AbstractParameterization;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ChainedParameterization
extends AbstractParameterization {
    private List<Parameterization> chain = new ArrayList<Parameterization>();
    private Parameterization errorTarget = this;

    public ChainedParameterization(Parameterization ... ps) {
        this.chain.addAll(Arrays.asList(ps));
    }

    public void appendParameterization(Parameterization p) {
        this.chain.add(p);
    }

    @Override
    public boolean setValueForOption(Parameter<?> opt) throws ParameterException {
        for (Parameterization p : this.chain) {
            if (!p.setValueForOption(opt)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasUnusedParameters() {
        for (Parameterization p : this.chain) {
            if (!p.hasUnusedParameters()) continue;
            return true;
        }
        return false;
    }

    public void errorsTo(Parameterization config) {
        this.errorTarget = config;
    }

    @Override
    public void reportError(ParameterException e) {
        if (this.equals(this.errorTarget)) {
            super.reportError(e);
        } else {
            this.errorTarget.reportError(e);
        }
    }

    @Override
    public Parameterization descend(Object option) {
        ChainedParameterization n = new ChainedParameterization(new Parameterization[0]);
        n.errorsTo(this.errorTarget);
        for (Parameterization p : this.chain) {
            n.appendParameterization(p.descend(option));
        }
        return n;
    }
}

