/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.optionhandling.parameterization;

import elki.logging.Logging;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.ParameterException;
import elki.utilities.optionhandling.parameterization.Parameterization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractParameterization
implements Parameterization {
    private static final Logging LOG = Logging.getLogger(AbstractParameterization.class);
    List<ParameterException> errors = new ArrayList<ParameterException>();

    @Override
    public Collection<ParameterException> getErrors() {
        return this.errors;
    }

    @Override
    public void reportError(ParameterException e) {
        this.errors.add(e);
    }

    public synchronized void logAndClearReportedErrors() {
        for (ParameterException e : this.getErrors()) {
            if (LOG.isDebugging()) {
                LOG.warning((CharSequence)e.getMessage(), (Throwable)e);
                continue;
            }
            LOG.warning((CharSequence)e.getMessage());
        }
        this.clearErrors();
    }

    public synchronized void clearErrors() {
        this.errors = new ArrayList<ParameterException>();
    }

    public void failOnErrors() {
        int numerror = this.getErrors().size();
        if (numerror > 0) {
            this.logAndClearReportedErrors();
            throw new AbortException(numerror + " errors occurred during parameterization.");
        }
    }
}

