/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.optionhandling;

import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.Parameter;

public class ParameterException
extends Exception {
    private static final long serialVersionUID = 1L;

    public ParameterException(Parameter<?> p, String message) {
        super(ParameterException.prefixParameterToMessage(p, message));
    }

    public ParameterException(Parameter<?> p, String message, Throwable cause) {
        super(ParameterException.prefixParameterToMessage(p, message), cause);
    }

    public ParameterException(String message) {
        super(message);
    }

    public ParameterException(String message, Throwable cause) {
        super(message, cause);
    }

    public static String prefixParameterToMessage(Parameter<?> p, String message) {
        return new StringBuilder(100 + message.length()).append(p instanceof Flag ? "Flag '" : "Parameter '").append(p.getOptionID().getName()).append("' ").append(message).toString();
    }

    public static String prefixParametersToMessage(Parameter<?> p, String mid, Parameter<?> p2, String message) {
        return new StringBuilder(200 + mid.length() + message.length()).append(p instanceof Flag ? "Flag '" : "Parameter '").append(p.getOptionID().getName()).append("' ").append(mid).append(p2 instanceof Flag ? " Flag '" : " Parameter '").append(p2.getOptionID().getName()).append(message.length() > 0 ? "' " : "'.").append(message).toString();
    }
}

