/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.io;

import elki.utilities.io.BufferedLineReader;
import elki.utilities.io.Tokenizer;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TokenizedReader
extends BufferedLineReader {
    private Matcher comment = null;
    protected Tokenizer tokenizer;

    public TokenizedReader(Pattern colSep, String quoteChars, Pattern comment) {
        this.tokenizer = new Tokenizer(colSep, quoteChars);
        this.comment = comment == null ? null : comment.matcher("");
    }

    public boolean nextLineExceptComments() throws IOException {
        while (super.nextLine()) {
            if (this.comment != null && this.comment.reset(this.buf).matches()) continue;
            this.tokenizer.initialize(this.buf, 0, this.buf.length());
            return true;
        }
        return false;
    }

    @Override
    public boolean nextLine() throws IOException {
        if (super.nextLine()) {
            this.tokenizer.initialize(this.buf, 0, this.buf.length());
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.comment != null) {
            this.comment.reset("");
        }
        this.tokenizer.cleanup();
    }

    @Override
    public void close() throws IOException {
        this.reset();
        super.close();
    }

    public Tokenizer getTokenizer() {
        return this.tokenizer;
    }
}

