/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.io;

import elki.logging.Logging;
import elki.utilities.datastructures.BitsUtil;

public final class ParseUtil {
    private static final Logging LOG = Logging.getLogger(ParseUtil.class);
    public static final NumberFormatException EMPTY_STRING = new PreallocatedException("Parser called on an empty string");
    public static final NumberFormatException EXPONENT_OVERFLOW = new PreallocatedException("Precision overflow for double exponent");
    public static final NumberFormatException INVALID_EXPONENT = new PreallocatedException("Invalid exponent");
    public static final NumberFormatException TRAILING_CHARACTERS = new PreallocatedException("String sequence was not completely consumed");
    public static final NumberFormatException PRECISION_OVERFLOW = new PreallocatedException("Precision overflow when parsing a number");
    public static final NumberFormatException NOT_A_NUMBER = new PreallocatedException("Number must start with a digit or dot");
    private static final char[] INFINITY_PATTERN = new char[]{'I', 'n', 'f', 'i', 'n', 'i', 't', 'y', 'i', 'N', 'F', 'I', 'N', 'I', 'T', 'Y'};
    private static final int INFINITY_LENGTH = INFINITY_PATTERN.length >> 1;

    private ParseUtil() {
    }

    public static double parseDouble(byte[] str, int start, int end) {
        boolean isNegative;
        if (start >= end) {
            throw LOG.isDebuggingFine() ? new NumberFormatException(EMPTY_STRING.getMessage()) : EMPTY_STRING;
        }
        int pos = start;
        byte cur = str[pos];
        if (ParseUtil.matchNaN(str, cur, pos, end)) {
            return Double.NaN;
        }
        boolean bl = isNegative = cur == 45;
        if ((isNegative || cur == 43) && ++pos < end) {
            cur = str[pos];
        }
        if (ParseUtil.matchInf(str, cur, pos, end)) {
            return isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        int realstart = pos;
        if ((cur < 48 || cur > 57) && cur != 46) {
            throw LOG.isDebuggingFine() ? new NumberFormatException(NOT_A_NUMBER.getMessage()) : NOT_A_NUMBER;
        }
        long decimal = 0L;
        int decimalPoint = -1;
        while (true) {
            int digit;
            if ((digit = cur - 48) >= 0 && digit <= 9) {
                long tmp = (decimal << 3) + (decimal << 1) + (long)digit;
                if (tmp >= decimal) {
                    decimal = tmp;
                } else if (++decimalPoint == 0) {
                    throw LOG.isDebuggingFine() ? new NumberFormatException(PRECISION_OVERFLOW.getMessage()) : PRECISION_OVERFLOW;
                }
            } else {
                if (cur != 46 || decimalPoint >= 0) break;
                decimalPoint = pos;
            }
            if (++pos >= end) break;
            cur = str[pos];
        }
        if (pos == realstart + (decimalPoint >= 0 ? 1 : 0)) {
            throw LOG.isDebuggingFine() ? new NumberFormatException(NOT_A_NUMBER.getMessage()) : NOT_A_NUMBER;
        }
        decimalPoint = decimalPoint >= 0 ? pos - decimalPoint - 1 : 0;
        int exp = 0;
        if (pos + 1 < end && (cur == 69 || cur == 101)) {
            int digit;
            boolean isNegativeExp;
            boolean bl2 = isNegativeExp = (cur = str[++pos]) == 45;
            if ((isNegativeExp || cur == 43) && ++pos < end) {
                cur = str[pos];
            }
            if (cur < 48 || cur > 57) {
                throw LOG.isDebuggingFine() ? new NumberFormatException(INVALID_EXPONENT.getMessage()) : INVALID_EXPONENT;
            }
            while ((digit = cur - 48) >= 0 && digit <= 9) {
                if ((exp = (exp << 3) + (exp << 1) + digit) > 1023) {
                    throw LOG.isDebuggingFine() ? new NumberFormatException(EXPONENT_OVERFLOW.getMessage()) : EXPONENT_OVERFLOW;
                }
                if (++pos >= end) break;
                cur = str[pos];
            }
            exp = isNegativeExp ? -exp : exp;
        }
        int n = exp = decimalPoint > 0 ? exp - decimalPoint : exp;
        if (pos != end) {
            throw LOG.isDebuggingFine() ? new NumberFormatException(TRAILING_CHARACTERS.getMessage()) : TRAILING_CHARACTERS;
        }
        return BitsUtil.lpow10(isNegative ? -decimal : decimal, exp);
    }

    public static double parseDouble(CharSequence str) {
        return ParseUtil.parseDouble(str, 0, str.length());
    }

    public static double parseDouble(CharSequence str, int start, int end) {
        boolean isNegative;
        if (start >= end) {
            throw LOG.isDebuggingFine() ? new NumberFormatException(EMPTY_STRING.getMessage()) : EMPTY_STRING;
        }
        int pos = start;
        char cur = str.charAt(pos);
        if (ParseUtil.matchNaN(str, cur, pos, end)) {
            return Double.NaN;
        }
        boolean bl = isNegative = cur == '-';
        if ((isNegative || cur == '+') && ++pos < end) {
            cur = str.charAt(pos);
        }
        if (ParseUtil.matchInf(str, cur, pos, end)) {
            return isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        int realstart = pos;
        if ((cur < '0' || cur > '9') && cur != '.') {
            throw LOG.isDebuggingFine() ? new NumberFormatException(NOT_A_NUMBER.getMessage()) : NOT_A_NUMBER;
        }
        long decimal = 0L;
        int decimalPoint = -1;
        while (true) {
            int digit;
            if ((digit = cur - 48) >= 0 && digit <= 9) {
                long tmp = (decimal << 3) + (decimal << 1) + (long)digit;
                if (tmp >= decimal) {
                    decimal = tmp;
                } else if (++decimalPoint == 0) {
                    throw LOG.isDebuggingFine() ? new NumberFormatException(PRECISION_OVERFLOW.getMessage()) : PRECISION_OVERFLOW;
                }
            } else {
                if (cur != '.' || decimalPoint >= 0) break;
                decimalPoint = pos;
            }
            if (++pos >= end) break;
            cur = str.charAt(pos);
        }
        if (pos == realstart + (decimalPoint >= 0 ? 1 : 0)) {
            throw LOG.isDebuggingFine() ? new NumberFormatException(NOT_A_NUMBER.getMessage()) : NOT_A_NUMBER;
        }
        decimalPoint = decimalPoint >= 0 ? pos - decimalPoint - 1 : 0;
        int exp = 0;
        if (pos + 1 < end && (cur == 'E' || cur == 'e')) {
            int digit;
            boolean isNegativeExp;
            boolean bl2 = isNegativeExp = (cur = str.charAt(++pos)) == '-';
            if ((isNegativeExp || cur == '+') && ++pos < end) {
                cur = str.charAt(pos);
            }
            if (cur < '0' || cur > '9') {
                throw LOG.isDebuggingFine() ? new NumberFormatException(INVALID_EXPONENT.getMessage()) : INVALID_EXPONENT;
            }
            while ((digit = cur - 48) >= 0 && digit <= 9) {
                if ((exp = (exp << 3) + (exp << 1) + digit) > 1023) {
                    throw LOG.isDebuggingFine() ? new NumberFormatException(EXPONENT_OVERFLOW.getMessage()) : EXPONENT_OVERFLOW;
                }
                if (++pos >= end) break;
                cur = str.charAt(pos);
            }
            exp = isNegativeExp ? -exp : exp;
        }
        int n = exp = decimalPoint > 0 ? exp - decimalPoint : exp;
        if (pos != end) {
            throw LOG.isDebuggingFine() ? new NumberFormatException(TRAILING_CHARACTERS.getMessage()) : TRAILING_CHARACTERS;
        }
        return BitsUtil.lpow10(isNegative ? -decimal : decimal, exp);
    }

    public static long parseLongBase10(CharSequence str) {
        return ParseUtil.parseLongBase10(str, 0, str.length());
    }

    public static long parseLongBase10(CharSequence str, int start, int end) {
        int digit;
        boolean isNegative;
        if (start >= end) {
            throw LOG.isDebuggingFine() ? new NumberFormatException(EMPTY_STRING.getMessage()) : EMPTY_STRING;
        }
        int pos = start;
        char cur = str.charAt(pos);
        boolean bl = isNegative = cur == '-';
        if ((isNegative || cur == '+') && ++pos < end) {
            cur = str.charAt(pos);
        }
        if (cur < '0' || cur > '9') {
            throw LOG.isDebuggingFine() ? new NumberFormatException(NOT_A_NUMBER.getMessage()) : NOT_A_NUMBER;
        }
        long decimal = 0L;
        while ((digit = cur - 48) >= 0 && digit <= 9) {
            long tmp = (decimal << 3) + (decimal << 1) + (long)digit;
            if (tmp < decimal) {
                if (isNegative && tmp == Long.MIN_VALUE && pos + 1 == end) {
                    return Long.MIN_VALUE;
                }
                throw LOG.isDebuggingFine() ? new NumberFormatException(PRECISION_OVERFLOW.getMessage()) : PRECISION_OVERFLOW;
            }
            decimal = tmp;
            if (++pos >= end) break;
            cur = str.charAt(pos);
        }
        if (pos != end) {
            throw LOG.isDebuggingFine() ? new NumberFormatException(TRAILING_CHARACTERS.getMessage()) : TRAILING_CHARACTERS;
        }
        return isNegative ? -decimal : decimal;
    }

    public static int parseIntBase10(CharSequence str) {
        return ParseUtil.parseIntBase10(str, 0, str.length());
    }

    public static int parseIntBase10(CharSequence str, int start, int end) {
        int digit;
        boolean isNegative;
        if (start >= end) {
            throw LOG.isDebuggingFine() ? new NumberFormatException(EMPTY_STRING.getMessage()) : EMPTY_STRING;
        }
        int pos = start;
        char cur = str.charAt(pos);
        boolean bl = isNegative = cur == '-';
        if ((isNegative || cur == '+') && ++pos < end) {
            cur = str.charAt(pos);
        }
        if (cur < '0' || cur > '9') {
            throw LOG.isDebuggingFine() ? new NumberFormatException(NOT_A_NUMBER.getMessage()) : NOT_A_NUMBER;
        }
        int decimal = 0;
        while ((digit = cur - 48) >= 0 && digit <= 9) {
            int tmp = (decimal << 3) + (decimal << 1) + digit;
            if (tmp < decimal) {
                if (isNegative && tmp == Integer.MIN_VALUE && pos + 1 == end) {
                    return Integer.MIN_VALUE;
                }
                throw LOG.isDebuggingFine() ? new NumberFormatException(PRECISION_OVERFLOW.getMessage()) : PRECISION_OVERFLOW;
            }
            decimal = tmp;
            if (++pos >= end) break;
            cur = str.charAt(pos);
        }
        if (pos != end) {
            throw LOG.isDebuggingFine() ? new NumberFormatException(TRAILING_CHARACTERS.getMessage()) : TRAILING_CHARACTERS;
        }
        return isNegative ? -decimal : decimal;
    }

    private static boolean matchInf(byte[] str, byte firstchar, int start, int end) {
        int len = end - start;
        if (len == 3 && firstchar == -30 && str[start + 1] == -120 && str[start + 2] == -98) {
            return true;
        }
        if (len != 3 && len != INFINITY_LENGTH || firstchar != 73 && firstchar != 105) {
            return false;
        }
        int i = 1;
        int j = INFINITY_LENGTH + 1;
        while (i < INFINITY_LENGTH) {
            byte c = str[start + i];
            if (c != INFINITY_PATTERN[i] && c != INFINITY_PATTERN[j]) {
                return false;
            }
            if (i == 2 && len == 3) {
                return true;
            }
            ++i;
            ++j;
        }
        return true;
    }

    private static boolean matchInf(CharSequence str, char firstchar, int start, int end) {
        int len = end - start;
        if (len == 1 && firstchar == '\u221e') {
            return true;
        }
        if (len != 3 && len != INFINITY_LENGTH || firstchar != 'I' && firstchar != 'i') {
            return false;
        }
        int i = 1;
        int j = INFINITY_LENGTH + 1;
        while (i < INFINITY_LENGTH) {
            char c = str.charAt(start + i);
            if (c != INFINITY_PATTERN[i] && c != INFINITY_PATTERN[j]) {
                return false;
            }
            if (i == 2 && len == 3) {
                return true;
            }
            ++i;
            ++j;
        }
        return true;
    }

    private static boolean matchNaN(byte[] str, byte firstchar, int start, int end) {
        int len = end - start;
        if (len < 2 || len > 3 || firstchar != 78 && firstchar != 110) {
            return false;
        }
        byte c1 = str[start + 1];
        if (c1 != 97 && c1 != 65) {
            return false;
        }
        if (len == 2) {
            return true;
        }
        byte c2 = str[start + 2];
        return c2 == 78 || c2 == 110;
    }

    private static boolean matchNaN(CharSequence str, char firstchar, int start, int end) {
        int len = end - start;
        if (len < 2 || len > 3 || firstchar != 'N' && firstchar != 'n') {
            return false;
        }
        char c1 = str.charAt(start + 1);
        if (c1 != 'a' && c1 != 'A') {
            return false;
        }
        if (len == 2) {
            return true;
        }
        char c2 = str.charAt(start + 2);
        return c2 == 'N' || c2 == 'n';
    }

    private static class PreallocatedException
    extends NumberFormatException {
        private static final long serialVersionUID = 1L;

        public PreallocatedException(String msg) {
            super(msg);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }

        @Override
        public String toString() {
            return this.getClass().getSuperclass().getName() + ": " + this.getMessage() + " (increase the logging level of " + ParseUtil.class.getName() + " to get a backtrace)";
        }
    }
}

