/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class LineReader
implements AutoCloseable {
    private static final int BUFFER_SIZE = 4096;
    Reader in;
    char[] buffer;
    int pos = 0;
    int end = 0;

    public LineReader(InputStream in) {
        this(new InputStreamReader(in));
    }

    public LineReader(Reader in) {
        this(in, 4096);
    }

    public LineReader(InputStream in, int buffersize) {
        this(new InputStreamReader(in), buffersize);
    }

    public LineReader(Reader in, int buffersize) {
        this.in = in;
        this.buffer = new char[buffersize];
    }

    public boolean readLine(Appendable buf) throws IOException {
        boolean success = false;
        while (true) {
            if (this.pos < this.end) {
                char c;
                success = true;
                if ((c = this.buffer[this.pos++]) == '\n') {
                    return success;
                }
                if (c == '\r') continue;
                buf.append(c);
                continue;
            }
            assert (this.pos >= this.end) : "Buffer wasn't empty when refilling!";
            this.end = this.in.read(this.buffer, 0, this.buffer.length);
            this.pos = 0;
            if (this.end < 0) break;
        }
        return success;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }
}

