/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.io;

import elki.utilities.io.ParseUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public final class FormatUtil {
    public static final NumberFormat NF = NumberFormat.getInstance(Locale.US);
    public static final NumberFormat NF0 = NumberFormat.getInstance(Locale.US);
    public static final NumberFormat NF2 = NumberFormat.getInstance(Locale.US);
    public static final NumberFormat NF3 = NumberFormat.getInstance(Locale.US);
    public static final NumberFormat NF4 = NumberFormat.getInstance(Locale.US);
    public static final NumberFormat NF6 = NumberFormat.getInstance(Locale.US);
    public static final NumberFormat NF8 = NumberFormat.getInstance(Locale.US);
    public static final NumberFormat NF16 = NumberFormat.getInstance(Locale.US);
    private static final String WHITESPACE_BUFFER = "                                                                                ";
    private static final int WHITESPACE_BUFFER_LENGTH;
    public static final String NEWLINE;
    public static final char NONBREAKING_SPACE;
    private static final long[] TIME_UNIT_SIZES;
    private static final String[] TIME_UNIT_NAMES;
    private static final int[] TIME_UNIT_DIGITS;
    private static int width;
    private static final char[] ZEROPADDING;
    private static final char[] SPACEPADDING;

    private FormatUtil() {
    }

    public static NumberFormat makeNumberFormat(int digits) {
        switch (digits) {
            case 0: {
                return NF0;
            }
            case 2: {
                return NF2;
            }
            case 3: {
                return NF3;
            }
            case 4: {
                return NF4;
            }
            case 6: {
                return NF6;
            }
            case 8: {
                return NF8;
            }
        }
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        nf.setMaximumFractionDigits(digits);
        nf.setMinimumFractionDigits(digits);
        nf.setGroupingUsed(false);
        return nf;
    }

    public static String format(double[] d) {
        return d == null ? "null" : (d.length == 0 ? "" : FormatUtil.formatTo(new StringBuilder(), d, ", ").toString());
    }

    public static String format(double[] d, String sep) {
        return d == null ? "null" : (d.length == 0 ? "" : FormatUtil.formatTo(new StringBuilder(), d, sep).toString());
    }

    public static String format(double[] d, NumberFormat nf) {
        return FormatUtil.format(d, " ", nf);
    }

    public static String format(double[] d, String sep, NumberFormat nf) {
        return d == null ? "null" : (d.length == 0 ? "" : FormatUtil.formatTo(new StringBuilder(), d, sep, nf).toString());
    }

    public static String format(double[] v, int w, int d) {
        DecimalFormat format = new DecimalFormat();
        format.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        format.setMinimumIntegerDigits(1);
        format.setMaximumFractionDigits(d);
        format.setMinimumFractionDigits(d);
        format.setGroupingUsed(false);
        int width = w + 1;
        StringBuilder msg = new StringBuilder().append('\n');
        for (int i = 0; i < v.length; ++i) {
            String s = format.format(v[i]);
            FormatUtil.whitespace(msg, Math.max(1, width - s.length())).append(s);
        }
        return msg.toString();
    }

    public static StringBuilder formatTo(StringBuilder buf, double[] d, String sep) {
        if (d == null) {
            return buf.append("null");
        }
        if (d.length == 0) {
            return buf;
        }
        buf.append(d[0]);
        for (int i = 1; i < d.length; ++i) {
            buf.append(sep).append(d[i]);
        }
        return buf;
    }

    public static StringBuilder formatTo(StringBuilder buf, double[] d, String sep, NumberFormat nf) {
        if (d == null) {
            return buf.append("null");
        }
        if (d.length == 0) {
            return buf;
        }
        buf.append(nf.format(d[0]));
        for (int i = 1; i < d.length; ++i) {
            buf.append(sep).append(nf.format(d[i]));
        }
        return buf;
    }

    public static StringBuilder formatTo(StringBuilder buf, float[] d, String sep) {
        if (d == null) {
            return buf.append("null");
        }
        if (d.length == 0) {
            return buf;
        }
        buf.append(d[0]);
        for (int i = 1; i < d.length; ++i) {
            buf.append(sep).append(d[i]);
        }
        return buf;
    }

    public static StringBuilder formatTo(StringBuilder buf, float[] d, String sep, NumberFormat nf) {
        if (d == null) {
            return buf.append("null");
        }
        if (d.length == 0) {
            return buf;
        }
        buf.append(nf.format(d[0]));
        for (int i = 1; i < d.length; ++i) {
            buf.append(sep).append(nf.format(d[i]));
        }
        return buf;
    }

    public static StringBuilder formatTo(StringBuilder buf, int[] d, String sep) {
        if (d == null) {
            return buf.append("null");
        }
        if (d.length == 0) {
            return buf;
        }
        buf.append(d[0]);
        for (int i = 1; i < d.length; ++i) {
            buf.append(sep).append(d[i]);
        }
        return buf;
    }

    public static StringBuilder formatTo(StringBuilder buf, long[] d, String sep) {
        if (d == null) {
            return buf.append("null");
        }
        if (d.length == 0) {
            return buf;
        }
        buf.append(d[0]);
        for (int i = 1; i < d.length; ++i) {
            buf.append(sep).append(d[i]);
        }
        return buf;
    }

    public static StringBuilder formatTo(StringBuilder buf, short[] d, String sep) {
        if (d == null) {
            return buf.append("null");
        }
        if (d.length == 0) {
            return buf;
        }
        buf.append(d[0]);
        for (int i = 1; i < d.length; ++i) {
            buf.append(sep).append(d[i]);
        }
        return buf;
    }

    public static StringBuilder formatTo(StringBuilder buf, byte[] d, String sep) {
        if (d == null) {
            return buf.append("null");
        }
        if (d.length == 0) {
            return buf;
        }
        buf.append(d[0]);
        for (int i = 1; i < d.length; ++i) {
            buf.append(sep).append(d[i]);
        }
        return buf;
    }

    public static StringBuilder formatTo(StringBuilder buf, boolean[] d, String sep) {
        if (d == null) {
            return buf.append("null");
        }
        if (d.length == 0) {
            return buf;
        }
        buf.append(d[0]);
        for (int i = 1; i < d.length; ++i) {
            buf.append(sep).append(FormatUtil.format(d[i]));
        }
        return buf;
    }

    public static StringBuilder formatTo(StringBuilder buf, boolean b) {
        return buf.append(b ? "true" : "false");
    }

    public static StringBuilder formatBit(StringBuilder buf, boolean b) {
        return buf.append(b ? (char)'1' : '0');
    }

    public static String format(float[] d, String sep, NumberFormat nf) {
        return d == null ? "null" : (d.length == 0 ? "" : FormatUtil.formatTo(new StringBuilder(), d, sep, nf).toString());
    }

    public static String format(float[] d, String sep) {
        return d == null ? "null" : (d.length == 0 ? "" : FormatUtil.formatTo(new StringBuilder(), d, sep).toString());
    }

    public static String format(float[] f) {
        return f == null ? "null" : (f.length == 0 ? "" : FormatUtil.formatTo(new StringBuilder(), f, ", ").toString());
    }

    public static String format(int[] a, String sep) {
        return a == null ? "null" : (a.length == 0 ? "" : FormatUtil.formatTo(new StringBuilder(), a, sep).toString());
    }

    public static String format(int[] a) {
        return a == null ? "null" : (a.length == 0 ? "" : FormatUtil.formatTo(new StringBuilder(), a, ", ").toString());
    }

    public static String format(long[] a) {
        return a == null ? "null" : (a.length == 0 ? "" : FormatUtil.formatTo(new StringBuilder(), a, ", ").toString());
    }

    public static String format(byte[] a) {
        return a == null ? "null" : (a.length == 0 ? "" : FormatUtil.formatTo(new StringBuilder(), a, ", ").toString());
    }

    public static String format(boolean[] b, String sep) {
        return b == null ? "null" : (b.length == 0 ? "" : FormatUtil.formatTo(new StringBuilder(), b, sep).toString());
    }

    public static String format(boolean b) {
        return b ? "1" : "0";
    }

    public static StringBuilder formatTo(StringBuilder buf, double[][] d, String pre, String pos, String csep, NumberFormat nf) {
        if (d == null) {
            return buf.append("null");
        }
        if (d.length == 0) {
            return buf;
        }
        for (int i = 0; i < d.length; ++i) {
            FormatUtil.formatTo(buf.append(pre), d[i], csep, nf).append(pos);
        }
        return buf;
    }

    public static String format(double[][] d) {
        return d == null ? "null" : (d.length == 0 ? "[]" : FormatUtil.formatTo(new StringBuilder().append("[\n"), d, " [", "]\n", ", ", NF2).append(']').toString());
    }

    public static String format(double[][] d, String pre, String pos, String csep, NumberFormat nf) {
        return d == null ? "null" : (d.length == 0 ? "" : FormatUtil.formatTo(new StringBuilder(), d, pre, pos, csep, nf).toString());
    }

    public static String format(double[][] m, int w, int d, String pre, String pos, String csep) {
        DecimalFormat format = new DecimalFormat();
        format.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        format.setMinimumIntegerDigits(1);
        format.setMaximumFractionDigits(d);
        format.setMinimumFractionDigits(d);
        format.setGroupingUsed(false);
        StringBuilder msg = new StringBuilder();
        for (int i = 0; i < m.length; ++i) {
            double[] row = m[i];
            msg.append(pre);
            for (int j = 0; j < row.length; ++j) {
                if (j > 0) {
                    msg.append(csep);
                }
                String s = format.format(row[j]);
                FormatUtil.whitespace(msg, w - s.length()).append(s);
            }
            msg.append(pos);
        }
        return msg.toString();
    }

    public static String format(double[][] m, String pre) {
        StringBuilder output = new StringBuilder().append(pre).append("[\n").append(pre);
        for (int i = 0; i < m.length; ++i) {
            FormatUtil.formatTo(output.append(" ["), m[i], ", ").append("]\n").append(pre);
        }
        return output.append("]\n").toString();
    }

    public static String format(double[][] m, NumberFormat nf) {
        return FormatUtil.formatTo(new StringBuilder().append("[\n"), m, " [", "]\n", ", ", nf).append("]").toString();
    }

    public static String format(Collection<String> d, String sep) {
        if (d == null) {
            return "null";
        }
        if (d.isEmpty()) {
            return "";
        }
        if (d.size() == 1) {
            return d.iterator().next();
        }
        int len = sep.length() * (d.size() - 1);
        for (String s : d) {
            len += s.length();
        }
        Iterator<String> it = d.iterator();
        StringBuilder buffer = new StringBuilder(len).append(it.next());
        while (it.hasNext()) {
            buffer.append(sep).append(it.next());
        }
        return buffer.toString();
    }

    public static String format(String[] d, String sep) {
        if (d == null) {
            return "null";
        }
        if (d.length == 0) {
            return "";
        }
        if (d.length == 1) {
            return d[0];
        }
        int len = sep.length() * (d.length - 1);
        for (String s : d) {
            len += s.length();
        }
        StringBuilder buffer = new StringBuilder(len).append(d[0]);
        for (int i = 1; i < d.length; ++i) {
            buffer.append(sep).append(d[i]);
        }
        return buffer.toString();
    }

    public static int findSplitpoint(String s, int width) {
        int in = s.indexOf(NEWLINE);
        int n = in = in < 0 ? s.length() : in;
        if (in < width) {
            return in;
        }
        int iw = s.lastIndexOf(32, width);
        if (iw >= 0 && iw < width) {
            return iw;
        }
        int bp = FormatUtil.nextPosition(s.indexOf(32, width), s.indexOf(NEWLINE, width));
        if (bp >= 0) {
            return bp;
        }
        return s.length();
    }

    private static int nextPosition(int a, int b) {
        return a < 0 ? b : (b < 0 ? a : (a < b ? a : b));
    }

    public static List<String> splitAtLastBlank(String s, int width) {
        ArrayList<String> chunks = new ArrayList<String>();
        String tmp = s;
        while (tmp.length() > 0) {
            int index;
            chunks.add(tmp.substring(0, index));
            for (index = FormatUtil.findSplitpoint(tmp, width); index < tmp.length() && tmp.charAt(index) == ' '; ++index) {
            }
            if (index < tmp.length() && tmp.regionMatches(index, NEWLINE, 0, NEWLINE.length())) {
                index += NEWLINE.length();
            }
            if (index >= tmp.length()) break;
            tmp = tmp.substring(index);
        }
        return chunks;
    }

    public static String whitespace(int n) {
        if (n < WHITESPACE_BUFFER_LENGTH) {
            return WHITESPACE_BUFFER.substring(0, n);
        }
        char[] buf = new char[n];
        Arrays.fill(buf, WHITESPACE_BUFFER.charAt(0));
        return new String(buf);
    }

    public static StringBuilder whitespace(StringBuilder buf, int n) {
        while (n >= WHITESPACE_BUFFER_LENGTH) {
            buf.append(WHITESPACE_BUFFER);
            n -= WHITESPACE_BUFFER_LENGTH;
        }
        return n > 0 ? buf.append(WHITESPACE_BUFFER, 0, n) : buf;
    }

    public static String pad(String o, int len) {
        return o.length() >= len ? o : o + FormatUtil.whitespace(len - o.length());
    }

    public static String padRightAligned(String o, int len) {
        return o.length() >= len ? o : FormatUtil.whitespace(len - o.length()) + o;
    }

    public static int getConsoleWidth() {
        if (width > 0) {
            return width;
        }
        int default_termwidth = 78;
        try {
            String env = System.getenv("COLUMNS");
            if (env != null) {
                int columns = ParseUtil.parseIntBase10(env);
                width = columns > 50 ? columns - 1 : 78;
                return width;
            }
        }
        catch (NumberFormatException | SecurityException env) {
            // empty catch block
        }
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", "tput cols 2> /dev/tty"});
            byte[] buf = new byte[16];
            p.getOutputStream().close();
            int l = p.getInputStream().read(buf);
            if (l >= 2 && l < buf.length) {
                int columns = ParseUtil.parseIntBase10(new String(buf, 0, buf[l - 1] == 10 ? l - 1 : l));
                width = columns > 50 ? columns - 1 : 78;
                return width;
            }
            p.destroy();
        }
        catch (IOException | NumberFormatException | SecurityException exception) {
            // empty catch block
        }
        width = 78;
        return 78;
    }

    public static String formatTimeDelta(long time, CharSequence sep) {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        for (int i = TIME_UNIT_SIZES.length - 1; i >= 0; --i) {
            if (i == 0 && sb.length() > 4) continue;
            if (sb.length() > 0) {
                sb.append(sep);
            }
            long acValue = time / TIME_UNIT_SIZES[i];
            time %= TIME_UNIT_SIZES[i];
            if (acValue == 0L && sb.length() == 0) continue;
            fmt.format("%0" + TIME_UNIT_DIGITS[i] + "d%s", acValue, TIME_UNIT_NAMES[i]);
        }
        fmt.close();
        return sb.toString();
    }

    public static StringBuilder appendZeros(StringBuilder buf, int zeros) {
        for (int i = zeros; i > 0; i -= ZEROPADDING.length) {
            buf.append(ZEROPADDING, 0, i < ZEROPADDING.length ? i : ZEROPADDING.length);
        }
        return buf;
    }

    public static StringBuilder appendSpace(StringBuilder buf, int spaces) {
        for (int i = spaces; i > 0; i -= SPACEPADDING.length) {
            buf.append(SPACEPADDING, 0, i < SPACEPADDING.length ? i : SPACEPADDING.length);
        }
        return buf;
    }

    public static int stringSize(int x) {
        if (x < 0) {
            return x == Integer.MIN_VALUE ? 11 : FormatUtil.stringSize(-x) + 1;
        }
        return x < 10000 ? (x < 100 ? (x < 10 ? 1 : 2) : (x < 1000 ? 3 : 4)) : (x < 1000000 ? (x < 100000 ? 5 : 6) : (x < 100000000 ? (x < 10000000 ? 7 : 8) : (x < 1000000000 ? 9 : 10)));
    }

    public static int stringSize(long x) {
        if (x < 0L) {
            return x == Long.MIN_VALUE ? 20 : FormatUtil.stringSize(-x) + 1;
        }
        return x <= Integer.MAX_VALUE ? FormatUtil.stringSize((int)x) : (x < 10000000000000L ? (x < 100000000000L ? (x < 10000000000L ? 10 : 11) : (x < 1000000000000L ? 12 : 13)) : (x < 1000000000000000L ? (x < 100000000000000L ? 14 : 15) : (x < 100000000000000000L ? (x < 10000000000000000L ? 16 : 17) : (x < 1000000000000000000L ? 18 : 19))));
    }

    public static boolean endsWith(CharSequence buf, CharSequence end) {
        int len = end.length();
        int start = buf.length() - len;
        if (start < 0) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (buf.charAt(start) != end.charAt(i)) {
                return false;
            }
            ++i;
            ++start;
        }
        return true;
    }

    static {
        NF.setMinimumFractionDigits(0);
        NF.setMaximumFractionDigits(8);
        NF.setGroupingUsed(false);
        NF0.setMinimumFractionDigits(0);
        NF0.setMaximumFractionDigits(0);
        NF0.setGroupingUsed(false);
        NF2.setMinimumFractionDigits(2);
        NF2.setMaximumFractionDigits(2);
        NF2.setGroupingUsed(false);
        NF3.setMinimumFractionDigits(3);
        NF3.setMaximumFractionDigits(3);
        NF3.setGroupingUsed(false);
        NF4.setMinimumFractionDigits(4);
        NF4.setMaximumFractionDigits(4);
        NF4.setGroupingUsed(false);
        NF6.setMinimumFractionDigits(6);
        NF6.setMaximumFractionDigits(6);
        NF6.setGroupingUsed(false);
        NF8.setMinimumFractionDigits(8);
        NF8.setMaximumFractionDigits(8);
        NF8.setGroupingUsed(false);
        NF16.setMinimumFractionDigits(0);
        NF16.setMaximumFractionDigits(16);
        NF16.setGroupingUsed(false);
        WHITESPACE_BUFFER_LENGTH = WHITESPACE_BUFFER.length();
        NEWLINE = System.getProperty("line.separator");
        NONBREAKING_SPACE = (char)("UTF-8".equals(Charset.defaultCharset().name()) ? 160 : 32);
        TIME_UNIT_SIZES = new long[]{1L, 1000L, 60000L, 3600000L, 86400000L};
        TIME_UNIT_NAMES = new String[]{"ms", "s", "m", "h", "d"};
        TIME_UNIT_DIGITS = new int[]{3, 2, 2, 2, 2};
        width = -1;
        ZEROPADDING = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'};
        SPACEPADDING = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    }
}

