/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.io;

import elki.logging.LoggingConfiguration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.zip.GZIPInputStream;

public final class FileUtil {
    private FileUtil() {
    }

    public static String getFilenameExtension(Path file) {
        return file == null ? null : FileUtil.getFilenameExtension(file.getFileName().toString());
    }

    public static String getFilenameExtension(String name) {
        if (name == null) {
            return null;
        }
        int index = name.lastIndexOf(46);
        return index < 0 ? null : name.substring(index + 1).toLowerCase();
    }

    public static InputStream open(URI file, OpenOption ... opts) throws IOException {
        FileSystem fs;
        if (file == null) {
            throw new IOException("Cannot open 'null' file.");
        }
        if ("file".equals(file.getScheme())) {
            return FileUtil.tryGzipInput(Files.newInputStream(Paths.get(file), opts));
        }
        try {
            fs = FileSystems.getFileSystem(file);
        }
        catch (FileSystemNotFoundException e) {
            fs = FileSystems.newFileSystem(file, Collections.emptyMap());
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e.getMessage(), e);
        }
        return FileUtil.tryGzipInput(Files.newInputStream(fs.provider().getPath(file), opts));
    }

    public static boolean exists(URI file) {
        if (file == null) {
            return false;
        }
        if ("file".equals(file.getScheme())) {
            return Paths.get(file).toFile().exists();
        }
        try {
            return Files.exists(FileSystems.getFileSystem(file).provider().getPath(file), new LinkOption[0]);
        }
        catch (FileSystemNotFoundException e) {
            try {
                return Files.exists(FileSystems.newFileSystem(file, Collections.emptyMap()).provider().getPath(file), new LinkOption[0]);
            }
            catch (IOException e2) {
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static InputStream openSystemFile(String filename) throws IOException {
        try {
            return Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            String resname = File.separatorChar != '/' ? filename.replace(File.separatorChar, '/') : filename;
            ClassLoader cl = LoggingConfiguration.class.getClassLoader();
            InputStream result = cl.getResourceAsStream(resname);
            if (result != null) {
                return result;
            }
            URL u = cl.getResource(resname);
            if (u == null) {
                throw e;
            }
            try {
                URLConnection conn = u.openConnection();
                conn.setUseCaches(false);
                result = conn.getInputStream();
                if (result != null) {
                    return result;
                }
            }
            catch (IOException x) {
                throw e;
            }
            throw e;
        }
    }

    public static InputStream tryGzipInput(InputStream in) throws IOException {
        if (in instanceof GZIPInputStream) {
            return in;
        }
        if (!in.markSupported()) {
            PushbackInputStream pb = new PushbackInputStream(in, 16);
            byte[] magic = new byte[]{0, 0};
            int r = pb.read(magic);
            pb.unread(magic, 0, r);
            return magic[0] == 31 && magic[1] == -117 ? new GZIPInputStream(pb) : pb;
        }
        in.mark(16);
        boolean isgzip = (in.read() << 8 | in.read()) == 35615;
        in.reset();
        return isgzip ? new GZIPInputStream(in) : in;
    }

    public static File locateFile(String name, String basedir) {
        File f = new File(name);
        if (f.exists()) {
            return f;
        }
        if (basedir != null && (f = new File(basedir, name)).exists()) {
            return f;
        }
        String name2 = name.trim();
        if (!name.equals(name2) && (f = FileUtil.locateFile(name2, basedir)) != null) {
            return f;
        }
        name2 = name.replace('/', File.separatorChar);
        if (!name.equals(name2) && (f = FileUtil.locateFile(name2, basedir)) != null) {
            return f;
        }
        name2 = name.replace('\\', File.separatorChar);
        if (!name.equals(name2) && (f = FileUtil.locateFile(name2, basedir)) != null) {
            return f;
        }
        if (name.length() > 2 && name.charAt(0) == '\"' && name.charAt(name.length() - 1) == '\"' && (f = FileUtil.locateFile(name.substring(1, name.length() - 1), basedir)) != null) {
            return f;
        }
        return null;
    }

    public static String slurp(InputStream is) throws IOException {
        int n;
        StringBuilder buf = new StringBuilder();
        byte[] b = new byte[4096];
        while ((n = is.read(b)) != -1) {
            buf.append(new String(b, 0, n));
        }
        is.close();
        return buf.toString();
    }
}

