/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.io;

import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    final ByteBuffer buffer;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public int read() {
        if (this.buffer.hasRemaining()) {
            return -1;
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        int maxread = Math.min(len, this.buffer.remaining());
        this.buffer.get(b, off, maxread);
        return maxread == 0 ? -1 : maxread;
    }
}

