/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.io;

import elki.utilities.io.LineReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class BufferedLineReader
implements AutoCloseable {
    private LineReader reader = null;
    protected StringBuilder buf = new StringBuilder(1024);
    protected int lineNumber = 0;

    public BufferedLineReader() {
        this.reader = null;
    }

    public BufferedLineReader(LineReader in) {
        this.reader = in;
    }

    public BufferedLineReader(InputStream in) {
        this(new LineReader(new InputStreamReader(in)));
    }

    public BufferedLineReader(InputStreamReader in) {
        this(new LineReader(in));
    }

    public void reset() {
        this.reader = null;
        this.buf.setLength(0);
        this.lineNumber = 0;
    }

    public void reset(LineReader r) {
        this.reset();
        this.reader = r;
    }

    public void reset(InputStream in) {
        this.reset();
        this.reader = new LineReader(in);
    }

    public void reset(InputStreamReader in) {
        this.reset();
        this.reader = new LineReader(in);
    }

    public CharSequence getBuffer() {
        return this.buf;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean nextLine() throws IOException {
        while (this.reader.readLine(this.buf.delete(0, this.buf.length()))) {
            ++this.lineNumber;
            if (BufferedLineReader.lengthWithoutLinefeed(this.buf) <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
        this.buf.setLength(0);
        this.buf.trimToSize();
    }

    public static int lengthWithoutLinefeed(CharSequence line) {
        char last;
        int length;
        for (length = line.length(); length > 0 && ((last = line.charAt(length - 1)) == '\n' || last == '\r'); --length) {
        }
        return length;
    }
}

