/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.datastructures.range;

import elki.utilities.datastructures.range.IntGenerator;
import java.util.function.IntConsumer;

public class StaticIntGenerator
implements IntGenerator {
    private int min = Integer.MAX_VALUE;
    private int max = Integer.MIN_VALUE;
    private int[] values;

    public StaticIntGenerator(int ... values) {
        this.values = values;
    }

    @Override
    public int getMin() {
        if (this.min > this.max) {
            this.updateMinMax();
        }
        return this.min;
    }

    @Override
    public int getMax() {
        if (this.min > this.max) {
            this.updateMinMax();
        }
        return this.max;
    }

    private void updateMinMax() {
        if (this.values.length == 0) {
            return;
        }
        this.min = this.max = this.values[0];
        for (int i = 1; i < this.values.length; ++i) {
            int v = this.values[i];
            this.min = this.min < v ? this.min : v;
            this.max = this.max > v ? this.max : v;
        }
    }

    @Override
    public void forEach(IntConsumer c) {
        for (int i : this.values) {
            c.accept(i);
        }
    }

    @Override
    public StringBuilder serializeTo(StringBuilder buf) {
        buf.append(this.values[0]);
        if (this.values.length > 1) {
            for (int i = 1; i < this.values.length; ++i) {
                buf.append(',').append(this.values[i]);
            }
        }
        return buf;
    }

    public String toString() {
        return this.serializeTo(new StringBuilder(10 * this.values.length)).toString();
    }
}

