/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.datastructures.range;

import elki.utilities.datastructures.arraylike.IntegerArray;
import elki.utilities.datastructures.range.CombinedIntGenerator;
import elki.utilities.datastructures.range.ExponentialIntGenerator;
import elki.utilities.datastructures.range.IntGenerator;
import elki.utilities.datastructures.range.LinearIntGenerator;
import elki.utilities.datastructures.range.StaticIntGenerator;
import elki.utilities.io.ParseUtil;
import java.util.ArrayList;

public class ParseIntRanges {
    private ParseIntRanges() {
    }

    public static IntGenerator parseIntRanges(String str) {
        ArrayList<IntGenerator> generators = new ArrayList<IntGenerator>();
        IntegerArray ints = new IntegerArray();
        int last = Integer.MAX_VALUE;
        int pos = 0;
        int next = -1;
        while (pos < str.length()) {
            int step;
            int start;
            char nextc;
            next = ParseIntRanges.nextSep(str, pos);
            char c = nextc = pos < next ? str.charAt(pos) : (char)'\u0000';
            if (next == pos || nextc == '.' && (next - pos == 2 && str.charAt(pos + 1) == '.' || next - pos == 3 && str.charAt(pos + 1) == '.' && str.charAt(pos + 2) == '.')) {
                if (ints.size() == 0 || next == str.length()) {
                    throw new NumberFormatException("Not a valid integer range.");
                }
                if (ints.size() == 1) {
                    start = ints.get(0);
                    step = last == Integer.MAX_VALUE ? 1 : start - last;
                    pos = next + 1;
                    next = ParseIntRanges.nextSep(str, pos);
                    last = ParseUtil.parseIntBase10(str, pos, next);
                    generators.add(new LinearIntGenerator(start, step, last));
                    ints.clear();
                } else {
                    assert (ints.size() > 1);
                    start = ints.get(ints.size() - 2);
                    step = ints.get(ints.size() - 1) - start;
                    ints.remove(ints.size() - 2, 2);
                    while (!ints.isEmpty() && ints.get(ints.size() - 1) == start - step) {
                        start -= step;
                        ints.remove(ints.size() - 1, 1);
                    }
                    if (!ints.isEmpty()) {
                        generators.add(new StaticIntGenerator(ints.toArray()));
                    }
                    pos = next + 1;
                    next = ParseIntRanges.nextSep(str, pos);
                    last = ParseUtil.parseIntBase10(str, pos, next);
                    generators.add(new LinearIntGenerator(start, step, last));
                    ints.clear();
                }
            } else if (nextc == '+' && (next - pos == 1 || next - pos == 2 && str.charAt(pos + 1) == '+' || next - pos > 2 && str.charAt(pos + 1) == '=')) {
                if (ints.size() == 0 || next == str.length()) {
                    throw new NumberFormatException("Not a valid integer range.");
                }
                start = ints.get(ints.size() - 1);
                step = pos + 2 < next ? ParseUtil.parseIntBase10(str, pos + 2, next) : 1;
                ints.remove(ints.size() - 1, 1);
                while (!ints.isEmpty() && ints.get(ints.size() - 1) == start - step) {
                    start -= step;
                    ints.remove(ints.size() - 1, 1);
                }
                if (!ints.isEmpty()) {
                    generators.add(new StaticIntGenerator(ints.toArray()));
                }
                pos = next + 1;
                next = ParseIntRanges.nextSep(str, pos);
                last = ParseUtil.parseIntBase10(str, pos, next);
                generators.add(new LinearIntGenerator(start, step, last));
                ints.clear();
            } else if (nextc == '*' && next - pos > 2 && str.charAt(pos + 1) == '=') {
                if (ints.size() == 0 || next == str.length()) {
                    throw new NumberFormatException("Not a valid integer range.");
                }
                start = ints.get(ints.size() - 1);
                int factor = ParseUtil.parseIntBase10(str, pos + 2, next);
                ints.remove(ints.size() - 1, 1);
                while (ints.size() > 2 && ints.get(ints.size() - 1) * factor == start) {
                    start = ints.get(ints.size() - 1);
                    ints.remove(ints.size() - 1, 1);
                }
                if (!ints.isEmpty()) {
                    generators.add(new StaticIntGenerator(ints.toArray()));
                }
                pos = next + 1;
                next = ParseIntRanges.nextSep(str, pos);
                last = ParseUtil.parseIntBase10(str, pos, next);
                generators.add(new ExponentialIntGenerator(start, factor, last));
                ints.clear();
            } else {
                ints.add(ParseUtil.parseIntBase10(str, pos, next));
            }
            pos = next + 1;
        }
        if (!ints.isEmpty()) {
            generators.add(new StaticIntGenerator(ints.toArray()));
        }
        return generators.size() == 1 ? (IntGenerator)generators.get(0) : new CombinedIntGenerator(generators);
    }

    private static int nextSep(String str, int start) {
        int next = str.indexOf(44, start);
        return next == -1 ? str.length() : next;
    }
}

