/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.datastructures.iterator;

import elki.utilities.datastructures.iterator.EmptyIterator;
import elki.utilities.datastructures.iterator.FilteredIt;
import elki.utilities.datastructures.iterator.Iter;
import elki.utilities.datastructures.iterator.SubtypeIt;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;

public interface It<O>
extends Iter {
    public O get();

    @Override
    public It<O> advance();

    default public <T> It<T> filter(Class<? super T> clz) {
        return this.valid() ? new SubtypeIt<T>(this, clz) : EmptyIterator.empty();
    }

    default public It<O> filter(Predicate<? super O> predicate) {
        return this.valid() ? new FilteredIt<O>(this, predicate) : EmptyIterator.empty();
    }

    default public boolean find(Object o) {
        while (this.valid()) {
            O cur = this.get();
            if (o == cur || o.equals(cur)) {
                return true;
            }
            this.advance();
        }
        return false;
    }

    default public void forEach(Consumer<? super O> action) {
        while (this.valid()) {
            action.accept(this.get());
            this.advance();
        }
    }

    default public <T extends Collection<? super O>> T collect(T c) {
        while (this.valid()) {
            c.add(this.get());
            this.advance();
        }
        return c;
    }
}

