/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.datastructures.iterator;

import elki.utilities.datastructures.iterator.It;
import java.util.function.Predicate;

public class FilteredIt<O>
implements It<O> {
    Predicate<? super O> filter;
    O current;
    private It<O> it;

    public FilteredIt(It<O> it, Predicate<? super O> clazz) {
        this.it = it;
        this.filter = clazz;
        this.current = null;
    }

    @Override
    public O get() {
        if (this.current == null && this.it.valid()) {
            this.advance();
        }
        return this.current;
    }

    @Override
    public boolean valid() {
        if (this.current == null && this.it.valid()) {
            this.advance();
        }
        return this.current != null;
    }

    @Override
    public FilteredIt<O> advance() {
        this.current = null;
        while (this.it.valid()) {
            O o = this.it.get();
            this.it.advance();
            if (!this.filter.test(o)) continue;
            this.current = o;
            break;
        }
        return this;
    }
}

