/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.datastructures.iterator;

import elki.utilities.datastructures.iterator.ArrayIter;
import elki.utilities.datastructures.iterator.It;
import java.util.List;

public class ArrayListIter<O>
implements ArrayIter,
It<O> {
    final List<O> data;
    int pos = 0;

    public ArrayListIter(List<O> data) {
        this.data = data;
    }

    @Override
    public boolean valid() {
        return this.pos < this.data.size() && this.pos >= 0;
    }

    @Override
    public ArrayListIter<O> advance() {
        ++this.pos;
        return this;
    }

    @Override
    public int getOffset() {
        return this.pos;
    }

    @Override
    public ArrayListIter<O> advance(int count) {
        this.pos += count;
        return this;
    }

    @Override
    public ArrayListIter<O> retract() {
        --this.pos;
        return this;
    }

    @Override
    public ArrayListIter<O> seek(int off) {
        this.pos = off;
        return this;
    }

    @Override
    public O get() {
        return this.data.get(this.pos);
    }
}

