/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.datastructures.hierarchy;

import elki.utilities.datastructures.hierarchy.Hierarchy;
import elki.utilities.datastructures.iterator.EmptyIterator;
import elki.utilities.datastructures.iterator.It;

public class StackedIter<B, A extends B>
implements It<B> {
    private It<? extends A> it1;
    private Hierarchy<B> hier2;
    private It<B> it2;

    public StackedIter(It<? extends A> it1, Hierarchy<B> hier2) {
        this.it1 = it1;
        this.hier2 = hier2;
        if (it1.valid()) {
            this.it2 = hier2.iterDescendants(it1.get());
            it1.advance();
        } else {
            this.it2 = EmptyIterator.empty();
        }
    }

    @Override
    public B get() {
        return this.it2.get();
    }

    @Override
    public boolean valid() {
        return this.it2.valid();
    }

    @Override
    public StackedIter<B, A> advance() {
        if (this.it2.valid()) {
            this.it2.advance();
        }
        while (!this.it2.valid() && this.it1.valid()) {
            this.it2 = this.hier2.iterDescendants(this.it1.get());
            this.it1.advance();
        }
        return this;
    }
}

