/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.datastructures.hierarchy;

import elki.utilities.datastructures.hierarchy.ModifiableHierarchy;
import elki.utilities.datastructures.iterator.EmptyIterator;
import elki.utilities.datastructures.iterator.It;
import java.util.Arrays;
import java.util.HashMap;

public class HashMapHierarchy<O>
implements ModifiableHierarchy<O> {
    private final HashMap<O, Rec<O>> graph;
    Object[] elems = new Object[11];
    int numelems = 0;

    public HashMapHierarchy() {
        this.graph = new HashMap();
    }

    @Override
    public boolean contains(O object) {
        return this.graph.containsKey(object);
    }

    @Override
    public int size() {
        return this.graph.size();
    }

    @Override
    public boolean add(O parent, O child) {
        boolean changed = false;
        Rec<O> rec = this.getRec(parent);
        if (rec == null) {
            rec = new Rec();
            this.putRec(parent, rec);
        }
        changed |= rec.addChild(child);
        rec = this.getRec(child);
        if (rec == null) {
            rec = new Rec();
            this.putRec(child, rec);
        }
        return changed |= rec.addParent(parent);
    }

    @Override
    public boolean add(O entry) {
        Rec<O> rec = this.getRec(entry);
        if (rec == null) {
            rec = new Rec();
            this.putRec(entry, rec);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(O parent, O child) {
        boolean changed = false;
        Rec<O> rec = this.getRec(parent);
        if (rec != null) {
            changed |= rec.removeChild(child);
        }
        if ((rec = this.getRec(child)) != null) {
            changed |= rec.removeParent(parent);
        }
        return changed;
    }

    @Override
    public boolean remove(O entry) {
        int i;
        Rec<O> rec = this.getRec(entry);
        if (rec == null) {
            return false;
        }
        for (i = 0; i < rec.nump; ++i) {
            this.getRec(rec.parents[i]).removeChild(entry);
            rec.parents[i] = null;
        }
        for (i = 0; i < rec.numc; ++i) {
            this.getRec(rec.children[i]).removeParent(entry);
            rec.children[i] = null;
        }
        this.removeRec(entry);
        return true;
    }

    @Override
    public boolean removeSubtree(O entry) {
        int i;
        Rec<O> rec = this.getRec(entry);
        if (rec == null) {
            return false;
        }
        for (i = 0; i < rec.nump; ++i) {
            this.getRec(rec.parents[i]).removeChild(entry);
            rec.parents[i] = null;
        }
        for (i = 0; i < rec.numc; ++i) {
            Rec<Object> crec = this.getRec(rec.children[i]);
            crec.removeParent(entry);
            if (crec.nump == 0) {
                this.removeSubtree(rec.children[i]);
            }
            rec.children[i] = null;
        }
        this.removeRec(entry);
        return true;
    }

    @Override
    public int numChildren(O obj) {
        Rec<O> rec = this.getRec(obj);
        return rec == null ? 0 : rec.numc;
    }

    @Override
    public It<O> iterChildren(O obj) {
        Rec<O> rec = this.getRec(obj);
        return rec == null ? EmptyIterator.empty() : rec.iterChildren();
    }

    @Override
    public It<O> iterChildrenReverse(O obj) {
        Rec<O> rec = this.getRec(obj);
        return rec == null ? EmptyIterator.empty() : rec.iterChildrenReverse();
    }

    @Override
    public It<O> iterDescendants(O obj) {
        return new ItrDesc(obj);
    }

    @Override
    public It<O> iterDescendantsSelf(O obj) {
        return new ItrDesc(obj, obj);
    }

    @Override
    public int numParents(O obj) {
        Rec<O> rec = this.getRec(obj);
        return rec == null ? 0 : rec.nump;
    }

    @Override
    public It<O> iterParents(O obj) {
        Rec<O> rec = this.getRec(obj);
        return rec == null ? EmptyIterator.empty() : rec.iterParents();
    }

    @Override
    public It<O> iterParentsReverse(O obj) {
        Rec<O> rec = this.getRec(obj);
        return rec == null ? EmptyIterator.empty() : rec.iterParentsReverse();
    }

    @Override
    public It<O> iterAncestors(O obj) {
        return new ItrAnc(obj);
    }

    @Override
    public It<O> iterAncestorsSelf(O obj) {
        return new ItrAnc(obj, obj);
    }

    @Override
    public It<O> iterAll() {
        return new ItrAll();
    }

    private Rec<O> getRec(O obj) {
        return this.graph.get(obj);
    }

    private void putRec(O obj, Rec<O> rec) {
        this.graph.put(obj, rec);
        for (int i = 0; i < this.numelems; ++i) {
            if (obj != this.elems[i]) continue;
            return;
        }
        if (this.elems.length == this.numelems) {
            this.elems = Arrays.copyOf(this.elems, (this.elems.length << 1) + 1);
        }
        this.elems[this.numelems++] = obj;
    }

    private void removeRec(O obj) {
        this.graph.remove(obj);
        for (int i = 0; i < this.numelems; ++i) {
            if (obj != this.elems[i]) continue;
            System.arraycopy(this.elems, i + 1, this.elems, i, --this.numelems - i);
            this.elems[this.numelems] = null;
            return;
        }
    }

    private class ItrAll
    implements It<O> {
        int pos;

        private ItrAll() {
        }

        @Override
        public boolean valid() {
            return this.pos < HashMapHierarchy.this.numelems;
        }

        @Override
        public O get() {
            return HashMapHierarchy.this.elems[this.pos];
        }

        @Override
        public ItrAll advance() {
            ++this.pos;
            return this;
        }
    }

    private class ItrAnc
    implements It<O> {
        final It<O> parentiter;
        It<O> subiter = null;
        O extra = null;

        ItrAnc(O start) {
            this(start, null);
        }

        ItrAnc(O start, O extra) {
            this.parentiter = HashMapHierarchy.this.iterParents(start);
            this.extra = extra;
        }

        @Override
        public boolean valid() {
            return this.extra != null || this.parentiter.valid() || this.subiter != null && this.subiter.valid();
        }

        @Override
        public It<O> advance() {
            if (this.extra != null) {
                this.extra = null;
                return this;
            }
            if (this.subiter == null) {
                assert (this.parentiter.valid());
                this.subiter = HashMapHierarchy.this.iterAncestors(this.parentiter.get());
            } else {
                this.subiter.advance();
            }
            if (this.subiter.valid()) {
                return this;
            }
            this.parentiter.advance();
            this.subiter = null;
            return this;
        }

        @Override
        public O get() {
            if (this.extra != null) {
                return this.extra;
            }
            if (this.subiter != null) {
                assert (this.subiter.valid());
                return this.subiter.get();
            }
            assert (this.parentiter.valid());
            return this.parentiter.get();
        }
    }

    private class ItrDesc
    implements It<O> {
        final It<O> childiter;
        It<O> subiter = null;
        O extra = null;

        ItrDesc(O start) {
            this(start, null);
        }

        ItrDesc(O start, O extra) {
            this.childiter = HashMapHierarchy.this.iterChildren(start);
            this.extra = extra;
        }

        @Override
        public boolean valid() {
            return this.extra != null || this.childiter.valid() || this.subiter != null && this.subiter.valid();
        }

        @Override
        public It<O> advance() {
            if (this.extra != null) {
                this.extra = null;
                return this;
            }
            if (this.subiter == null) {
                assert (this.childiter.valid());
                this.subiter = HashMapHierarchy.this.iterDescendants(this.childiter.get());
            } else {
                this.subiter.advance();
            }
            if (this.subiter.valid()) {
                return this;
            }
            this.childiter.advance();
            this.subiter = null;
            return this;
        }

        @Override
        public O get() {
            if (this.extra != null) {
                return this.extra;
            }
            if (this.subiter != null) {
                assert (this.subiter.valid());
                return this.subiter.get();
            }
            assert (this.childiter.valid());
            return this.childiter.get();
        }
    }

    protected static class Rec<O> {
        int nump = 0;
        int numc = 0;
        Object[] parents = EMPTY;
        Object[] children = EMPTY;
        private static final Object[] EMPTY = new Object[0];

        protected Rec() {
        }

        boolean addParent(O parent) {
            if (this.parents == EMPTY) {
                this.parents = new Object[1];
                this.parents[0] = parent;
                this.nump = 1;
                return true;
            }
            for (int i = 0; i < this.nump; ++i) {
                if (!parent.equals(this.parents[i])) continue;
                return false;
            }
            if (this.parents.length == this.nump) {
                int newsize = Math.max(5, (this.parents.length << 1) + 1);
                this.parents = Arrays.copyOf(this.parents, newsize);
            }
            this.parents[this.nump++] = parent;
            return true;
        }

        boolean addChild(O child) {
            if (this.children == EMPTY) {
                this.children = new Object[5];
                this.children[0] = child;
                this.numc = 1;
                return true;
            }
            for (int i = 0; i < this.numc; ++i) {
                if (!child.equals(this.children[i])) continue;
                return false;
            }
            if (this.children.length == this.numc) {
                this.children = Arrays.copyOf(this.children, (this.children.length << 1) + 1);
            }
            this.children[this.numc++] = child;
            return true;
        }

        boolean removeParent(O parent) {
            if (this.parents == EMPTY) {
                return false;
            }
            for (int i = 0; i < this.nump; ++i) {
                if (!parent.equals(this.parents[i])) continue;
                --this.nump;
                System.arraycopy(this.parents, i + 1, this.parents, i, this.nump - i);
                this.parents[this.nump] = null;
                if (this.nump == 0) {
                    this.parents = EMPTY;
                }
                return true;
            }
            return false;
        }

        boolean removeChild(O child) {
            if (this.children == EMPTY) {
                return false;
            }
            for (int i = 0; i < this.numc; ++i) {
                if (!child.equals(this.children[i])) continue;
                --this.numc;
                System.arraycopy(this.children, i + 1, this.children, i, this.numc - i);
                this.children[this.numc] = null;
                if (this.numc == 0) {
                    this.children = EMPTY;
                }
                return true;
            }
            return false;
        }

        public It<O> iterParents() {
            return this.nump == 0 ? EmptyIterator.empty() : new ItrParents();
        }

        public It<O> iterParentsReverse() {
            return this.nump == 0 ? EmptyIterator.empty() : new ItrParentsReverse();
        }

        public It<O> iterChildren() {
            return this.numc == 0 ? EmptyIterator.empty() : new ItrChildren();
        }

        public It<O> iterChildrenReverse() {
            return this.numc == 0 ? EmptyIterator.empty() : new ItrChildrenReverse();
        }

        private class ItrChildrenReverse
        implements It<O> {
            int pos;

            private ItrChildrenReverse() {
                this.pos = Rec.this.numc - 1;
            }

            @Override
            public boolean valid() {
                return this.pos >= 0;
            }

            @Override
            public It<O> advance() {
                --this.pos;
                return this;
            }

            @Override
            public O get() {
                return Rec.this.children[this.pos];
            }
        }

        private class ItrChildren
        implements It<O> {
            int pos = 0;

            private ItrChildren() {
            }

            @Override
            public boolean valid() {
                return this.pos < Rec.this.numc;
            }

            @Override
            public It<O> advance() {
                ++this.pos;
                return this;
            }

            @Override
            public O get() {
                return Rec.this.children[this.pos];
            }
        }

        private class ItrParentsReverse
        implements It<O> {
            int pos;

            private ItrParentsReverse() {
                this.pos = Rec.this.nump - 1;
            }

            @Override
            public boolean valid() {
                return this.pos >= 0;
            }

            @Override
            public It<O> advance() {
                --this.pos;
                return this;
            }

            @Override
            public O get() {
                return Rec.this.parents[this.pos];
            }
        }

        private class ItrParents
        implements It<O> {
            int pos = 0;

            private ItrParents() {
            }

            @Override
            public boolean valid() {
                return this.pos < Rec.this.nump;
            }

            @Override
            public It<O> advance() {
                ++this.pos;
                return this;
            }

            @Override
            public O get() {
                return Rec.this.parents[this.pos];
            }
        }
    }
}

