/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.datastructures.heap;

public final class HeapUtil {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFFA;

    private HeapUtil() {
    }

    public static int nextPow2Int(int x) {
        --x;
        x |= x >>> 1;
        x |= x >>> 2;
        x |= x >>> 4;
        x |= x >>> 8;
        x |= x >>> 16;
        return ++x;
    }

    public static int nextSize(int current) {
        int newCapacity;
        int n = newCapacity = current < 64 ? ++current << 1 : current + (current >> 1);
        if (newCapacity < 0 || newCapacity > 0x7FFFFFFA) {
            if (current == 0x7FFFFFFA) {
                throw new OutOfMemoryError("Heap size overflowed");
            }
            return 0x7FFFFFFA;
        }
        return newCapacity;
    }
}

