/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.datastructures.heap;

import elki.utilities.datastructures.heap.DoubleHeap;
import elki.utilities.datastructures.heap.HeapUtil;
import java.util.Arrays;

public class DoubleMinHeap
implements DoubleHeap {
    protected double[] twoheap;
    protected int size;
    private static final int TWO_HEAP_INITIAL_SIZE = 31;

    public DoubleMinHeap() {
        this.twoheap = new double[31];
    }

    public DoubleMinHeap(int minsize) {
        this.twoheap = new double[HeapUtil.nextPow2Int(minsize + 1) - 1];
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.twoheap, 0.0);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void add(double o) {
        double co = o;
        if (this.size >= this.twoheap.length) {
            this.twoheap = Arrays.copyOf(this.twoheap, HeapUtil.nextSize(this.twoheap.length));
        }
        this.heapifyUp(this.size++, co);
    }

    @Override
    public void add(double key, int max) {
        if (this.size < max) {
            this.add(key);
        } else if (this.twoheap[0] < key) {
            this.replaceTopElement(key);
        }
    }

    @Override
    public double replaceTopElement(double reinsert) {
        double ret = this.twoheap[0];
        this.heapifyDown(reinsert);
        return ret;
    }

    private void heapifyUp(int twopos, double cur) {
        int parent;
        double par;
        while (twopos > 0 && !(cur >= (par = this.twoheap[parent = twopos - 1 >>> 1]))) {
            this.twoheap[twopos] = par;
            twopos = parent;
        }
        this.twoheap[twopos] = cur;
    }

    @Override
    public double poll() {
        if (this.size == 0) {
            return 0.0;
        }
        double ret = this.twoheap[0];
        if (--this.size >= 0) {
            double reinsert = this.twoheap[this.size];
            this.twoheap[this.size] = 0.0;
            this.heapifyDown(reinsert);
        }
        return ret;
    }

    private void heapifyDown(double cur) {
        int stop = this.size >>> 1;
        int twopos = 0;
        while (twopos < stop) {
            int bestchild = (twopos << 1) + 1;
            double best = this.twoheap[bestchild];
            int right = bestchild + 1;
            if (right < this.size && best > this.twoheap[right]) {
                bestchild = right;
                best = this.twoheap[right];
            }
            if (best >= cur) break;
            this.twoheap[twopos] = best;
            twopos = bestchild;
        }
        this.twoheap[twopos] = cur;
    }

    @Override
    public double peek() {
        return this.twoheap[0];
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(100 + 20 * this.size).append(DoubleMinHeap.class.getSimpleName()).append(" [");
        UnsortedIter iter = new UnsortedIter();
        while (iter.valid()) {
            buf.append(iter.get()).append(',');
            iter.advance();
        }
        return buf.append(']').toString();
    }

    @Override
    public UnsortedIter unsortedIter() {
        return new UnsortedIter();
    }

    private class UnsortedIter
    implements DoubleHeap.UnsortedIter {
        protected int pos = 0;

        private UnsortedIter() {
        }

        @Override
        public boolean valid() {
            return this.pos < DoubleMinHeap.this.size;
        }

        @Override
        public UnsortedIter advance() {
            ++this.pos;
            return this;
        }

        @Override
        public double get() {
            return DoubleMinHeap.this.twoheap[this.pos];
        }
    }
}

