/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.datastructures.heap;

import elki.utilities.datastructures.heap.DoubleIntegerHeap;
import elki.utilities.datastructures.heap.HeapUtil;
import java.util.Arrays;

public class DoubleIntegerMaxHeap
implements DoubleIntegerHeap {
    protected double[] twoheap;
    protected int[] twovals;
    protected int size;
    private static final int TWO_HEAP_INITIAL_SIZE = 31;

    public DoubleIntegerMaxHeap() {
        double[] twoheap = new double[31];
        int[] twovals = new int[31];
        this.twoheap = twoheap;
        this.twovals = twovals;
    }

    public DoubleIntegerMaxHeap(int minsize) {
        int size = HeapUtil.nextPow2Int(minsize + 1) - 1;
        double[] twoheap = new double[size];
        int[] twovals = new int[size];
        this.twoheap = twoheap;
        this.twovals = twovals;
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.twoheap, 0.0);
        Arrays.fill(this.twovals, 0);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void add(double o, int v) {
        double co = o;
        int cv = v;
        if (this.size >= this.twoheap.length) {
            this.twoheap = Arrays.copyOf(this.twoheap, HeapUtil.nextSize(this.twoheap.length));
            this.twovals = Arrays.copyOf(this.twovals, this.twoheap.length);
        }
        this.heapifyUp(this.size++, co, cv);
    }

    @Override
    public void add(double key, int val, int max) {
        if (this.size < max) {
            this.add(key, val);
        } else if (this.twoheap[0] > key) {
            this.replaceTopElement(key, val);
        }
    }

    @Override
    public void replaceTopElement(double reinsert, int val) {
        this.heapifyDown(reinsert, val);
    }

    private void heapifyUp(int twopos, double cur, int val) {
        int parent;
        double par;
        while (twopos > 0 && !(cur <= (par = this.twoheap[parent = twopos - 1 >>> 1]))) {
            this.twoheap[twopos] = par;
            this.twovals[twopos] = this.twovals[parent];
            twopos = parent;
        }
        this.twoheap[twopos] = cur;
        this.twovals[twopos] = val;
    }

    @Override
    public void poll() {
        if (this.size > 0 && --this.size > 0) {
            double reinsert = this.twoheap[this.size];
            int reinsertv = this.twovals[this.size];
            this.twoheap[this.size] = 0.0;
            this.twovals[this.size] = 0;
            this.heapifyDown(reinsert, reinsertv);
        }
    }

    private void heapifyDown(double cur, int val) {
        int stop = this.size >>> 1;
        int twopos = 0;
        while (twopos < stop) {
            int bestchild = (twopos << 1) + 1;
            double best = this.twoheap[bestchild];
            int right = bestchild + 1;
            if (right < this.size && best <= this.twoheap[right]) {
                bestchild = right;
                best = this.twoheap[right];
            }
            if (best <= cur) break;
            this.twoheap[twopos] = best;
            this.twovals[twopos] = this.twovals[bestchild];
            twopos = bestchild;
        }
        this.twoheap[twopos] = cur;
        this.twovals[twopos] = val;
    }

    @Override
    public double peekKey() {
        return this.twoheap[0];
    }

    @Override
    public int peekValue() {
        return this.twovals[0];
    }

    @Override
    public boolean containsKey(double q) {
        for (int pos = 0; pos < this.size; ++pos) {
            if (this.twoheap[pos] != q) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(int q) {
        for (int pos = 0; pos < this.size; ++pos) {
            if (this.twovals[pos] != q) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(100 + 10 * this.size).append(DoubleIntegerMaxHeap.class.getSimpleName()).append(" [");
        UnsortedIter iter = new UnsortedIter();
        while (iter.valid()) {
            buf.append(iter.getKey()).append(':').append(iter.getValue()).append(',');
            iter.advance();
        }
        return buf.append(']').toString();
    }

    @Override
    public UnsortedIter unsortedIter() {
        return new UnsortedIter();
    }

    private class UnsortedIter
    implements DoubleIntegerHeap.UnsortedIter {
        protected int pos = 0;

        private UnsortedIter() {
        }

        @Override
        public boolean valid() {
            return this.pos < DoubleIntegerMaxHeap.this.size;
        }

        @Override
        public UnsortedIter advance() {
            ++this.pos;
            return this;
        }

        @Override
        public double getKey() {
            return DoubleIntegerMaxHeap.this.twoheap[this.pos];
        }

        @Override
        public int getValue() {
            return DoubleIntegerMaxHeap.this.twovals[this.pos];
        }
    }
}

