/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.datastructures.arrays;

public final class DoubleIntegerArrayQuickSort {
    private static final int INSERTION_THRESHOLD = 22;

    private DoubleIntegerArrayQuickSort() {
    }

    public static void sort(double[] keys, int[] values, int len) {
        DoubleIntegerArrayQuickSort.sort(keys, values, 0, len);
    }

    public static void sort(double[] keys, int[] values, int start, int end) {
        DoubleIntegerArrayQuickSort.quickSort(keys, values, start, end);
    }

    private static void quickSort(double[] keys, int[] vals, int start, int end) {
        int rstart;
        int len = end - start;
        if (len < 22) {
            DoubleIntegerArrayQuickSort.insertionSort(keys, vals, start, end);
            return;
        }
        int last = end - 1;
        int seventh = (len >> 3) + (len >> 6) + 1;
        int m3 = start + end >>> 1;
        int m2 = m3 - seventh;
        int m4 = m3 + seventh;
        DoubleIntegerArrayQuickSort.sort5(keys, vals, m2 - seventh, m2, m3, m4, m4 + seventh);
        double pivotkey = keys[m3];
        int pivotval = vals[m3];
        keys[m3] = keys[start];
        vals[m3] = vals[start];
        int left = start + 1;
        int right = last;
        while (true) {
            if (left <= right && keys[left] < pivotkey) {
                ++left;
                continue;
            }
            while (left <= right && pivotkey <= keys[right]) {
                --right;
            }
            if (right <= left) break;
            DoubleIntegerArrayQuickSort.swap(keys, vals, left++, right--);
        }
        keys[start] = keys[right];
        vals[start] = vals[right];
        keys[right] = pivotkey;
        vals[right] = pivotval;
        if (start + 1 < right) {
            DoubleIntegerArrayQuickSort.quickSort(keys, vals, start, right);
        }
        for (rstart = right + 1; rstart < last && keys[rstart] <= keys[right]; ++rstart) {
        }
        if (rstart < last) {
            DoubleIntegerArrayQuickSort.quickSort(keys, vals, rstart, end);
        }
    }

    private static void sort5(double[] keys, int[] vals, int m1, int m2, int m3, int m4, int m5) {
        if (keys[m1] > keys[m2]) {
            DoubleIntegerArrayQuickSort.swap(keys, vals, m1, m2);
        }
        if (keys[m3] > keys[m4]) {
            DoubleIntegerArrayQuickSort.swap(keys, vals, m3, m4);
        }
        if (keys[m2] > keys[m4]) {
            DoubleIntegerArrayQuickSort.swap(keys, vals, m2, m4);
        }
        if (keys[m1] > keys[m3]) {
            DoubleIntegerArrayQuickSort.swap(keys, vals, m1, m3);
        }
        if (keys[m2] > keys[m3]) {
            DoubleIntegerArrayQuickSort.swap(keys, vals, m2, m3);
        }
        if (keys[m4] > keys[m5]) {
            DoubleIntegerArrayQuickSort.swap(keys, vals, m4, m5);
            if (keys[m3] > keys[m4]) {
                DoubleIntegerArrayQuickSort.swap(keys, vals, m3, m4);
                if (keys[m2] > keys[m3]) {
                    DoubleIntegerArrayQuickSort.swap(keys, vals, m2, m3);
                    if (keys[m1] > keys[m1]) {
                        DoubleIntegerArrayQuickSort.swap(keys, vals, m1, m2);
                    }
                }
            }
        }
    }

    private static void insertionSort(double[] keys, int[] vals, int start, int end) {
        for (int i = start + 1; i < end; ++i) {
            for (int j = i; j > start && !(keys[j] >= keys[j - 1]); --j) {
                DoubleIntegerArrayQuickSort.swap(keys, vals, j, j - 1);
            }
        }
    }

    public static void sortReverse(double[] keys, int[] values, int len) {
        DoubleIntegerArrayQuickSort.sortReverse(keys, values, 0, len);
    }

    public static void sortReverse(double[] keys, int[] values, int start, int end) {
        DoubleIntegerArrayQuickSort.quickSortReverse(keys, values, start, end);
    }

    private static void quickSortReverse(double[] keys, int[] vals, int start, int end) {
        int rstart;
        int len = end - start;
        if (len < 22) {
            DoubleIntegerArrayQuickSort.insertionSortReverse(keys, vals, start, end);
            return;
        }
        int last = end - 1;
        int seventh = (len >> 3) + (len >> 6) + 1;
        int m3 = start + end >>> 1;
        int m2 = m3 - seventh;
        int m4 = m3 + seventh;
        DoubleIntegerArrayQuickSort.sortReverse5(keys, vals, m2 - seventh, m2, m3, m4, m4 + seventh);
        double pivotkey = keys[m3];
        int pivotval = vals[m3];
        keys[m3] = keys[start];
        vals[m3] = vals[start];
        int left = start + 1;
        int right = last;
        while (true) {
            if (left <= right && keys[left] > pivotkey) {
                ++left;
                continue;
            }
            while (left <= right && pivotkey >= keys[right]) {
                --right;
            }
            if (right <= left) break;
            DoubleIntegerArrayQuickSort.swap(keys, vals, left++, right--);
        }
        keys[start] = keys[right];
        vals[start] = vals[right];
        keys[right] = pivotkey;
        vals[right] = pivotval;
        if (start + 1 < right) {
            DoubleIntegerArrayQuickSort.quickSortReverse(keys, vals, start, right);
        }
        for (rstart = right + 1; rstart < last && keys[rstart] >= keys[right]; ++rstart) {
        }
        if (rstart < last) {
            DoubleIntegerArrayQuickSort.quickSortReverse(keys, vals, rstart, end);
        }
    }

    private static void sortReverse5(double[] keys, int[] vals, int m1, int m2, int m3, int m4, int m5) {
        if (keys[m1] < keys[m2]) {
            DoubleIntegerArrayQuickSort.swap(keys, vals, m1, m2);
        }
        if (keys[m3] < keys[m4]) {
            DoubleIntegerArrayQuickSort.swap(keys, vals, m3, m4);
        }
        if (keys[m2] < keys[m4]) {
            DoubleIntegerArrayQuickSort.swap(keys, vals, m2, m4);
        }
        if (keys[m1] < keys[m3]) {
            DoubleIntegerArrayQuickSort.swap(keys, vals, m1, m3);
        }
        if (keys[m2] < keys[m3]) {
            DoubleIntegerArrayQuickSort.swap(keys, vals, m2, m3);
        }
        if (keys[m4] < keys[m5]) {
            DoubleIntegerArrayQuickSort.swap(keys, vals, m4, m5);
            if (keys[m3] < keys[m4]) {
                DoubleIntegerArrayQuickSort.swap(keys, vals, m3, m4);
                if (keys[m2] < keys[m3]) {
                    DoubleIntegerArrayQuickSort.swap(keys, vals, m2, m3);
                    if (keys[m1] < keys[m1]) {
                        DoubleIntegerArrayQuickSort.swap(keys, vals, m1, m2);
                    }
                }
            }
        }
    }

    private static void insertionSortReverse(double[] keys, int[] vals, int start, int end) {
        for (int i = start + 1; i < end; ++i) {
            for (int j = i; j > start && !(keys[j] <= keys[j - 1]); --j) {
                DoubleIntegerArrayQuickSort.swap(keys, vals, j, j - 1);
            }
        }
    }

    private static void swap(double[] keys, int[] vals, int j, int i) {
        double td = keys[j];
        keys[j] = keys[i];
        keys[i] = td;
        int ti = vals[j];
        vals[j] = vals[i];
        vals[i] = ti;
    }
}

