/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.datastructures;

import java.util.Comparator;
import java.util.List;

public class QuickSelect {
    private static final int SMALL = 47;
    public static final Adapter<double[]> DOUBLE_ADAPTER = new Adapter<double[]>(){

        @Override
        public void swap(double[] data, int i, int j) {
            double tmp = data[i];
            data[i] = data[j];
            data[j] = tmp;
        }

        @Override
        public int compare(double[] data, int i, int j) {
            return Double.compare(data[i], data[j]);
        }
    };
    public static final Adapter<int[]> INTEGER_ADAPTER = new Adapter<int[]>(){

        @Override
        public void swap(int[] data, int i, int j) {
            int tmp = data[i];
            data[i] = data[j];
            data[j] = tmp;
        }

        @Override
        public int compare(int[] data, int i, int j) {
            return Integer.compare(data[i], data[j]);
        }
    };
    public static final Adapter<float[]> FLOAT_ADAPTER = new Adapter<float[]>(){

        @Override
        public void swap(float[] data, int i, int j) {
            float tmp = data[i];
            data[i] = data[j];
            data[j] = tmp;
        }

        @Override
        public int compare(float[] data, int i, int j) {
            return Float.compare(data[i], data[j]);
        }
    };
    public static final Adapter<short[]> SHORT_ADAPTER = new Adapter<short[]>(){

        @Override
        public void swap(short[] data, int i, int j) {
            short tmp = data[i];
            data[i] = data[j];
            data[j] = tmp;
        }

        @Override
        public int compare(short[] data, int i, int j) {
            return Short.compare(data[i], data[j]);
        }
    };
    public static final Adapter<long[]> LONG_ADAPTER = new Adapter<long[]>(){

        @Override
        public void swap(long[] data, int i, int j) {
            long tmp = data[i];
            data[i] = data[j];
            data[j] = tmp;
        }

        @Override
        public int compare(long[] data, int i, int j) {
            return Long.compare(data[i], data[j]);
        }
    };
    public static final Adapter<byte[]> BYTE_ADAPTER = new Adapter<byte[]>(){

        @Override
        public void swap(byte[] data, int i, int j) {
            byte tmp = data[i];
            data[i] = data[j];
            data[j] = tmp;
        }

        @Override
        public int compare(byte[] data, int i, int j) {
            return Byte.compare(data[i], data[j]);
        }
    };
    public static final Adapter<char[]> CHAR_ADAPTER = new Adapter<char[]>(){

        @Override
        public void swap(char[] data, int i, int j) {
            char tmp = data[i];
            data[i] = data[j];
            data[j] = tmp;
        }

        @Override
        public int compare(char[] data, int i, int j) {
            return Character.compare(data[i], data[j]);
        }
    };

    private QuickSelect() {
    }

    private static int bestPivot(int rank, int m1, int m2, int m3, int m4, int m5) {
        return rank < m1 ? m1 : (rank > m5 ? m5 : (rank < m2 ? m2 : (rank > m4 ? m4 : m3)));
    }

    public static <T> void quickSelect(T data, Adapter<T> adapter, int start, int end, int rank) {
        while (true) {
            if (start + 47 > end) {
                QuickSelect.insertionSort(data, adapter, start, end);
                return;
            }
            int len = end - start;
            int seventh = (len >> 3) + (len >> 6) + 1;
            int m3 = start + end >> 1;
            int m2 = m3 - seventh;
            int m1 = m2 - seventh;
            int m4 = m3 + seventh;
            int m5 = m4 + seventh;
            if (adapter.compare(data, m1, m2) > 0) {
                adapter.swap(data, m1, m2);
            }
            if (adapter.compare(data, m1, m3) > 0) {
                adapter.swap(data, m1, m3);
            }
            if (adapter.compare(data, m2, m3) > 0) {
                adapter.swap(data, m2, m3);
            }
            if (adapter.compare(data, m4, m5) > 0) {
                adapter.swap(data, m4, m5);
            }
            if (adapter.compare(data, m1, m4) > 0) {
                adapter.swap(data, m1, m4);
            }
            if (adapter.compare(data, m3, m4) > 0) {
                adapter.swap(data, m3, m4);
            }
            if (adapter.compare(data, m2, m5) > 0) {
                adapter.swap(data, m2, m5);
            }
            if (adapter.compare(data, m2, m3) > 0) {
                adapter.swap(data, m2, m3);
            }
            if (adapter.compare(data, m4, m5) > 0) {
                adapter.swap(data, m4, m5);
            }
            int best = QuickSelect.bestPivot(rank, m1, m2, m3, m4, m5);
            adapter.swap(data, best, end - 1);
            int i = start;
            int j = end - 2;
            while (true) {
                if (i <= j && adapter.compare(data, end - 1, i) >= 0) {
                    ++i;
                    continue;
                }
                while (j >= i && adapter.compare(data, end - 1, j) <= 0) {
                    --j;
                }
                if (i >= j) break;
                adapter.swap(data, i, j);
            }
            adapter.swap(data, i, end - 1);
            while (rank < i && adapter.compare(data, i, i - 1) == 0) {
                --i;
            }
            while (rank > i && adapter.compare(data, i, i + 1) == 0) {
                ++i;
            }
            if (rank < i) {
                end = i;
                continue;
            }
            if (rank <= i) break;
            start = i + 1;
        }
    }

    private static <T> void insertionSort(T data, Adapter<T> adapter, int start, int end) {
        for (int i = start + 1; i < end; ++i) {
            for (int j = i; j > start && adapter.compare(data, j - 1, j) > 0; --j) {
                adapter.swap(data, j, j - 1);
            }
        }
        adapter.isSorted(data, start, end);
    }

    public static double quickSelect(double[] data, int rank) {
        QuickSelect.quickSelect(data, 0, data.length, rank);
        return data[rank];
    }

    public static double median(double[] data) {
        return QuickSelect.median(data, 0, data.length);
    }

    public static double median(double[] data, int begin, int end) {
        int length = end - begin;
        assert (length > 0);
        int left = begin + (length - 1 >> 1);
        QuickSelect.quickSelect(data, begin, end, left);
        if (length % 2 == 1) {
            return data[left];
        }
        QuickSelect.quickSelect(data, left + 1, end, left + 1);
        return data[left] + 0.5 * (data[left + 1] - data[left]);
    }

    public static double quantile(double[] data, double quant) {
        return QuickSelect.quantile(data, 0, data.length, quant);
    }

    public static double quantile(double[] data, int begin, int end, double quant) {
        int length = end - begin;
        assert (length > 0) : "Quantile on empty set?";
        double dleft = (double)begin + (double)(length - 1) * quant;
        int ileft = (int)Math.floor(dleft);
        double err = dleft - (double)ileft;
        QuickSelect.quickSelect(data, begin, end, ileft);
        if (err <= Double.MIN_NORMAL) {
            return data[ileft];
        }
        QuickSelect.quickSelect(data, ileft + 1, end, ileft + 1);
        return data[ileft] + (data[ileft + 1] - data[ileft]) * err;
    }

    public static double quickSelect(double[] data, int start, int end, int rank) {
        while (true) {
            if (start + 47 > end) {
                QuickSelect.insertionSort(data, start, end);
                return data[rank];
            }
            int len = end - start;
            int seventh = (len >> 3) + (len >> 6) + 1;
            int m3 = start + end >> 1;
            int m2 = m3 - seventh;
            int m1 = m2 - seventh;
            int m4 = m3 + seventh;
            int m5 = m4 + seventh;
            if (data[m1] > data[m2]) {
                QuickSelect.swap(data, m1, m2);
            }
            if (data[m1] > data[m3]) {
                QuickSelect.swap(data, m1, m3);
            }
            if (data[m2] > data[m3]) {
                QuickSelect.swap(data, m2, m3);
            }
            if (data[m4] > data[m5]) {
                QuickSelect.swap(data, m4, m5);
            }
            if (data[m1] > data[m4]) {
                QuickSelect.swap(data, m1, m4);
            }
            if (data[m3] > data[m4]) {
                QuickSelect.swap(data, m3, m4);
            }
            if (data[m2] > data[m5]) {
                QuickSelect.swap(data, m2, m5);
            }
            if (data[m2] > data[m3]) {
                QuickSelect.swap(data, m2, m3);
            }
            if (data[m4] > data[m5]) {
                QuickSelect.swap(data, m4, m5);
            }
            int best = QuickSelect.bestPivot(rank, m1, m2, m3, m4, m5);
            double pivot = data[best];
            QuickSelect.swap(data, best, end - 1);
            int i = start;
            int j = end - 2;
            while (true) {
                if (i <= j && data[i] <= pivot) {
                    ++i;
                    continue;
                }
                while (j >= i && data[j] >= pivot) {
                    --j;
                }
                if (i >= j) break;
                QuickSelect.swap(data, i, j);
                ++i;
                --j;
            }
            QuickSelect.swap(data, i, end - 1);
            while (rank < i && data[i - 1] == pivot) {
                --i;
            }
            while (rank > i && data[i + 1] == pivot) {
                ++i;
            }
            if (rank < i) {
                end = i;
                continue;
            }
            if (rank <= i) break;
            start = i + 1;
        }
        return data[rank];
    }

    private static void insertionSort(double[] data, int start, int end) {
        for (int i = start + 1; i < end; ++i) {
            for (int j = i; j > start && data[j - 1] > data[j]; --j) {
                QuickSelect.swap(data, j, j - 1);
            }
        }
    }

    private static void swap(double[] data, int a, int b) {
        double tmp = data[a];
        data[a] = data[b];
        data[b] = tmp;
    }

    private static <T> void swap(List<T> data, int a, int b) {
        data.set(b, data.set(a, data.get(b)));
    }

    public static <T> T quickSelect(List<? extends T> data, Comparator<? super T> comparator, int rank) {
        QuickSelect.quickSelect(data, comparator, 0, data.size(), rank);
        return data.get(rank);
    }

    public static <T> T median(List<? extends T> data, Comparator<? super T> comparator) {
        return QuickSelect.median(data, comparator, 0, data.size());
    }

    public static <T> T median(List<? extends T> data, Comparator<? super T> comparator, int begin, int end) {
        int length = end - begin;
        assert (length > 0);
        int left = begin + (length - 1 >> 1);
        QuickSelect.quickSelect(data, comparator, begin, end, left);
        return data.get(left);
    }

    public static <T> T quantile(List<? extends T> data, Comparator<? super T> comparator, double quant) {
        return QuickSelect.quantile(data, comparator, 0, data.size(), quant);
    }

    public static <T> T quantile(List<? extends T> data, Comparator<? super T> comparator, int begin, int end, double quant) {
        int length = end - begin;
        assert (length > 0) : "Quantile on empty set?";
        double dleft = (double)begin + (double)(length - 1) * quant;
        int ileft = (int)Math.floor(dleft);
        QuickSelect.quickSelect(data, comparator, begin, end, ileft);
        return data.get(ileft);
    }

    public static <T> void quickSelect(List<? extends T> data, Comparator<? super T> comparator, int start, int end, int rank) {
        while (true) {
            if (start + 47 > end) {
                QuickSelect.insertionSort(data, comparator, start, end);
                return;
            }
            int len = end - start;
            int seventh = (len >> 3) + (len >> 6) + 1;
            int m3 = start + end >> 1;
            int m2 = m3 - seventh;
            int m1 = m2 - seventh;
            int m4 = m3 + seventh;
            int m5 = m4 + seventh;
            if (comparator.compare(data.get(m1), data.get(m2)) > 0) {
                QuickSelect.swap(data, m1, m2);
            }
            if (comparator.compare(data.get(m1), data.get(m3)) > 0) {
                QuickSelect.swap(data, m1, m3);
            }
            if (comparator.compare(data.get(m2), data.get(m3)) > 0) {
                QuickSelect.swap(data, m2, m3);
            }
            if (comparator.compare(data.get(m4), data.get(m5)) > 0) {
                QuickSelect.swap(data, m4, m5);
            }
            if (comparator.compare(data.get(m1), data.get(m4)) > 0) {
                QuickSelect.swap(data, m1, m4);
            }
            if (comparator.compare(data.get(m3), data.get(m4)) > 0) {
                QuickSelect.swap(data, m3, m4);
            }
            if (comparator.compare(data.get(m2), data.get(m5)) > 0) {
                QuickSelect.swap(data, m2, m5);
            }
            if (comparator.compare(data.get(m2), data.get(m3)) > 0) {
                QuickSelect.swap(data, m2, m3);
            }
            if (comparator.compare(data.get(m4), data.get(m5)) > 0) {
                QuickSelect.swap(data, m4, m5);
            }
            int best = QuickSelect.bestPivot(rank, m1, m2, m3, m4, m5);
            T pivot = data.get(best);
            QuickSelect.swap(data, best, end - 1);
            int i = start;
            int j = end - 2;
            while (true) {
                if (i <= j && comparator.compare(data.get(i), pivot) <= 0) {
                    ++i;
                    continue;
                }
                while (j >= i && comparator.compare(data.get(j), pivot) >= 0) {
                    --j;
                }
                if (i >= j) break;
                QuickSelect.swap(data, i, j);
            }
            QuickSelect.swap(data, i, end - 1);
            while (rank < i && comparator.compare(data.get(i - 1), pivot) == 0) {
                --i;
            }
            while (rank > i && comparator.compare(data.get(i + 1), pivot) == 0) {
                ++i;
            }
            if (rank < i) {
                end = i;
                continue;
            }
            if (rank <= i) break;
            start = i + 1;
        }
    }

    private static <T> void insertionSort(List<T> data, Comparator<? super T> comparator, int start, int end) {
        for (int i = start + 1; i < end; ++i) {
            for (int j = i; j > start && comparator.compare(data.get(j - 1), data.get(j)) > 0; --j) {
                QuickSelect.swap(data, j, j - 1);
            }
        }
    }

    public static interface Adapter<T> {
        public void swap(T var1, int var2, int var3);

        public int compare(T var1, int var2, int var3);

        default public void isSorted(T data, int begin, int end) {
        }
    }
}

