/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.datastructures;

import elki.utilities.datastructures.KuhnMunkres;
import elki.utilities.documentation.Reference;
import java.util.Arrays;
import java.util.logging.Level;

@Reference(authors="J. K. Wong", title="A new implementation of an algorithm for the optimal assignment problem: An improved version of Munkres' algorithm", booktitle="BIT Numerical Mathematics 19(3)", url="https://doi.org/10.1007/BF01930994", bibkey="doi:10.1007/BF01930994")
public class KuhnMunkresWong
extends KuhnMunkres {
    double[] radj;
    double[] cadj;
    double[] rmin;
    int[] rptr;

    @Override
    public int[] run(double[][] cost) {
        int collen = cost[0].length;
        int rowlen = cost.length;
        if (collen < rowlen) {
            throw new IllegalStateException("Cost matrix must not have fewer columns than rows.");
        }
        this.initialize(cost);
        this.initialCover();
        if (this.selected == rowlen) {
            this.debugLogMatrix(Level.FINEST, -1L, "trivial solution");
            return this.rsel;
        }
        this.rmark = new int[rowlen];
        this.cmark = (int[])this.csel.clone();
        this.rmin = new double[rowlen];
        this.rptr = new int[rowlen];
        for (long maxit = (long)rowlen * (long)collen; maxit >= 0L && this.selected < rowlen; --maxit) {
            this.initUncoveredMinimum();
            while (true) {
                double h = this.findUncoveredMinimum();
                this.debugLogMatrix(Level.FINEST, maxit, "Select min");
                this.removeCost(h);
                if (!this.pivot()) break;
                this.debugLogMatrix(Level.FINEST, maxit, "Pivoted");
            }
            this.debugLogMatrix(Level.FINEST, maxit, "Update stars");
            this.updateStars();
            System.arraycopy(this.csel, 0, this.cmark, 0, this.csel.length);
        }
        this.debugLogMatrix(Level.FINEST, 0L, "end " + this.selected);
        assert (this.selected == rowlen);
        return this.rsel;
    }

    @Override
    protected void initialize(double[][] cost) {
        this.cost = cost;
        int rowlen = cost.length;
        int collen = cost[0].length;
        this.radj = new double[rowlen];
        double[] radj = this.radj;
        for (int i = 0; i < cost.length; ++i) {
            double[] row = cost[i];
            if (row.length != collen) {
                throw new IllegalStateException("Cost matrix is not rectangular.");
            }
            double m = row[0];
            for (int j = 1; j < row.length; ++j) {
                double v = row[j];
                m = m <= v ? m : v;
            }
            radj[i] = m;
        }
        if (rowlen == collen) {
            this.cadj = (double[])cost[0].clone();
            double[] cadj = this.cadj;
            double radj0 = radj[0];
            int j = 0;
            while (j < cadj.length) {
                int n = j++;
                cadj[n] = cadj[n] - radj0;
            }
            for (int i = 1; i < cost.length; ++i) {
                double[] rowi = cost[i];
                double radji = radj[i];
                for (int j2 = 0; j2 < radj.length; ++j2) {
                    double v = rowi[j2] - radji;
                    double mj = cadj[j2];
                    if (!(v < mj)) continue;
                    cadj[j2] = v;
                }
            }
        } else {
            this.cadj = new double[collen];
        }
    }

    @Override
    protected void initialCover() {
        double[][] cost = this.cost;
        int rowlen = cost.length;
        int collen = cost[0].length;
        this.rsel = new int[rowlen];
        int[] rsel = this.rsel;
        this.csel = new int[collen];
        int[] csel = this.csel;
        Arrays.fill(rsel, -1);
        Arrays.fill(csel, -1);
        this.selected = 0;
        block0: for (int i = rsel.length - 1; i >= 0; --i) {
            double[] costi = cost[i];
            double radji = this.radj[i];
            for (int j = csel.length - 1; j >= 0; --j) {
                if (csel[j] >= 0 || costi[j] - radji - this.cadj[j] != 0.0) continue;
                rsel[i] = j;
                csel[j] = i;
                ++this.selected;
                continue block0;
            }
        }
    }

    protected void initUncoveredMinimum() {
        Arrays.fill(this.rmark, -1);
        for (int i = 0; i < this.cost.length; ++i) {
            double[] rowi = this.cost[i];
            double radji = this.radj[i];
            double m = Double.POSITIVE_INFINITY;
            int b = -1;
            for (int j = 0; j < rowi.length; ++j) {
                double v;
                if (this.cmark[j] >= 0 || !((v = rowi[j] - radji - this.cadj[j]) < m)) continue;
                m = v;
                b = j;
            }
            this.rmin[i] = m;
            this.rptr[i] = b;
        }
    }

    protected double findUncoveredMinimum() {
        this.minc = -1;
        this.minr = -1;
        double h = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.rmin.length; ++i) {
            double m;
            if (this.rmark[i] >= 0 || !((m = this.rmin[i]) < h)) continue;
            h = m;
            this.minr = i;
            this.minc = this.rptr[i];
        }
        assert (this.minr >= 0 && this.rsel[this.minr] != this.minc);
        return h;
    }

    protected void removeCost(double h) {
        if (h > 0.0) {
            for (int i = 0; i < this.rmark.length; ++i) {
                if (this.rmark[i] >= 0) {
                    int n = i;
                    this.radj[n] = this.radj[n] - h;
                    continue;
                }
                int n = i;
                this.rmin[n] = this.rmin[n] - h;
            }
            for (int j = 0; j < this.cmark.length; ++j) {
                int r = this.cmark[j];
                if (r >= 0 && this.rmark[r] != this.minr) continue;
                int n = j;
                this.cadj[n] = this.cadj[n] + h;
            }
        }
    }

    private boolean pivot() {
        assert (this.rmark[this.minr] < 0);
        for (int j = 0; j < this.cmark.length; ++j) {
            if (this.cmark[j] != this.minr) continue;
            assert (this.rsel[this.minr] >= 0);
            this.cmark[j] = -1;
            this.rmark[this.minr] = this.minc;
            double cadjj = this.cadj[j];
            for (int i = 0; i < this.rmin.length; ++i) {
                double c = this.cost[i][j] - this.radj[i] - cadjj;
                if (!(c < this.rmin[i])) continue;
                this.rmin[i] = c;
                this.rptr[i] = j;
            }
            return true;
        }
        return false;
    }

    private void updateStars() {
        while (this.minc >= 0) {
            int roldstar = this.csel[this.minc];
            assert (roldstar != this.minr);
            assert (this.rsel[this.minr] == -1);
            this.rsel[this.minr] = this.minc;
            this.csel[this.minc] = this.cmark[this.minc] = this.minr;
            ++this.selected;
            if (roldstar < 0) break;
            this.rsel[roldstar] = -1;
            --this.selected;
            this.minr = roldstar;
            this.minc = this.rmark[this.minr];
        }
    }

    @Override
    protected double costOf(int i, int j) {
        return this.cost[i][j] - this.radj[i] - this.cadj[j];
    }
}

