/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.datastructures;

import elki.utilities.datastructures.KuhnMunkresWong;
import elki.utilities.documentation.Reference;
import java.util.Arrays;
import java.util.logging.Level;

@Reference(authors="K. L. Stern", title="The Hungarian Algorithm for the Assignment Problem", booktitle="Online", url="http://software-and-algorithms.blogspot.com/2012/09/the-hungarian-algorithm-for-assignment.html", bibkey="web/Stern12")
public class KuhnMunkresStern
extends KuhnMunkresWong {
    private int[] cptr;
    private double[] cmin;

    @Override
    public int[] run(double[][] cost) {
        int collen = cost[0].length;
        int rowlen = cost.length;
        if (collen < rowlen) {
            throw new IllegalStateException("Cost matrix must not have fewer columns than rows.");
        }
        this.initialize(cost);
        this.initialCover();
        if (this.selected == rowlen) {
            this.debugLogMatrix(Level.FINEST, -1L, "trivial solution");
            return this.rsel;
        }
        this.rmark = new int[rowlen];
        this.cmark = (int[])this.csel.clone();
        this.cmin = new double[rowlen];
        this.cptr = new int[rowlen];
        block0: for (long maxit = (long)rowlen * (long)collen; maxit >= 0L && this.selected < rowlen; --maxit) {
            this.initUncoveredMinimum();
            block1: while (true) {
                double h = this.findUncoveredMinimum();
                this.removeCost(h);
                this.cmark[this.minc] = this.minr;
                if (this.csel[this.minc] < 0) {
                    int j = this.minc;
                    while (j >= 0) {
                        int i = this.cmark[j];
                        int nextj = this.rsel[i];
                        this.rsel[i] = j;
                        this.csel[j] = i;
                        j = nextj;
                    }
                    ++this.selected;
                    continue block0;
                }
                int i = this.csel[this.minc];
                this.rmark[i] = this.minc;
                double[] costi = cost[i];
                double radji = this.radj[i];
                int j = 0;
                while (true) {
                    double c;
                    if (j >= this.cmark.length) continue block1;
                    if (this.cmark[j] < 0 && (c = costi[j] - radji - this.cadj[j]) < this.cmin[j]) {
                        this.cmin[j] = c;
                        this.cptr[j] = i;
                    }
                    ++j;
                }
                break;
            }
        }
        return this.rsel;
    }

    @Override
    protected void initUncoveredMinimum() {
        int i = -1;
        while (++i < this.rsel.length && this.rsel[i] != -1) {
        }
        if (i == this.rsel.length) {
            return;
        }
        Arrays.fill(this.rmark, -1);
        Arrays.fill(this.cmark, -1);
        this.rmark[i] = Integer.MAX_VALUE;
        for (int j = 0; j < this.cost[i].length; ++j) {
            this.cmin[j] = this.cost[i][j] - this.radj[i] - this.cadj[j];
            this.cptr[j] = i;
        }
    }

    @Override
    protected double findUncoveredMinimum() {
        this.minc = -1;
        this.minr = -1;
        double h = Double.POSITIVE_INFINITY;
        for (int j = 0; j < this.cmark.length; ++j) {
            double m;
            if (this.cmark[j] >= 0 || !((m = this.cmin[j]) < h)) continue;
            h = m;
            this.minr = this.cptr[j];
            this.minc = j;
        }
        return h;
    }

    @Override
    protected void removeCost(double h) {
        if (h > 0.0) {
            for (int i = 0; i < this.rmark.length; ++i) {
                if (this.rmark[i] < 0) continue;
                int n = i;
                this.radj[n] = this.radj[n] + h;
            }
            for (int j = 0; j < this.cmark.length; ++j) {
                if (this.cmark[j] >= 0) {
                    int n = j;
                    this.cadj[n] = this.cadj[n] - h;
                    continue;
                }
                int n = j;
                this.cmin[n] = this.cmin[n] - h;
            }
        }
    }
}

