/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.datastructures;

import elki.logging.Logging;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import elki.utilities.io.FormatUtil;
import java.util.Arrays;
import java.util.logging.Level;

@References(value={@Reference(authors="H. W. Kuhn", title="The Hungarian method for the assignment problem", booktitle="Naval Research Logistics Quarterly 2", url="https://doi.org/10.1002/nav.3800020109", bibkey="doi:10.1002/nav.3800020109"), @Reference(authors="J. Munkres", title="Algorithms for the Assignment and Transportation Problems", booktitle="Journal of the Society for Industrial and Applied Mathematics 5(1)", url="https://doi.org/10.1137/0105003", bibkey="doi:10.1137/0105003")})
public class KuhnMunkres {
    private static final Logging LOG = Logging.getLogger(KuhnMunkres.class);
    double[][] cost;
    int selected;
    int[] rsel;
    int[] csel;
    int[] rmark;
    int[] cmark;
    int minr = -1;
    int minc = -1;

    public int[] run(double[][] cost) {
        int collen = cost[0].length;
        int rowlen = cost.length;
        if (collen < rowlen) {
            throw new IllegalStateException("Cost matrix must not have fewer columns than rows.");
        }
        this.initialize(cost);
        this.initialCover();
        if (this.selected == rowlen) {
            this.debugLogMatrix(Level.FINEST, -1L, "trivial solution");
            return this.rsel;
        }
        this.rmark = new int[rowlen];
        this.cmark = (int[])this.csel.clone();
        for (long maxit = (long)rowlen * (long)collen; maxit >= 0L && this.selected < rowlen; --maxit) {
            Arrays.fill(this.rmark, -1);
            while (true) {
                double h = this.findUncoveredMinimum();
                this.debugLogMatrix(Level.FINEST, maxit, "Select min");
                this.removeCost(h);
                if (!this.pivot()) break;
                this.debugLogMatrix(Level.FINEST, maxit, "Pivoted");
            }
            this.debugLogMatrix(Level.FINEST, maxit, "Update stars");
            this.updateStars();
            System.arraycopy(this.csel, 0, this.cmark, 0, this.csel.length);
        }
        this.debugLogMatrix(Level.FINEST, 0L, "end " + this.selected);
        assert (this.selected == rowlen);
        return this.rsel;
    }

    protected void initialize(double[][] ocost) {
        double[][] dArrayArray = new double[ocost.length][];
        this.cost = dArrayArray;
        double[][] cost = dArrayArray;
        int rowlen = ocost.length;
        int collen = ocost[0].length;
        for (int i = 0; i < rowlen; ++i) {
            int j;
            cost[i] = (double[])ocost[i].clone();
            double[] row = cost[i];
            if (row.length != collen) {
                throw new IllegalStateException("Cost matrix is not rectangular.");
            }
            double m = row[0];
            for (j = 1; j < row.length; ++j) {
                double v = row[j];
                assert (!Double.isNaN(v));
                m = m <= v ? m : v;
            }
            j = 0;
            while (j < row.length) {
                int n = j++;
                row[n] = row[n] - m;
            }
        }
        if (rowlen == collen) {
            int j;
            int i;
            double[] m = (double[])cost[0].clone();
            for (i = 1; i < rowlen; ++i) {
                double[] rowi = cost[i];
                for (j = 0; j < collen; ++j) {
                    double vj = rowi[j];
                    double mj = m[j];
                    if (!(vj < mj)) continue;
                    m[j] = vj;
                }
            }
            for (i = 0; i < rowlen; ++i) {
                double[] rowi = cost[i];
                for (j = 0; j < collen; ++j) {
                    int n = j;
                    rowi[n] = rowi[n] - m[j];
                }
            }
        }
    }

    protected void initialCover() {
        double[][] cost = this.cost;
        int rowlen = cost.length;
        int collen = cost[0].length;
        this.rsel = new int[rowlen];
        int[] rsel = this.rsel;
        this.csel = new int[collen];
        int[] csel = this.csel;
        Arrays.fill(rsel, -1);
        Arrays.fill(csel, -1);
        this.selected = 0;
        block0: for (int i = rsel.length - 1; i >= 0; --i) {
            double[] costi = cost[i];
            for (int j = csel.length - 1; j >= 0; --j) {
                if (csel[j] >= 0 || costi[j] != 0.0) continue;
                rsel[i] = j;
                csel[j] = i;
                ++this.selected;
                continue block0;
            }
        }
    }

    private double findUncoveredMinimum() {
        this.minc = -1;
        this.minr = -1;
        double h = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.cost.length; ++i) {
            if (this.rmark[i] >= 0) continue;
            double[] rowi = this.cost[i];
            for (int j = 0; j < rowi.length; ++j) {
                double v;
                if (this.cmark[j] >= 0 && this.rmark[this.cmark[j]] != i || !((v = rowi[j]) < h)) continue;
                h = v;
                this.minr = i;
                this.minc = j;
            }
        }
        assert (this.minr >= 0);
        return h;
    }

    private void removeCost(double h) {
        if (h > 0.0) {
            for (int i = 0; i < this.rmark.length; ++i) {
                int j;
                double[] rowi = this.cost[i];
                if (this.rmark[i] >= 0) {
                    for (j = 0; j < rowi.length; ++j) {
                        if (this.cmark[j] < 0 || this.rmark[this.cmark[j]] == this.minr) continue;
                        int n = j;
                        rowi[n] = rowi[n] + h;
                    }
                    continue;
                }
                for (j = 0; j < this.cmark.length; ++j) {
                    if (this.cmark[j] >= 0 && this.rmark[this.cmark[j]] != this.minr) continue;
                    int n = j;
                    rowi[n] = rowi[n] - h;
                }
            }
        }
    }

    private boolean pivot() {
        assert (this.rmark[this.minr] < 0);
        for (int j = 0; j < this.cmark.length; ++j) {
            if (this.cmark[j] != this.minr) continue;
            assert (this.rsel[this.minr] >= 0);
            this.cmark[j] = -1;
            this.rmark[this.minr] = this.minc;
            return true;
        }
        return false;
    }

    private void updateStars() {
        while (this.minc >= 0) {
            int roldstar = this.csel[this.minc];
            assert (roldstar != this.minr);
            assert (this.rsel[this.minr] == -1);
            this.rsel[this.minr] = this.minc;
            this.csel[this.minc] = this.cmark[this.minc] = this.minr;
            ++this.selected;
            if (roldstar < 0) break;
            this.rsel[roldstar] = -1;
            --this.selected;
            this.minr = roldstar;
            this.minc = this.rmark[this.minr];
        }
    }

    protected void debugLogMatrix(Level l, long maxit, String msg) {
        if (LOG.isLoggable(l)) {
            String padding = "      ";
            StringBuilder buf = new StringBuilder(this.cost.length * this.csel.length * 10 + 10).append('#').append(1L + (long)this.cost.length * (long)this.csel.length - maxit).append(' ').append(msg).append("\n");
            for (int i = 0; i < this.cost.length; ++i) {
                for (int j = 0; j < this.csel.length; ++j) {
                    int pos = buf.length();
                    if (this.rsel[i] == j) {
                        buf.append('*');
                    } else if (this.cmark != null && this.cmark[j] == i) {
                        buf.append('|');
                    }
                    buf.append(FormatUtil.NF2.format(this.costOf(i, j)));
                    int p = 7 - (buf.length() - pos);
                    if (p > 0) {
                        buf.insert(pos, padding, 0, p);
                    }
                    if (this.rmark != null && this.rmark[i] == j) {
                        buf.append('\'');
                    } else if (this.minr == i && this.minc == j) {
                        buf.append('!');
                    }
                    p = 8 - (buf.length() - pos);
                    if (p > 0) {
                        buf.append(padding, 0, p);
                    }
                    buf.append(' ');
                }
                buf.append(this.rmark != null && this.rmark[i] >= 0 ? "--\n" : "\n");
            }
            if (this.cmark != null) {
                for (int j = 0; j < this.cmark.length; ++j) {
                    buf.append(this.cmark[j] < 0 ? "         " : "    |    ");
                }
            }
            LOG.log(l, (CharSequence)buf.toString());
        }
    }

    protected double costOf(int i, int j) {
        return this.cost[i][j];
    }
}

