/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.datastructures;

import it.unimi.dsi.fastutil.Hash;
import java.util.Arrays;
import java.util.Random;

public final class BitsUtil {
    private static final int LONG_LOG2_SIZE = 6;
    private static final int LONG_LOG2_MASK = 63;
    private static final long LONG_ALL_BITS = -1L;
    private static final long LONG_63_BITS = Long.MAX_VALUE;
    private static final long LONG_32_BITS = 0xFFFFFFFFL;
    private static final int[] POW5_INT = new int[]{1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125};
    public static final Hash.Strategy<long[]> FASTUTIL_HASH_STRATEGY = new Hash.Strategy<long[]>(){

        public int hashCode(long[] o) {
            return BitsUtil.hashCode(o);
        }

        public boolean equals(long[] a, long[] b) {
            return BitsUtil.equal(a, b);
        }
    };

    private BitsUtil() {
    }

    public static long[] zero(int bits) {
        return new long[bits > 0 ? (bits - 1 >>> 6) + 1 : 1];
    }

    public static long[] make(int bits, long init) {
        long[] v = new long[(bits - 1 >>> 6) + 1];
        v[0] = init;
        return v;
    }

    public static long[] of(int ... positions) {
        int maxd = 0;
        for (int d : positions) {
            maxd = d > maxd ? d : maxd;
        }
        long[] dimensions = new long[(maxd >>> 6) + 1];
        for (int d : positions) {
            int n = d >>> 6;
            dimensions[n] = dimensions[n] | 1L << (d & 0x3F);
        }
        return dimensions;
    }

    public static long[] ones(int bits) {
        long[] v = new long[(bits - 1 >>> 6) + 1];
        BitsUtil.onesI(v, bits);
        return v;
    }

    public static long[] random(int card, int capacity, Random random) {
        if (card < 0 || card > capacity) {
            throw new IllegalArgumentException("Cannot set " + card + " out of " + capacity + " bits.");
        }
        if (card < capacity >>> 1) {
            long[] bitset = BitsUtil.zero(capacity);
            int todo = card;
            while (todo > 0) {
                BitsUtil.setI(bitset, random.nextInt(capacity));
                todo = todo == 1 ? card - BitsUtil.cardinality(bitset) : todo - 1;
            }
            return bitset;
        }
        long[] bitset = BitsUtil.ones(capacity);
        int todo = capacity - card;
        while (todo > 0) {
            BitsUtil.clearI(bitset, random.nextInt(capacity));
            todo = todo == 1 ? BitsUtil.cardinality(bitset) - card : todo - 1;
        }
        return bitset;
    }

    public static long[] copy(long[] v) {
        return Arrays.copyOf(v, v.length);
    }

    public static long[] copy(long[] v, int mincap) {
        int words = (mincap - 1 >>> 6) + 1;
        if (v.length == words) {
            return Arrays.copyOf(v, v.length);
        }
        long[] ret = new long[words];
        System.arraycopy(v, 0, ret, 0, Math.min(v.length, words));
        return ret;
    }

    public static long[] copy(long[] v, int mincap, int shift) {
        int end;
        int words = (mincap - 1 >>> 6) + 1;
        if (v.length == words && shift == 0) {
            return Arrays.copyOf(v, v.length);
        }
        long[] ret = new long[words];
        int shiftWords = shift >>> 6;
        int shiftBits = shift & 0x3F;
        if (shiftBits == 0) {
            for (int i = shiftWords; i < ret.length; ++i) {
                int n = i;
                ret[n] = ret[n] | v[i - shiftWords];
            }
            return ret;
        }
        int unshiftBits = 64 - shiftBits;
        int i = end = Math.min(ret.length, v.length + shiftWords) - 1;
        while (i > shiftWords) {
            int src = i - shiftWords;
            int n = i--;
            ret[n] = ret[n] | (v[src] << shiftBits | v[src - 1] >>> unshiftBits);
        }
        int n = shiftWords;
        ret[n] = ret[n] | v[0] << shiftBits;
        return ret;
    }

    public static long grayC(long v) {
        return v ^ v >>> 1;
    }

    public static long[] grayI(long[] v) {
        return BitsUtil.xorI(v, v, -1);
    }

    public static long invgrayC(long v) {
        v ^= v >>> 1;
        v ^= v >>> 2;
        v ^= v >>> 4;
        v ^= v >>> 8;
        v ^= v >>> 16;
        v ^= v >>> 32;
        return v;
    }

    public static long[] invgrayI(long[] v) {
        int i;
        int o;
        int last = v.length - 1;
        for (o = 1; o < 64; o <<= 1) {
            for (i = 0; i < last; ++i) {
                int n = i;
                v[n] = v[n] ^ (v[i] >>> o ^ v[i + 1] << 64 - o);
            }
            int n = last;
            v[n] = v[n] ^ v[last] >>> o;
        }
        for (o = 1; o <= last; o <<= 1) {
            for (i = o; i <= last; ++i) {
                int n = i - o;
                v[n] = v[n] ^ v[i];
            }
        }
        return v;
    }

    public static boolean isZero(long[] v) {
        for (int i = 0; i < v.length; ++i) {
            if (v[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public static int cardinality(long v) {
        return Long.bitCount(v);
    }

    public static int cardinality(long[] v) {
        int sum = 0;
        for (int i = 0; i < v.length; ++i) {
            sum += Long.bitCount(v[i]);
        }
        return sum;
    }

    public static long flipC(long v, int off) {
        return v ^ 1L << off;
    }

    public static long[] flipI(long[] v, int off) {
        int wordindex;
        int n = wordindex = off >>> 6;
        v[n] = v[n] ^ 1L << off;
        return v;
    }

    public static long setC(long v, int off) {
        return v | 1L << off;
    }

    public static long[] setI(long[] v, int off) {
        int wordindex;
        int n = wordindex = off >>> 6;
        v[n] = v[n] | 1L << off;
        return v;
    }

    public static long[] setI(long[] v, long[] o) {
        assert (o.length <= v.length) : "Bit set sizes do not agree.";
        System.arraycopy(o, 0, v, 0, Math.min(v.length, o.length));
        return v;
    }

    public static long clearC(long v, int off) {
        return v & (1L << off ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long[] clearI(long[] v, int off) {
        int wordindex;
        int n = wordindex = off >>> 6;
        v[n] = v[n] & (1L << off ^ 0xFFFFFFFFFFFFFFFFL);
        return v;
    }

    public static boolean get(long v, int off) {
        return (v & 1L << off) != 0L;
    }

    public static boolean get(long[] v, int off) {
        int wordindex = off >>> 6;
        return wordindex < v.length && (v[wordindex] & 1L << off) != 0L;
    }

    public static void onesI(long[] v, int bits) {
        int fillWords = bits >>> 6;
        int fillBits = bits & 0x3F;
        Arrays.fill(v, 0, fillWords, -1L);
        if (fillBits > 0) {
            v[fillWords] = (1L << fillBits) - 1L;
        }
        if (fillWords + 1 < v.length) {
            Arrays.fill(v, fillWords + 1, v.length, 0L);
        }
    }

    public static long[] zeroI(long[] v) {
        Arrays.fill(v, 0L);
        return v;
    }

    public static long[] xorI(long[] v, long[] o) {
        assert (o.length <= v.length) : "Bit set sizes do not agree.";
        for (int i = 0; i < o.length; ++i) {
            int n = i;
            v[n] = v[n] ^ o[i];
        }
        return v;
    }

    public static long[] xorI(long[] v, long[] o, int off) {
        if (off == 0) {
            return BitsUtil.xorI(v, o);
        }
        int shiftWords = off >> 6;
        int shiftBits = off & 0x3F;
        if (shiftWords >= v.length) {
            return v;
        }
        if (shiftBits == 0) {
            int i = Math.min(v.length, o.length + shiftWords);
            int j = i - shiftWords;
            while (i > 0 && j > 0) {
                int n = --i;
                v[n] = v[n] ^ o[--j];
            }
            return v;
        }
        int unshiftBits = 64 - shiftBits;
        int i = Math.min(v.length, o.length + shiftWords);
        int j = i - shiftWords;
        long t = o[--j];
        if (i < v.length) {
            int n = i;
            v[n] = v[n] ^ t >>> unshiftBits;
        }
        while (i > 0 && j > 0) {
            int n = --i;
            long l = t << shiftBits;
            t = o[--j];
            v[n] = v[n] ^ (l | t >>> unshiftBits);
        }
        if (i > 0) {
            int n = --i;
            v[n] = v[n] ^ t << shiftBits;
        }
        return v;
    }

    public static long[] orI(long[] v, long[] o) {
        assert (o.length <= v.length) : "Bit set sizes do not agree.";
        int max = Math.min(v.length, o.length);
        for (int i = 0; i < max; ++i) {
            int n = i;
            v[n] = v[n] | o[i];
        }
        return v;
    }

    public static long[] orI(long[] v, long[] o, int off) {
        if (off == 0) {
            return BitsUtil.orI(v, o);
        }
        int shiftWords = off >> 6;
        int shiftBits = off & 0x3F;
        if (shiftWords >= v.length) {
            return v;
        }
        if (shiftBits == 0) {
            int i = Math.min(v.length, o.length + shiftWords);
            int j = i - shiftWords;
            while (i > 0 && j > 0) {
                int n = --i;
                v[n] = v[n] | o[--j];
            }
            return v;
        }
        int unshiftBits = 64 - shiftBits;
        int i = Math.min(v.length, o.length + shiftWords);
        int j = i - shiftWords;
        long t = o[--j];
        if (i < v.length) {
            int n = i;
            v[n] = v[n] | t >>> unshiftBits;
        }
        while (i > 0 && j > 0) {
            int n = --i;
            long l = t << shiftBits;
            t = o[--j];
            v[n] = v[n] | (l | t >>> unshiftBits);
        }
        if (i > 0) {
            int n = --i;
            v[n] = v[n] | t << shiftBits;
        }
        return v;
    }

    public static long[] andI(long[] v, long[] o) {
        int i;
        for (i = 0; i < o.length; ++i) {
            int n = i;
            v[n] = v[n] & o[i];
        }
        Arrays.fill(v, i, v.length, 0L);
        return v;
    }

    public static long[] andI(long[] v, long[] o, int off) {
        if (off == 0) {
            return BitsUtil.andI(v, o);
        }
        int shiftWords = off >> 6;
        int shiftBits = off & 0x3F;
        if (shiftWords >= v.length) {
            return v;
        }
        if (shiftBits == 0) {
            int i = Math.min(v.length, o.length + shiftWords);
            int j = i - shiftWords;
            while (i > 0 && j > 0) {
                int n = --i;
                v[n] = v[n] & o[--j];
            }
            if (shiftWords > 0) {
                Arrays.fill(v, 0, shiftWords, 0L);
            }
            return v;
        }
        int unshiftBits = 64 - shiftBits;
        int i = Math.min(v.length, o.length + shiftWords);
        int j = i - shiftWords;
        long t = o[--j];
        if (i < v.length) {
            int n = i;
            v[n] = v[n] & t >>> unshiftBits;
        }
        while (i > 0 && j > 0) {
            int n = --i;
            long l = t << shiftBits;
            t = o[--j];
            v[n] = v[n] & (l | t >>> unshiftBits);
        }
        if (i > 0) {
            int n = --i;
            v[n] = v[n] & t << shiftBits;
        }
        Arrays.fill(v, 0, shiftWords, 0L);
        return v;
    }

    public static long[] andCMin(long[] v, long[] o) {
        int min = Math.min(v.length, o.length);
        long[] out = new long[min];
        for (int i = 0; i < min; ++i) {
            out[i] = v[i] & o[i];
        }
        return out;
    }

    public static long[] nandI(long[] v, long[] o) {
        for (int i = 0; i < o.length; ++i) {
            int n = i;
            v[n] = v[n] & (o[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return v;
    }

    public static long[] invertI(long[] v) {
        for (int i = 0; i < v.length; ++i) {
            v[i] = v[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return v;
    }

    public static long[] shiftRightI(long[] v, int off) {
        if (off == 0) {
            return v;
        }
        if (off < 0) {
            return BitsUtil.shiftLeftI(v, -off);
        }
        int shiftWords = off >>> 6;
        int shiftBits = off & 0x3F;
        if (shiftWords >= v.length) {
            return BitsUtil.zeroI(v);
        }
        if (shiftBits == 0) {
            System.arraycopy(v, shiftWords, v, 0, v.length - shiftWords);
            Arrays.fill(v, v.length - shiftWords, v.length, 0L);
            return v;
        }
        int unshiftBits = 64 - shiftBits;
        for (int i = 0; i < v.length - shiftWords - 1; ++i) {
            int src = i + shiftWords;
            v[i] = v[src + 1] << unshiftBits | v[src] >>> shiftBits;
        }
        v[v.length - shiftWords - 1] = v[v.length - 1] >>> shiftBits;
        Arrays.fill(v, v.length - shiftWords, v.length, 0L);
        return v;
    }

    public static long[] shiftLeftI(long[] v, int off) {
        if (off == 0) {
            return v;
        }
        if (off < 0) {
            return BitsUtil.shiftRightI(v, -off);
        }
        int shiftWords = off >>> 6;
        int shiftBits = off & 0x3F;
        if (shiftWords >= v.length) {
            return BitsUtil.zeroI(v);
        }
        if (shiftBits == 0) {
            System.arraycopy(v, 0, v, shiftWords, v.length - shiftWords);
            Arrays.fill(v, 0, shiftWords, 0L);
            return v;
        }
        int unshiftBits = 64 - shiftBits;
        for (int i = v.length - 1; i > shiftWords; --i) {
            int src = i - shiftWords;
            v[i] = v[src] << shiftBits | v[src - 1] >>> unshiftBits;
        }
        v[shiftWords] = v[0] << shiftBits;
        Arrays.fill(v, 0, shiftWords, 0L);
        return v;
    }

    public static long cycleRightC(long v, int shift, int len) {
        return shift == 0 ? v : (shift < 0 ? BitsUtil.cycleLeftC(v, -shift, len) : (v >>> shift | v << len - shift) & (long)((1 << len) - 1));
    }

    public static long[] cycleRightI(long[] v, int shift, int len) {
        long[] t = BitsUtil.copy(v, len, len - shift);
        return BitsUtil.orI(BitsUtil.shiftRightI(v, shift), BitsUtil.truncateI(t, len));
    }

    public static long[] truncateI(long[] v, int len) {
        int zap = v.length * 64 - len;
        int zapWords = zap >>> 6;
        int zapbits = zap & 0x3F;
        Arrays.fill(v, v.length - zapWords, v.length, 0L);
        if (zapbits > 0) {
            int n = v.length - zapWords - 1;
            v[n] = v[n] & -1L >>> zapbits;
        }
        return v;
    }

    public static long cycleLeftC(long v, int shift, int len) {
        return shift == 0 ? v : (shift < 0 ? BitsUtil.cycleRightC(v, -shift, len) : (v << shift | v >>> len - shift) & (long)((1 << len) - 1));
    }

    public static long[] cycleLeftI(long[] v, int shift, int len) {
        long[] t = BitsUtil.copy(v, len, shift);
        return BitsUtil.orI(BitsUtil.shiftRightI(v, len - shift), BitsUtil.truncateI(t, len));
    }

    public static String toString(long[] v) {
        if (v == null) {
            return "null";
        }
        int mag = BitsUtil.magnitude(v);
        if (mag == 0) {
            return "0";
        }
        char[] digits = new char[mag];
        int pos = mag - 1;
        block0: for (int w = 0; w < v.length; ++w) {
            long f = 1L;
            for (int i = 0; i < 64; ++i) {
                digits[pos] = (v[w] & f) == 0L ? 48 : 49;
                f <<= 1;
                if (--pos < 0) break block0;
            }
        }
        if (pos > 0) {
            Arrays.fill(digits, 0, pos, '0');
        }
        return new String(digits);
    }

    public static String toString(long[] v, int minw) {
        if (v == null) {
            return "null";
        }
        int mag = BitsUtil.magnitude(v);
        int n = mag = mag >= minw ? mag : minw;
        if (mag == 0) {
            return "0";
        }
        char[] digits = new char[mag];
        int pos = mag - 1;
        block0: for (int w = 0; w < v.length; ++w) {
            long f = 1L;
            for (int i = 0; i < 64; ++i) {
                digits[pos] = (v[w] & f) == 0L ? 48 : 49;
                f <<= 1;
                if (--pos < 0) break block0;
            }
        }
        while (pos >= 0) {
            digits[pos] = 48;
            --pos;
        }
        return new String(digits);
    }

    public static String toString(long v) {
        int mag = BitsUtil.magnitude(v);
        if (mag == 0) {
            return "0";
        }
        char[] digits = new char[mag];
        long f = 1L;
        int pos = mag - 1;
        while (pos >= 0) {
            digits[pos] = (v & f) == 0L ? 48 : 49;
            --pos;
            f <<= 1;
        }
        return new String(digits);
    }

    public static String toStringLow(long[] v) {
        if (v == null) {
            return "null";
        }
        int mag = BitsUtil.magnitude(v);
        if (mag == 0) {
            return "0";
        }
        char[] digits = new char[mag];
        int pos = 0;
        block0: for (int w = 0; w < v.length; ++w) {
            long f = 1L;
            for (int i = 0; i < 64; ++i) {
                digits[pos] = (v[w] & f) == 0L ? 48 : 49;
                f <<= 1;
                if (++pos >= mag) break block0;
            }
        }
        while (pos < mag) {
            digits[pos] = 48;
            ++pos;
        }
        return new String(digits);
    }

    public static String toStringLow(long[] v, int minw) {
        if (v == null) {
            return "null";
        }
        int mag = BitsUtil.magnitude(v);
        int n = mag = mag >= minw ? mag : minw;
        if (mag == 0) {
            return "0";
        }
        char[] digits = new char[mag];
        int pos = 0;
        block0: for (int w = 0; w < v.length; ++w) {
            long f = 1L;
            for (int i = 0; i < 64; ++i) {
                digits[pos] = (v[w] & f) == 0L ? 48 : 49;
                f <<= 1;
                if (++pos >= mag) break block0;
            }
        }
        while (pos < mag) {
            digits[pos] = 48;
            ++pos;
        }
        return new String(digits);
    }

    public static String toStringLow(long v) {
        int mag = BitsUtil.magnitude(v);
        if (mag == 0) {
            return "0";
        }
        char[] digits = new char[mag];
        long f = 1L;
        int pos = 0;
        while (pos < mag) {
            digits[pos] = (v & f) == 0L ? 48 : 49;
            ++pos;
            f <<= 1;
        }
        return new String(digits);
    }

    public static String toString(long[] v, String sep, int offset) {
        int p = BitsUtil.nextSetBit(v, 0);
        if (p < 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(p + offset);
        p = BitsUtil.nextSetBit(v, p + 1);
        while (p >= 0) {
            buf.append(sep).append(p + offset);
            p = BitsUtil.nextSetBit(v, p + 1);
        }
        return buf.toString();
    }

    public static int numberOfTrailingZerosSigned(long[] v) {
        int p = 0;
        while (p != v.length) {
            if (v[p] != 0L) {
                return Long.numberOfTrailingZeros(v[p]) + p * 64;
            }
            ++p;
        }
        return -1;
    }

    public static int numberOfTrailingZeros(long[] v) {
        int p = 0;
        while (p != v.length) {
            if (v[p] != 0L) {
                return Long.numberOfTrailingZeros(v[p]) + p * 64;
            }
            ++p;
        }
        return p * 64;
    }

    public static int numberOfTrailingZerosSigned(long v) {
        return v == 0L ? -1 : Long.numberOfTrailingZeros(v);
    }

    public static int numberOfTrailingZeros(long v) {
        return Long.numberOfTrailingZeros(v);
    }

    public static int numberOfTrailingZeros(int v) {
        return Integer.numberOfTrailingZeros(v);
    }

    public static int numberOfLeadingZerosSigned(long[] v) {
        int p = 0;
        int ip = v.length - 1;
        while (p < v.length) {
            if (v[ip] != 0L) {
                return Long.numberOfLeadingZeros(v[ip]) + p * 64;
            }
            ++p;
            --ip;
        }
        return -1;
    }

    public static int numberOfLeadingZeros(long[] v) {
        int p = 0;
        int ip = v.length - 1;
        while (p != v.length) {
            if (v[ip] != 0L) {
                return Long.numberOfLeadingZeros(v[ip]) + p * 64;
            }
            ++p;
            --ip;
        }
        return p * 64;
    }

    public static int numberOfLeadingZerosSigned(long v) {
        return v == 0L ? -1 : Long.numberOfLeadingZeros(v);
    }

    public static int numberOfLeadingZerosSigned(int v) {
        return v == 0 ? -1 : Integer.numberOfLeadingZeros(v);
    }

    public static int numberOfLeadingZeros(long v) {
        return Long.numberOfLeadingZeros(v);
    }

    public static int numberOfLeadingZeros(int v) {
        return Integer.numberOfLeadingZeros(v);
    }

    public static int previousSetBit(long v, int start) {
        if (start < 0) {
            return -1;
        }
        long cur = v & -1L >>> -((start = start < 64 ? start : 63) + 1);
        return cur == 0L ? -1 : (cur == -1L ? 0 : 63 - Long.numberOfLeadingZeros(cur));
    }

    public static int previousSetBit(long[] v, int start) {
        if (start < 0) {
            return -1;
        }
        int wordindex = start >>> 6;
        if (wordindex >= v.length) {
            return BitsUtil.magnitude(v) - 1;
        }
        int off = 63 - (start & 0x3F);
        long cur = v[wordindex] & -1L >>> off;
        while (cur == 0L) {
            if (wordindex == 0) {
                return -1;
            }
            cur = v[--wordindex];
        }
        return wordindex * 64 + 63 - (cur == -1L ? 0 : Long.numberOfLeadingZeros(cur));
    }

    public static int previousClearBit(long v, int start) {
        if (start < 0) {
            return -1;
        }
        start = start < 64 ? start : 63;
        long cur = (v ^ 0xFFFFFFFFFFFFFFFFL) & -1L >>> -(start + 1);
        return cur == 0L ? -1 : 63 - Long.numberOfLeadingZeros(cur);
    }

    public static int previousClearBit(long[] v, int start) {
        if (start < 0) {
            return -1;
        }
        int wordindex = start >>> 6;
        if (wordindex >= v.length) {
            return BitsUtil.magnitude(v) - 1;
        }
        int off = 63 - (start & 0x3F);
        long cur = (v[wordindex] ^ 0xFFFFFFFFFFFFFFFFL) & -1L >>> off;
        while (cur == 0L) {
            if (wordindex == 0) {
                return -1;
            }
            cur = v[--wordindex] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return wordindex * 64 + 63 - (cur == -1L ? 0 : Long.numberOfLeadingZeros(cur));
    }

    public static int nextSetBit(long v, int start) {
        if (start >= 64) {
            return -1;
        }
        long cur = v & -1L << (start = start < 0 ? 0 : start);
        return cur == 0L ? -1 : (cur == -1L ? 0 : Long.numberOfTrailingZeros(cur));
    }

    public static int nextSetBit(long[] v, int start) {
        int wordindex = (start = start < 0 ? 0 : start) >>> 6;
        if (wordindex >= v.length) {
            return -1;
        }
        long cur = v[wordindex] & -1L << start;
        while (cur == 0L) {
            if (++wordindex == v.length) {
                return -1;
            }
            cur = v[wordindex];
        }
        return wordindex * 64 + Long.numberOfTrailingZeros(cur);
    }

    public static int nextClearBit(long v, int start) {
        if (start >= 64) {
            return -1;
        }
        start = start < 0 ? 0 : start;
        long cur = (v ^ 0xFFFFFFFFFFFFFFFFL) & -1L << start;
        return cur == 0L ? -1 : Long.numberOfTrailingZeros(cur);
    }

    public static int nextClearBit(long[] v, int start) {
        int wordindex = (start = start < 0 ? 0 : start) >>> 6;
        if (wordindex >= v.length) {
            return -1;
        }
        long cur = (v[wordindex] ^ 0xFFFFFFFFFFFFFFFFL) & -1L << start;
        while (cur == 0L) {
            if (++wordindex == v.length) {
                return -1;
            }
            cur = v[wordindex] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return wordindex * 64 + Long.numberOfTrailingZeros(cur);
    }

    public static int magnitude(long[] v) {
        return BitsUtil.capacity(v) - BitsUtil.numberOfLeadingZeros(v);
    }

    public static int magnitude(long v) {
        return 64 - Long.numberOfLeadingZeros(v);
    }

    public static int magnitude(int v) {
        return 32 - Integer.numberOfLeadingZeros(v);
    }

    public static boolean intersect(long x, long y) {
        return (x & y) != 0L;
    }

    public static boolean intersect(long[] x, long[] y) {
        int min = x.length < y.length ? x.length : y.length;
        for (int i = 0; i < min; ++i) {
            if ((x[i] & y[i]) == 0L) continue;
            return true;
        }
        return false;
    }

    public static int intersectionSize(long x, long y) {
        return Long.bitCount(x & y);
    }

    public static int intersectionSize(long[] x, long[] y) {
        int lx = x.length;
        int ly = y.length;
        int min = lx < ly ? lx : ly;
        int res = 0;
        for (int i = 0; i < min; ++i) {
            res += Long.bitCount(x[i] & y[i]);
        }
        return res;
    }

    public static int unionSize(long x, long y) {
        return Long.bitCount(x | y);
    }

    public static int unionSize(long[] x, long[] y) {
        int i;
        int lx = x.length;
        int ly = y.length;
        int min = lx < ly ? lx : ly;
        int res = 0;
        for (i = 0; i < min; ++i) {
            res += Long.bitCount(x[i] | y[i]);
        }
        while (i < lx) {
            res += Long.bitCount(x[i]);
            ++i;
        }
        while (i < ly) {
            res += Long.bitCount(y[i]);
            ++i;
        }
        return res;
    }

    public static int hammingDistance(long b1, long b2) {
        return Long.bitCount(b1 ^ b2);
    }

    public static int hammingDistance(long[] x, long[] y) {
        int i;
        int lx = x.length;
        int ly = y.length;
        int min = lx < ly ? lx : ly;
        int h = 0;
        for (i = 0; i < min; ++i) {
            h += Long.bitCount(x[i] ^ y[i]);
        }
        while (i < lx) {
            h += Long.bitCount(x[i]);
            ++i;
        }
        while (i < ly) {
            h += Long.bitCount(y[i]);
            ++i;
        }
        return h;
    }

    public static int capacity(long[] v) {
        return v.length * 64;
    }

    public static boolean equal(long x, long y) {
        return x == y;
    }

    public static boolean equal(long[] x, long[] y) {
        int i;
        if (x == null || y == null) {
            return x == null && y == null;
        }
        int p = Math.min(x.length, y.length) - 1;
        for (i = x.length - 1; i > p; --i) {
            if (x[i] == 0L) continue;
            return false;
        }
        for (i = y.length - 1; i > p; --i) {
            if (y[i] == 0L) continue;
            return false;
        }
        while (p >= 0) {
            if (x[p] != y[p]) {
                return false;
            }
            --p;
        }
        return true;
    }

    public static int compare(long x, long y) {
        return Long.compare(x, y);
    }

    public static int compare(long[] x, long[] y) {
        int i;
        if (x == null) {
            return y == null ? 0 : -1;
        }
        if (y == null) {
            return 1;
        }
        int p = Math.min(x.length, y.length) - 1;
        for (i = x.length - 1; i > p; --i) {
            if (x[i] == 0L) continue;
            return 1;
        }
        for (i = y.length - 1; i > p; --i) {
            if (y[i] == 0L) continue;
            return -1;
        }
        while (p >= 0) {
            long xp = x[p];
            long yp = y[p];
            if (xp != yp) {
                return xp < 0L ? (yp < 0L && yp < xp ? -1 : 1) : (yp < 0L || xp < yp ? -1 : 1);
            }
            --p;
        }
        return 0;
    }

    public static int hashCode(long x) {
        long hash = 0x76543210L ^ x;
        return (int)(hash >> 32 ^ hash);
    }

    public static int hashCode(long[] x) {
        long hash = 1985229328L;
        int i = 0;
        while (i < x.length) {
            hash ^= x[i] * (long)(++i);
        }
        return (int)(hash >> 32 ^ hash);
    }

    public static double lpow2(long m, int n) {
        long bits;
        if (m == 0L) {
            return 0.0;
        }
        if (m == Long.MIN_VALUE) {
            return BitsUtil.lpow2(-4611686018427387904L, n + 1);
        }
        if (m < 0L) {
            return -BitsUtil.lpow2(-m, n);
        }
        assert (m >= 0L);
        int bitLength = BitsUtil.magnitude(m);
        int shift = bitLength - 53;
        long exp = 1075L + (long)n + (long)shift;
        if (exp >= 2047L) {
            return Double.POSITIVE_INFINITY;
        }
        if (exp <= 0L) {
            if (exp <= -54L) {
                return 0.0;
            }
            return BitsUtil.lpow2(m, n + 54) / 1.8014398509481984E16;
        }
        long l = bits = shift > 0 ? (m >> shift) + (m >> shift - 1 & 1L) : m << -shift;
        if (bits >> 52 != 1L && ++exp >= 2047L) {
            return Double.POSITIVE_INFINITY;
        }
        bits &= 0xFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(bits |= exp << 52);
    }

    public static double lpow10(long m, int n) {
        if (m == 0L) {
            return 0.0;
        }
        if (m == Long.MIN_VALUE) {
            return BitsUtil.lpow10(-922337203685477580L, n + 1);
        }
        if (m < 0L) {
            return -BitsUtil.lpow10(-m, n);
        }
        if (n >= 0) {
            if (n > 308) {
                return Double.POSITIVE_INFINITY;
            }
            long x0 = 0L;
            long x1 = 0L;
            long x2 = m & 0xFFFFFFFFL;
            long x3 = m >>> 32;
            int pow2 = 0;
            while (n != 0) {
                int i = n >= POW5_INT.length ? POW5_INT.length - 1 : n;
                int coef = POW5_INT[i];
                if ((int)x0 != 0) {
                    x0 *= (long)coef;
                }
                if ((int)x1 != 0) {
                    x1 *= (long)coef;
                }
                x2 *= (long)coef;
                x3 *= (long)coef;
                x1 &= 0xFFFFFFFFL;
                x2 &= 0xFFFFFFFFL;
                pow2 += i;
                n -= i;
                long carry = (x3 += (x2 += (x1 += (x0 &= 0xFFFFFFFFL) >>> 32) >>> 32) >>> 32) >>> 32;
                if (carry == 0L) continue;
                x0 = x1;
                x1 = x2;
                x2 = x3 & 0xFFFFFFFFL;
                x3 = carry;
                pow2 += 32;
            }
            assert (x3 >= 0L);
            int shift = 31 - BitsUtil.magnitude(x3);
            long mantissa = shift < 0 ? x3 << 31 | x2 >>> 1 : (x3 << 32 | x2) << shift | x1 >>> 32 - shift;
            return BitsUtil.lpow2(mantissa, pow2 -= shift);
        }
        if (n < -344) {
            return 0.0;
        }
        long x1 = m;
        long x0 = 0L;
        int pow2 = 0;
        while (true) {
            assert (x1 >= 0L);
            int shift = 63 - BitsUtil.magnitude(x1);
            x1 <<= shift;
            x1 |= x0 >>> 63 - shift;
            x0 = x0 << shift & Long.MAX_VALUE;
            pow2 -= shift;
            if (n == 0) break;
            int i = -n >= POW5_INT.length ? POW5_INT.length - 1 : -n;
            int divisor = POW5_INT[i];
            long wh = x1 >>> 32;
            long qh = wh / (long)divisor;
            long r = wh - qh * (long)divisor;
            long wl = r << 32 | x1 & 0xFFFFFFFFL;
            long ql = wl / (long)divisor;
            r = wl - ql * (long)divisor;
            x1 = qh << 32 | ql;
            wh = r << 31 | x0 >>> 32;
            qh = wh / (long)divisor;
            r = wh - qh * (long)divisor;
            wl = r << 32 | x0 & 0xFFFFFFFFL;
            ql = wl / (long)divisor;
            x0 = qh << 32 | ql;
            n += i;
            pow2 -= i;
        }
        return BitsUtil.lpow2(x1, pow2);
    }
}

