/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities;

import elki.logging.Logging;
import elki.utilities.Alias;
import elki.utilities.ELKIServiceLoader;
import elki.utilities.ELKIServiceScanner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ELKIServiceRegistry {
    private static final Logging LOG = Logging.getLogger(ELKIServiceRegistry.class);
    private static final ClassLoader CLASSLOADER = ELKIServiceRegistry.class.getClassLoader();
    public static final String FACTORY_POSTFIX = "$Factory";
    private static Map<Class<?>, Entry> data = new HashMap();
    private static final Class<?> FAILED_LOAD = Entry.class;

    private ELKIServiceRegistry() {
    }

    protected static void register(Class<?> parent, String cname) {
        ELKIServiceRegistry.data.computeIfAbsent(parent, x -> new Entry()).addName(cname);
    }

    protected static void register(Class<?> parent, Class<?> clazz) {
        Entry e = data.computeIfAbsent(parent, x -> new Entry());
        String cname = clazz.getCanonicalName();
        e.addHit(cname, clazz);
        if (clazz.isAnnotationPresent(Alias.class)) {
            Alias aliases = clazz.getAnnotation(Alias.class);
            for (String alias : aliases.value()) {
                e.addAlias(alias, cname);
            }
        }
    }

    protected static void registerAlias(Class<?> parent, String alias, String cname) {
        ELKIServiceRegistry.data.get(parent).addAlias(alias, cname);
    }

    private static Class<?> tryLoadClass(String value) {
        try {
            return CLASSLOADER.loadClass(value);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected static boolean contains(Class<?> c) {
        return data.containsKey(c);
    }

    public static List<Class<?>> findAllImplementations(Class<?> restrictionClass) {
        Entry e;
        if (restrictionClass == null) {
            return Collections.emptyList();
        }
        if (!ELKIServiceRegistry.contains(restrictionClass)) {
            ELKIServiceLoader.load(restrictionClass);
            ELKIServiceScanner.load(restrictionClass);
        }
        if ((e = data.get(restrictionClass)) == null) {
            return Collections.emptyList();
        }
        ArrayList ret = new ArrayList(e.len);
        for (int pos = 0; pos < e.len; ++pos) {
            Class<?> c = e.clazzes[pos];
            if (c == null) {
                c = ELKIServiceRegistry.tryLoadClass(e.names[pos]);
                if (c == null) {
                    LOG.warning((CharSequence)("Failed to load class " + e.names[pos] + " for interface " + restrictionClass.getName()));
                    c = FAILED_LOAD;
                }
                ((Entry)e).clazzes[pos] = c;
            }
            if (c == FAILED_LOAD || ret.contains(c)) continue;
            ret.add(c);
        }
        return ret;
    }

    public static List<Class<?>> findAllImplementations(Class<?> restrictionClass, boolean everything) {
        if (restrictionClass == null) {
            return Collections.emptyList();
        }
        if (!everything) {
            return ELKIServiceRegistry.findAllImplementations(restrictionClass);
        }
        ArrayList known = new ArrayList(ELKIServiceRegistry.findAllImplementations(restrictionClass));
        HashSet dupes = new HashSet(known);
        Iterator<Class<?>> iter = ELKIServiceScanner.nonindexedClasses();
        while (iter.hasNext()) {
            Class<?> cls = iter.next();
            if (dupes.contains(cls) || !restrictionClass.isAssignableFrom(cls)) continue;
            known.add(cls);
            dupes.add(cls);
        }
        return known;
    }

    public static <C> Class<? extends C> findImplementation(Class<? super C> restrictionClass, String value) {
        Class<?> clazz = ELKIServiceRegistry.tryLoadClass(value);
        if (clazz != null && restrictionClass.isAssignableFrom(clazz)) {
            return clazz.asSubclass(restrictionClass);
        }
        if (!ELKIServiceRegistry.contains(restrictionClass)) {
            ELKIServiceLoader.load(restrictionClass);
            ELKIServiceScanner.load(restrictionClass);
        }
        Entry e = data.get(restrictionClass);
        int pos = -1;
        if (e != null) {
            for (pos = 0; pos < e.len && !e.names[pos].equals(value); ++pos) {
            }
            if (pos < e.len) {
                clazz = e.clazzes[pos];
            } else {
                pos = -1;
            }
        } else if (LOG.isDebugging()) {
            LOG.debug((CharSequence)("Requested implementations for unregistered type: " + restrictionClass.getName() + " " + value));
        }
        Class<?> clazz2 = clazz = clazz != null ? clazz : ELKIServiceRegistry.tryAlternateNames(restrictionClass, value, e);
        if (clazz == null) {
            return null;
        }
        if (!restrictionClass.isAssignableFrom(clazz)) {
            LOG.warning((CharSequence)("Cannot load " + value + " as it does not implement " + restrictionClass.getName()));
            clazz = FAILED_LOAD;
        }
        if (e != null) {
            if (pos < 0) {
                e.addHit(value, clazz);
            } else {
                assert (e.names[pos].equalsIgnoreCase(value));
                ((Entry)e).clazzes[pos] = clazz;
            }
        }
        return clazz == FAILED_LOAD ? null : clazz.asSubclass(restrictionClass);
    }

    private static <C> Class<?> tryAlternateNames(Class<? super C> restrictionClass, String value, Entry e) {
        StringBuilder buf = new StringBuilder(value.length() + 100);
        Class<?> clazz = ELKIServiceRegistry.tryLoadClass(buf.append(value).append(FACTORY_POSTFIX).toString());
        if (clazz != null) {
            return clazz;
        }
        clazz = ELKIServiceRegistry.tryLoadClass(value);
        if (clazz != null) {
            return clazz;
        }
        buf.setLength(0);
        clazz = ELKIServiceRegistry.tryLoadClass(buf.append(restrictionClass.getPackage().getName()).append('.').append(value).append(FACTORY_POSTFIX).toString());
        if (clazz != null) {
            return clazz;
        }
        buf.setLength(buf.length() - FACTORY_POSTFIX.length());
        String value2 = buf.toString();
        clazz = ELKIServiceRegistry.tryLoadClass(value2);
        if (clazz != null) {
            return clazz;
        }
        if (e != null && e.aliaslen > 0) {
            for (int i = 0; i < e.aliaslen; i += 2) {
                if (!e.aliases[i].equalsIgnoreCase(value) && !e.aliases[i].equalsIgnoreCase(value2)) continue;
                return ELKIServiceRegistry.findImplementation(restrictionClass, e.aliases[i + 1]);
            }
        }
        return null;
    }

    private static class Entry {
        private static final String[] EMPTY_ALIASES = new String[0];
        private String[] names = new String[3];
        private Class<?>[] clazzes = new Class[3];
        private int len = 0;
        private String[] aliases = EMPTY_ALIASES;
        private int aliaslen = 0;

        private Entry() {
        }

        private void addName(String cname) {
            if (this.len == this.names.length) {
                int nl = (this.len << 1) + 1;
                this.names = Arrays.copyOf(this.names, nl);
                this.clazzes = Arrays.copyOf(this.clazzes, nl);
            }
            this.names[this.len++] = cname;
        }

        private void addHit(String cname, Class<?> c) {
            if (this.len == this.names.length) {
                int nl = (this.len << 1) + 1;
                this.names = Arrays.copyOf(this.names, nl);
                this.clazzes = Arrays.copyOf(this.clazzes, nl);
            }
            this.names[this.len] = cname;
            this.clazzes[this.len] = c;
            ++this.len;
        }

        private void addAlias(String alias, String cname) {
            if (this.aliases == EMPTY_ALIASES) {
                this.aliases = new String[6];
            }
            if (this.aliaslen == this.aliases.length) {
                this.aliases = Arrays.copyOf(this.aliases, this.aliaslen << 1);
            }
            this.aliases[this.aliaslen++] = alias;
            this.aliases[this.aliaslen++] = cname;
        }
    }
}

