/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities;

import elki.utilities.ELKIServiceRegistry;
import elki.utilities.exceptions.AbortException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;

public class ELKIServiceLoader {
    public static final String RESOURCE_PREFIX = "META-INF/elki/";
    public static final String FILENAME_PREFIX = "META-INF" + File.separator + "elki" + File.separator;
    public static final char COMMENT_CHAR = '#';

    private ELKIServiceLoader() {
    }

    public static void load(Class<?> parent) {
        ELKIServiceLoader.load(parent, ELKIServiceLoader.class.getClassLoader());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void load(Class<?> parent, ClassLoader cl) {
        char[] buf = new char[16384];
        try {
            String fullName = RESOURCE_PREFIX + parent.getName();
            Enumeration<URL> configfiles = cl.getResources(fullName);
            while (configfiles.hasMoreElements()) {
                URL nextElement = configfiles.nextElement();
                URLConnection conn = nextElement.openConnection();
                conn.setUseCaches(false);
                try {
                    InputStream ist = conn.getInputStream();
                    try (InputStreamReader is = new InputStreamReader(ist, StandardCharsets.UTF_8);){
                        int start = 0;
                        int cur = 0;
                        int valid = is.read(buf, 0, buf.length);
                        while (cur < valid) {
                            char c;
                            while (cur < valid && (c = buf[cur]) != '\n' && c != '\r') {
                                ++cur;
                            }
                            if (cur == valid && is.ready()) {
                                if (start > 0) {
                                    System.arraycopy(buf, start, buf, 0, valid - start);
                                    valid -= start;
                                    cur -= start;
                                    start = 0;
                                } else if (valid == buf.length) {
                                    throw new IOException("Buffer size exceeded. Maximum line length in service files is: " + buf.length + " in file: " + fullName);
                                }
                                valid = is.read(buf, valid, buf.length - valid);
                                continue;
                            }
                            ELKIServiceLoader.parseLine(parent, buf, start, cur);
                            while (cur < valid && ((c = buf[cur]) == '\n' || c == '\r')) {
                                ++cur;
                            }
                            start = cur;
                        }
                    }
                    finally {
                        if (ist == null) continue;
                        ist.close();
                    }
                }
                catch (IOException x) {
                    throw new AbortException("Error reading configuration file", x);
                    return;
                }
            }
        }
        catch (IOException x) {
            throw new AbortException("Could not load service configuration files.", x);
        }
    }

    private static void parseLine(Class<?> parent, char[] line, int begin, int end) {
        int cend;
        while (begin < end && line[begin] == ' ') {
            ++begin;
        }
        if (begin >= end || line[begin] == '#') {
            return;
        }
        for (cend = begin + 1; cend < end && line[cend] != ' '; ++cend) {
        }
        String cname = new String(line, begin, cend - begin);
        ELKIServiceRegistry.register(parent, cname);
        int abegin = cend + 1;
        int aend = -1;
        while (abegin < end) {
            while (abegin < end && line[abegin] == ' ') {
                ++abegin;
            }
            for (aend = abegin + 1; aend < end && line[aend] != ' '; ++aend) {
            }
            ELKIServiceRegistry.registerAlias(parent, new String(line, abegin, aend - abegin), cname);
            abegin = aend + 1;
        }
    }
}

