/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities;

import elki.logging.Logging;
import elki.utilities.ELKIServiceRegistry;
import elki.utilities.exceptions.AbortException;
import elki.utilities.exceptions.ClassInstantiationException;
import elki.utilities.optionhandling.ParameterException;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import java.lang.reflect.InvocationTargetException;

public final class ClassGenericsUtil {
    private static final Logging LOG = Logging.getLogger(ClassGenericsUtil.class);
    static final ClassLoader CLASSLOADER = ClassGenericsUtil.class.getClassLoader();
    public static final String FACTORY_METHOD_NAME = "parameterize";

    private ClassGenericsUtil() {
    }

    public static Parameterizer getParameterizer(Class<?> c) {
        for (Class<?> inner : c.getDeclaredClasses()) {
            if (!Parameterizer.class.isAssignableFrom(inner)) continue;
            try {
                return inner.asSubclass(Parameterizer.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                LOG.warning((CharSequence)("Non-usable Parameterizer in class: " + c.getName()));
            }
        }
        return null;
    }

    public static <C> C tryInstantiate(Class<C> r, Class<?> c, Parameterization config) throws ClassInstantiationException {
        if (c == null) {
            throw new ClassInstantiationException("Trying to instantiate 'null' class!");
        }
        try {
            Parameterizer par = ClassGenericsUtil.getParameterizer(c);
            return r.cast(par != null ? ClassGenericsUtil.make(par, config) : c.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ClassInstantiationException(e);
        }
    }

    public static Object make(Parameterizer par, Parameterization config) {
        Class<?> owner = par.getClass().getDeclaringClass();
        config = config.descend(owner != null ? owner : par);
        par.configure(config);
        if (config.hasErrors()) {
            return null;
        }
        Object ret = par.make();
        if (ret == null) {
            throw new AbortException("makeInstance() returned null!");
        }
        return ret;
    }

    public static <C> C parameterizeOrAbort(Class<?> c, Parameterization config) {
        try {
            Object ret = ClassGenericsUtil.tryInstantiate(c, c, config);
            if (ret == null) {
                throw new AbortException("Could not instantiate class. Check parameters.");
            }
            return (C)ret;
        }
        catch (Exception e) {
            if (config.hasErrors()) {
                for (ParameterException err : config.getErrors()) {
                    LOG.warning((CharSequence)err.toString());
                }
            }
            throw e instanceof AbortException ? (AbortException)e : new AbortException("Instantiation failed", e);
        }
    }

    public static <D, T extends D> Class<T> uglyCastIntoSubclass(Class<D> cls) {
        return cls;
    }

    public static <T> T instantiateLowlevel(Class<? extends T> clz) {
        Exception last = null;
        for (Class<?> c : ELKIServiceRegistry.findAllImplementations(clz)) {
            try {
                return clz.cast(c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                last = e;
            }
        }
        throw new AbortException("Cannot find a usable implementation of " + clz.toString(), last);
    }

    public static <T> T loadDefault(Class<T> clz, String def) {
        try {
            return clz.cast(ELKIServiceRegistry.findImplementation(clz, def).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            return ClassGenericsUtil.instantiateLowlevel(clz);
        }
    }
}

