/*
 * Decompiled with CFR 0.152.
 */
package elki.application.internal;

import elki.logging.Logging;
import elki.utilities.Alias;
import elki.utilities.ELKIServiceLoader;
import elki.utilities.ELKIServiceRegistry;
import elki.utilities.exceptions.AbortException;
import elki.utilities.io.FormatUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CheckELKIServices {
    private static final Logging LOG = Logging.getLogger(CheckELKIServices.class);
    private static final Pattern STRIP = Pattern.compile("^[\\s#]*(?:deprecated:\\s*)?(.*?)[\\s]*$");

    public static void main(String[] argv) {
        String update = null;
        if (argv.length == 2 && "-update".equals(argv[0])) {
            update = argv[1];
            LOG.info((CharSequence)("Updating service files in folder: " + update));
        } else if (argv.length != 0) {
            throw new AbortException("Incorrect command line parameters.");
        }
        new CheckELKIServices().checkServices(update);
    }

    public void checkServices(String update) {
        TreeSet<String> props = new TreeSet<String>();
        try {
            Enumeration<URL> us = this.getClass().getClassLoader().getResources("META-INF/elki/");
            while (us.hasMoreElements()) {
                URL u = us.nextElement();
                if (!"file".equals(u.getProtocol())) continue;
                props.addAll(Arrays.asList(new File(u.toURI()).list()));
            }
            String classpath = System.getProperty("java.class.path");
            for (String cp : classpath.split(File.pathSeparator)) {
                try {
                    Path jp = Paths.get(cp, new String[0]).normalize();
                    if (Files.isDirectory(jp, new LinkOption[0])) continue;
                    if (!Files.exists(jp, new LinkOption[0]) || !Files.isReadable(jp)) {
                        if (cp.contains("/bin/default")) continue;
                        LOG.warning((CharSequence)("Path does not exist, or is not readable: " + cp));
                        continue;
                    }
                    try (JarFile jar = new JarFile(jp.toFile());){
                        Enumeration<JarEntry> entries = jar.entries();
                        while (entries.hasMoreElements()) {
                            Path ep = Paths.get(entries.nextElement().getName(), new String[0]).normalize();
                            if (ep.startsWith("..")) {
                                LOG.warning((CharSequence)("Jar file contains illegal path: " + ep));
                                continue;
                            }
                            if (ep.startsWith("META-INF/elki/")) {
                                props.add(Paths.get("META-INF/elki/", new String[0]).relativize(ep).toString());
                                continue;
                            }
                            if (!ep.startsWith(ELKIServiceLoader.FILENAME_PREFIX)) continue;
                            props.add(Paths.get(ELKIServiceLoader.FILENAME_PREFIX, new String[0]).relativize(ep).toString());
                        }
                    }
                    catch (IOException e) {
                        LOG.warning((CharSequence)("Error reading " + jp + ": " + e.getMessage()), (Throwable)e);
                    }
                }
                catch (Exception e) {
                    LOG.warning((CharSequence)("Could not process class path entry " + cp + ": " + e.getMessage()), (Throwable)e);
                }
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new AbortException("Error enumerating service folders.", e);
        }
        for (String prop : props) {
            LOG.verbose((CharSequence)("Checking property: " + prop));
            this.checkService(prop, update);
        }
    }

    private void checkService(String prop, String update) {
        Class<?> cls;
        try {
            cls = Class.forName(prop);
        }
        catch (ClassNotFoundException e) {
            LOG.warning((CharSequence)("Service file name is not a class name: " + prop));
            return;
        }
        List<Class<?>> impls = ELKIServiceRegistry.findAllImplementations(cls, true);
        HashSet<String> names = new HashSet<String>();
        for (Class<?> c2 : impls) {
            if (c2.isInterface() || Modifier.isAbstract(c2.getModifiers())) continue;
            names.add(c2.getName());
        }
        try {
            Enumeration<URL> us = this.getClass().getClassLoader().getResources("META-INF/elki/" + cls.getName());
            Matcher m = STRIP.matcher("");
            while (us.hasMoreElements()) {
                URL u = us.nextElement();
                boolean injar = "jar".equals(u.getProtocol());
                if (injar) {
                    for (FileSystemProvider provider : FileSystemProvider.installedProviders()) {
                        if (!provider.getScheme().equalsIgnoreCase("jar")) continue;
                        try {
                            provider.getFileSystem(u.toURI());
                        }
                        catch (FileSystemNotFoundException e) {
                            provider.newFileSystem(u.toURI(), Collections.emptyMap());
                        }
                    }
                }
                BufferedReader r = Files.newBufferedReader(Paths.get(u.toURI()));
                try {
                    String line;
                    while ((line = r.readLine()) != null) {
                        m.reset(line);
                        if (!m.matches()) {
                            LOG.warning((CharSequence)("Line: " + line + " didn't match regexp."));
                            continue;
                        }
                        String stripped = m.group(1);
                        if (stripped.length() <= 0) continue;
                        String[] parts = stripped.split(" ");
                        if (!names.remove(parts[0]) && !injar) {
                            LOG.warning((CharSequence)("Name " + parts[0] + " found for property " + prop + " but no class discovered (or listed twice)."));
                        }
                        this.checkAliases(cls, parts[0], parts);
                    }
                }
                finally {
                    if (r == null) continue;
                    r.close();
                }
            }
        }
        catch (IOException | URISyntaxException e) {
            LOG.exception((Throwable)e);
        }
        if (!names.isEmpty()) {
            ArrayList sorted = new ArrayList(names);
            Collections.sort(sorted);
            if (update == null) {
                StringBuilder message = new StringBuilder().append("Class ").append(prop).append(" lacks suggestions:").append(FormatUtil.NEWLINE);
                for (String remaining : sorted) {
                    message.append(remaining).append(FormatUtil.NEWLINE);
                }
                LOG.warning((CharSequence)message.toString());
                return;
            }
            try {
                Path folder = Paths.get(update, ELKIServiceLoader.FILENAME_PREFIX);
                Files.createDirectories(folder, new FileAttribute[0]);
                Path out = folder.resolve(prop);
                if (!out.startsWith(folder) || prop.contains("..")) {
                    throw new IllegalStateException("Insecure path: " + out.toString());
                }
                try (BufferedWriter pr = Files.newBufferedWriter(out, StandardOpenOption.APPEND);){
                    pr.append('\n');
                    for (String remaining : sorted) {
                        pr.append(remaining).append('\n');
                    }
                }
                LOG.warning((CharSequence)("Updated service file: " + out.toString()));
            }
            catch (IOException e) {
                LOG.exception((Throwable)e);
            }
        }
    }

    private void checkAliases(Class<?> parent, String classname, String[] parts) {
        Class<?> c = ELKIServiceRegistry.findImplementation(parent, classname);
        if (c == null) {
            return;
        }
        Alias ann = c.getAnnotation(Alias.class);
        if (ann == null) {
            if (parts.length > 1) {
                StringBuilder buf = new StringBuilder(100).append("Class ").append(classname).append(" in ").append(parent.getCanonicalName()).append(" has the following extraneous aliases:");
                for (int i = 1; i < parts.length; ++i) {
                    buf.append(' ').append(parts[i]);
                }
                LOG.warning((CharSequence)buf);
            }
            return;
        }
        HashSet<String> aliases = new HashSet<String>();
        for (int i = 1; i < parts.length; ++i) {
            aliases.add(parts[i]);
        }
        StringBuilder buf = null;
        for (String a : ann.value()) {
            if (aliases.remove(a)) continue;
            if (buf == null) {
                buf = new StringBuilder(100).append("Class ").append(classname).append(" in ").append(parent.getCanonicalName()).append(" is missing the following aliases:");
            }
            buf.append(' ').append(a);
        }
        if (!aliases.isEmpty()) {
            buf = (buf == null ? new StringBuilder() : buf.append(FormatUtil.NEWLINE)).append("Class ").append(classname).append(" in ").append(parent.getCanonicalName()).append(" has the following extraneous aliases:");
            for (String a : aliases) {
                buf.append(' ').append(a);
            }
        }
        if (buf != null) {
            LOG.warning((CharSequence)buf);
        }
    }
}

