/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html.tag;

import com.steadystate.css.dom.CSSStyleDeclarationImpl;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.ddr.poi.html.ElementRenderer;
import org.ddr.poi.html.HtmlRenderContext;
import org.ddr.poi.html.util.CSSLength;
import org.ddr.poi.html.util.CSSLengthUnit;
import org.ddr.poi.html.util.CSSStyleUtils;
import org.ddr.poi.html.util.ColumnStyle;
import org.ddr.poi.html.util.JsoupUtils;
import org.ddr.poi.html.util.RenderUtils;
import org.ddr.poi.html.util.Span;
import org.ddr.poi.html.util.SpanWidth;
import org.ddr.poi.html.util.WhiteSpaceRule;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblGrid;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblGridCol;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblWidth;

public class TableRenderer
implements ElementRenderer {
    private static final String[] TAGS = new String[]{"table"};
    private final CSSStyleDeclarationImpl defaultCaptionStyle = new CSSStyleDeclarationImpl();

    public TableRenderer() {
        this.defaultCaptionStyle.setBackgroundColor("");
        this.defaultCaptionStyle.setBorder("");
        this.defaultCaptionStyle.setPadding("");
        this.defaultCaptionStyle.setMargin("");
        this.defaultCaptionStyle.setTextAlign("center");
        CSSStyleUtils.split(this.defaultCaptionStyle);
    }

    @Override
    public boolean renderStart(Element element, HtmlRenderContext context) {
        CSSStyleDeclarationImpl styleDeclaration = context.currentElementStyle();
        WhiteSpaceRule tableWhiteSpace = WhiteSpaceRule.of(styleDeclaration.getWhiteSpace(), WhiteSpaceRule.NORMAL);
        styleDeclaration.setWhiteSpace("normal");
        HashMap<Element, WhiteSpaceRule> whiteSpaceMap = new HashMap<Element, WhiteSpaceRule>();
        whiteSpaceMap.put(element, tableWhiteSpace);
        String widthDeclaration = styleDeclaration.getWidth();
        XWPFTable table = context.getClosestTable();
        int containerWidth = context.getAvailableWidthInEMU();
        CSSLength width = CSSLength.of(widthDeclaration);
        boolean explicitWidth = width.isValid() && !width.isPercent();
        int tableWidth = context.computeLengthInEMU(widthDeclaration, styleDeclaration.getMaxWidth(), containerWidth, containerWidth);
        int originWidth = !width.isValid() || width.isPercent() ? tableWidth : context.lengthToEMU(width);
        Element caption = JsoupUtils.firstChild(element, "caption");
        if (caption != null) {
            this.renderCaption(context, table, caption, tableWhiteSpace);
        }
        Element colgroup = JsoupUtils.firstChild(element, "colgroup");
        List<ColumnStyle> columnStyles = this.extractColumnStyles(colgroup);
        Elements trs = JsoupUtils.childRows(element);
        TreeMap<Integer, Span> rowSpanMap = new TreeMap<Integer, Span>();
        TreeMap<Integer, CSSLength> colWidthMap = new TreeMap<Integer, CSSLength>();
        LinkedHashSet<SpanWidth> spanWidths = new LinkedHashSet<SpanWidth>();
        for (int r = 0; r < trs.size(); ++r) {
            Element tr = (Element)trs.get(r);
            XWPFTableRow row = this.createRow(table, r);
            Elements tds = JsoupUtils.children(tr, "th", "td");
            int columnIndex = 0;
            int minRowSpan = 1;
            int vMergeCount = 0;
            for (int c = 0; c < tds.size(); ++c) {
                Element td = (Element)tds.get(c);
                int rowspan = NumberUtils.toInt((String)td.attr("rowspan"), (int)1);
                int colspan = NumberUtils.toInt((String)td.attr("colspan"), (int)1);
                minRowSpan = Math.min(minRowSpan, rowspan);
                for (Map.Entry entry : rowSpanMap.entrySet()) {
                    if ((Integer)entry.getKey() > columnIndex || !((Span)entry.getValue()).isEnabled()) continue;
                    columnIndex += ((Span)entry.getValue()).getColumn();
                    ((Span)entry.getValue()).setEnabled(false);
                    this.addVMergeCell(row, c, (Span)entry.getValue());
                    ++vMergeCount;
                }
                td.attr("_r", String.valueOf(r));
                td.attr("_c", String.valueOf(c + vMergeCount));
                WhiteSpaceRule tdWhiteSpace = null;
                Element parent = td.parent();
                while (true) {
                    if (parent == element) {
                        if (tdWhiteSpace != null) break;
                        tdWhiteSpace = tableWhiteSpace;
                        break;
                    }
                    WhiteSpaceRule parentWhiteSpace = (WhiteSpaceRule)((Object)whiteSpaceMap.get(parent));
                    if (!whiteSpaceMap.containsKey(parent)) {
                        CSSStyleDeclarationImpl parentStyle = context.getCssStyleDeclaration(parent);
                        String parentRule = parentStyle.removeProperty("white-space");
                        parentWhiteSpace = WhiteSpaceRule.of(parentRule);
                        whiteSpaceMap.put(parent, parentWhiteSpace);
                        if (parentWhiteSpace != null) {
                            parent.attr("style", parentStyle.getCssText());
                        }
                    }
                    if (parentWhiteSpace != null && tdWhiteSpace == null) {
                        tdWhiteSpace = parentWhiteSpace;
                    }
                    parent = parent.parent();
                }
                if (!tdWhiteSpace.isNormal()) {
                    td.attr("style", "white-space:" + tdWhiteSpace.getValue() + ";" + td.attr("style"));
                }
                if (!columnStyles.isEmpty() && columnIndex < columnStyles.size()) {
                    CSSLength tdWidth;
                    String colStyle = columnStyles.get(columnIndex).getStyle().getCssText();
                    StringBuilder sb = new StringBuilder();
                    if (!colStyle.isEmpty()) {
                        sb.append(colStyle).append(";");
                    }
                    if (colspan > 1 && (tdWidth = this.sumColumnWidths(columnStyles, columnIndex, colspan)).isValid()) {
                        sb.append("width").append(":").append(tdWidth).append(";");
                    }
                    if (sb.length() > 0) {
                        sb.append(td.attr("style"));
                        td.attr("style", sb.toString());
                    }
                }
                CSSStyleDeclarationImpl tdStyleDeclaration = CSSStyleUtils.parse(td.attr("style"));
                CSSLength tdWidth = CSSLength.of(tdStyleDeclaration.getWidth());
                XWPFTableCell cell = this.createCell(row, c);
                CTTcPr ctTcPr = RenderUtils.getTcPr(cell.getCTTc());
                if (rowspan > 1) {
                    CSSStyleUtils.split(tdStyleDeclaration);
                    rowSpanMap.put(columnIndex, new Span(rowspan, colspan, false, tdStyleDeclaration));
                    CTVMerge ctvMerge = ctTcPr.isSetVMerge() ? ctTcPr.getVMerge() : ctTcPr.addNewVMerge();
                    ctvMerge.setVal(STMerge.RESTART);
                }
                if (colspan == 1) {
                    CSSLength existingWidth = colWidthMap.get(columnIndex);
                    if (existingWidth == null || !existingWidth.isValid()) {
                        colWidthMap.put(columnIndex, tdWidth);
                    } else if (explicitWidth) {
                        if (existingWidth.isPercent()) {
                            colWidthMap.put(columnIndex, tdWidth);
                        }
                    } else if (!existingWidth.isPercent()) {
                        colWidthMap.put(columnIndex, tdWidth);
                    }
                } else {
                    spanWidths.add(new SpanWidth(tdWidth, columnIndex, colspan, explicitWidth));
                    ctTcPr.addNewGridSpan().setVal(BigInteger.valueOf(colspan));
                }
                columnIndex += colspan;
            }
            Iterator iterator = rowSpanMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Integer spanColumnIndex = (Integer)entry.getKey();
                Span span = (Span)entry.getValue();
                span.setRow(span.getRow() - minRowSpan);
                if (span.getRow() == 0) {
                    iterator.remove();
                } else {
                    span.setEnabled(true);
                }
                if (columnIndex > spanColumnIndex || columnIndex >= colWidthMap.size()) continue;
                this.addVMergeCell(row, columnIndex, span);
                columnIndex += span.getColumn();
            }
        }
        CTTbl ctTbl = table.getCTTbl();
        CTTblGrid tblGrid = ctTbl.getTblGrid();
        if (tblGrid == null) {
            tblGrid = ctTbl.addNewTblGrid();
        }
        for (SpanWidth spanWidth : spanWidths) {
            spanWidth.setLength(colWidthMap);
        }
        BigInteger[] colWidths = new BigInteger[colWidthMap.size()];
        double unhandledPercentSum = 0.0;
        int unhandledEmuSum = 0;
        int unhandledEmuCount = 0;
        int remainWidth = tableWidth;
        BigInteger[] iterator = colWidthMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, CSSLength> entry = iterator.next();
            CSSLength value = entry.getValue();
            if (!value.isValid()) {
                entry.setValue(new CSSLength(100.0 / (double)colWidths.length, CSSLengthUnit.PERCENT));
                unhandledPercentSum += entry.getValue().getValue();
                continue;
            }
            if (explicitWidth) {
                if (value.isPercent()) {
                    unhandledPercentSum += value.getValue();
                    continue;
                }
                int emu = (int)((long)value.toEMU() * (long)tableWidth / (long)originWidth);
                colWidths[entry.getKey().intValue()] = BigInteger.valueOf(RenderUtils.emuToTwips(emu));
                remainWidth -= emu;
                iterator.remove();
                continue;
            }
            if (value.isPercent()) {
                unhandledPercentSum += value.getValue();
                continue;
            }
            unhandledPercentSum += 100.0 / (double)colWidths.length;
            unhandledEmuSum += value.toEMU();
            ++unhandledEmuCount;
        }
        for (Map.Entry<Integer, CSSLength> entry : colWidthMap.entrySet()) {
            CSSLength value = entry.getValue();
            if (value.isPercent()) {
                colWidths[entry.getKey().intValue()] = BigInteger.valueOf((int)Math.rint((double)remainWidth * value.getValue() / unhandledPercentSum * 20.0 / 12700.0));
                continue;
            }
            colWidths[entry.getKey().intValue()] = BigInteger.valueOf((int)Math.rint((double)remainWidth * ((double)unhandledEmuCount * 100.0 / (double)colWidths.length / unhandledPercentSum) * (double)value.toEMU() / (double)unhandledEmuSum * 20.0 / 12700.0));
        }
        for (BigInteger colWidth : colWidths) {
            CTTblGridCol ctTblGridCol = tblGrid.addNewGridCol();
            ctTblGridCol.setW(colWidth);
        }
        int rows = ctTbl.sizeOfTrArray();
        for (int i = 0; i < rows; ++i) {
            CTRow ctRow = ctTbl.getTrArray(i);
            int columnIndex = 0;
            int cells = ctRow.sizeOfTcArray();
            for (int j = 0; j < cells; ++j) {
                CTTc ctTc = ctRow.getTcArray(j);
                CTTcPr tcPr = RenderUtils.getTcPr(ctTc);
                int colspan = tcPr.isSetGridSpan() ? tcPr.getGridSpan().getVal().intValue() : 1;
                CTTblWidth tcWidth = tcPr.addNewTcW();
                tcWidth.setType(STTblWidth.DXA);
                if (colspan == 1) {
                    tcWidth.setW(colWidths[columnIndex]);
                } else {
                    int sum = 0;
                    for (int k = 0; k < colspan; ++k) {
                        sum += colWidths[columnIndex + k].intValue();
                    }
                    tcWidth.setW(BigInteger.valueOf(sum));
                }
                columnIndex += colspan;
            }
        }
        return true;
    }

    private List<ColumnStyle> extractColumnStyles(Element colgroup) {
        List<ColumnStyle> columnStyles = Collections.emptyList();
        if (colgroup != null) {
            Elements cols = colgroup.select("col");
            columnStyles = new ArrayList<ColumnStyle>();
            for (Element col : cols) {
                String colWidthAttr;
                String style = col.attr("style");
                CSSStyleDeclarationImpl cssStyleDeclaration = CSSStyleUtils.parse(style);
                int span = NumberUtils.toInt((String)col.attr("span"), (int)1);
                CSSLength colWidth = CSSLength.of(cssStyleDeclaration.getWidth());
                if (!colWidth.isValid() && !(colWidthAttr = col.attr("width")).isEmpty()) {
                    if (!colWidthAttr.endsWith("%")) {
                        colWidthAttr = colWidthAttr + "px";
                    }
                    colWidth = CSSLength.of(colWidthAttr);
                }
                if (colWidth.isValid() && span > 1) {
                    colWidth = new CSSLength(colWidth.getValue() / (double)span, colWidth.getUnit());
                }
                for (int i = 0; i < span; ++i) {
                    columnStyles.add(new ColumnStyle(cssStyleDeclaration, colWidth));
                }
            }
            colgroup.remove();
        }
        return columnStyles;
    }

    private CSSLength sumColumnWidths(List<ColumnStyle> columnWidths, int columnIndex, int colspan) {
        Boolean percent = null;
        double sum = 0.0;
        for (int i = 0; i < colspan; ++i) {
            CSSLength width = columnWidths.get(columnIndex + i).getWidth();
            if (!width.isValid()) {
                return width;
            }
            if (percent == null) {
                percent = width.isPercent();
            } else if (percent ^ width.isPercent()) {
                return CSSLength.INVALID;
            }
            if (percent.booleanValue()) {
                sum += width.getValue();
                continue;
            }
            sum += (double)width.toEMU();
        }
        return new CSSLength(sum, percent != false ? CSSLengthUnit.PERCENT : CSSLengthUnit.EMU);
    }

    private void renderCaption(HtmlRenderContext context, XWPFTable table, Element caption, WhiteSpaceRule whiteSpace) {
        Object xmlCursor;
        XWPFParagraph captionParagraph;
        CSSStyleDeclarationImpl captionStyle = context.getCssStyleDeclaration(caption);
        captionStyle.getProperties().addAll(0, this.defaultCaptionStyle.getProperties());
        if (whiteSpace != null) {
            captionStyle.getProperties().add(0, CSSStyleUtils.newProperty("white-space", whiteSpace.getValue()));
        }
        context.pushInlineStyle(captionStyle, caption.isBlock());
        boolean bottom = "bottom".equals(context.getPropertyValue("caption-side"));
        if (bottom) {
            captionParagraph = context.getClosestParagraph();
            caption.parent().attr("caption-side", "bottom");
        } else {
            xmlCursor = table.getCTTbl().newCursor();
            context.pushCursor((XmlCursor)xmlCursor);
            captionParagraph = context.newParagraph(null, (XmlCursor)xmlCursor);
            xmlCursor.dispose();
        }
        RenderUtils.paragraphStyle(context, captionParagraph, captionStyle);
        context.markDedupe(captionParagraph);
        for (Node node : caption.childNodes()) {
            context.renderNode(node);
        }
        context.unmarkDedupe();
        context.popInlineStyle();
        caption.remove();
        if (bottom) {
            xmlCursor = captionParagraph.getCTP().newCursor();
            context.pushCursor((XmlCursor)xmlCursor);
            xmlCursor.dispose();
        } else {
            context.popCursor();
        }
    }

    @Override
    public void renderEnd(Element element, HtmlRenderContext context) {
        if ("bottom".equals(element.attr("caption-side"))) {
            context.popCursor();
        }
    }

    private void addVMergeCell(XWPFTableRow row, int columnIndex, Span span) {
        XWPFTableCell cell = this.createCell(row, columnIndex);
        CTTcPr ctTcPr = RenderUtils.getTcPr(cell.getCTTc());
        ctTcPr.addNewVMerge();
        RenderUtils.setBorder(cell, span.getStyle());
        if (span.getColumn() > 1) {
            ctTcPr.addNewGridSpan().setVal(BigInteger.valueOf(span.getColumn()));
        }
    }

    private XWPFTableCell createCell(XWPFTableRow row, int c) {
        return row.createCell();
    }

    private XWPFTableRow createRow(XWPFTable table, int r) {
        return table.insertNewTableRow(r);
    }

    @Override
    public String[] supportedTags() {
        return TAGS;
    }

    @Override
    public boolean renderAsBlock() {
        return true;
    }
}

