/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html;

import com.deepoove.poi.policy.AbstractRenderPolicy;
import com.deepoove.poi.render.RenderContext;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.ddr.poi.html.ElementRenderer;
import org.ddr.poi.html.HtmlRenderConfig;
import org.ddr.poi.html.HtmlRenderContext;
import org.ddr.poi.html.tag.ARenderer;
import org.ddr.poi.html.tag.BigRenderer;
import org.ddr.poi.html.tag.BoldRenderer;
import org.ddr.poi.html.tag.BreakRenderer;
import org.ddr.poi.html.tag.DeleteRenderer;
import org.ddr.poi.html.tag.FigureCaptionRenderer;
import org.ddr.poi.html.tag.FigureRenderer;
import org.ddr.poi.html.tag.HeaderBreakRenderer;
import org.ddr.poi.html.tag.HeaderRenderer;
import org.ddr.poi.html.tag.ImageRenderer;
import org.ddr.poi.html.tag.ItalicRenderer;
import org.ddr.poi.html.tag.ListItemRenderer;
import org.ddr.poi.html.tag.ListRenderer;
import org.ddr.poi.html.tag.MarkRenderer;
import org.ddr.poi.html.tag.MathRenderer;
import org.ddr.poi.html.tag.OmittedRenderer;
import org.ddr.poi.html.tag.PreRenderer;
import org.ddr.poi.html.tag.RubyRenderer;
import org.ddr.poi.html.tag.SmallRenderer;
import org.ddr.poi.html.tag.SubscriptRenderer;
import org.ddr.poi.html.tag.SuperscriptRenderer;
import org.ddr.poi.html.tag.SvgRenderer;
import org.ddr.poi.html.tag.TableCellRenderer;
import org.ddr.poi.html.tag.TableRenderer;
import org.ddr.poi.html.tag.UnderlineRenderer;
import org.ddr.poi.html.tag.WalkThroughRenderer;
import org.ddr.poi.html.util.CSSLength;
import org.ddr.poi.html.util.JsoupUtils;
import org.jsoup.nodes.Document;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBookmark;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;

public class HtmlRenderPolicy
extends AbstractRenderPolicy<String> {
    private final Map<String, ElementRenderer> elRenderers;
    private final HtmlRenderConfig config;

    public HtmlRenderPolicy() {
        this(new HtmlRenderConfig());
    }

    @Deprecated
    public HtmlRenderPolicy(String globalFont, CSSLength globalFontSize) {
        this(new HtmlRenderConfig());
        this.config.setGlobalFont(globalFont);
        this.config.setGlobalFontSize(globalFontSize);
    }

    public HtmlRenderPolicy(HtmlRenderConfig config) {
        ElementRenderer[] renderers = new ElementRenderer[]{new ARenderer(), new BigRenderer(), new BoldRenderer(), new BreakRenderer(), new DeleteRenderer(), new FigureRenderer(), new FigureCaptionRenderer(), new HeaderBreakRenderer(), new HeaderRenderer(), new ImageRenderer(), new ItalicRenderer(), new ListItemRenderer(), new ListRenderer(), new MarkRenderer(), new MathRenderer(), new OmittedRenderer(), new PreRenderer(), new RubyRenderer(), new SmallRenderer(), new SubscriptRenderer(), new SuperscriptRenderer(), new SvgRenderer(), new TableCellRenderer(), new TableRenderer(), new UnderlineRenderer(), new WalkThroughRenderer()};
        this.elRenderers = new HashMap<String, ElementRenderer>(renderers.length);
        for (ElementRenderer renderer : renderers) {
            for (String tag : renderer.supportedTags()) {
                this.elRenderers.put(tag, renderer);
            }
        }
        this.config = config;
        if (config.getCustomRenderers() != null) {
            for (ElementRenderer customRenderer : config.getCustomRenderers()) {
                for (String tag : customRenderer.supportedTags()) {
                    this.elRenderers.put(tag, customRenderer);
                }
            }
        }
    }

    public HtmlRenderConfig getConfig() {
        return this.config;
    }

    protected boolean validate(String data) {
        return StringUtils.isNotEmpty((CharSequence)data);
    }

    public void doRender(RenderContext<String> context) throws Exception {
        Document document = JsoupUtils.parse((String)context.getData());
        document.outputSettings().prettyPrint(false).indentAmount(0);
        HtmlRenderContext htmlRenderContext = new HtmlRenderContext(context, this.elRenderers::get);
        htmlRenderContext.setGlobalFont(this.config.getGlobalFont());
        if (this.config.getGlobalFontSizeInHalfPoints() > 0) {
            htmlRenderContext.setGlobalFontSize(BigInteger.valueOf(this.config.getGlobalFontSizeInHalfPoints()));
        }
        htmlRenderContext.getNumberingContext().setIndent(this.config.getNumberingIndent());
        htmlRenderContext.getNumberingContext().setSpacing(this.config.getNumberingSpacing());
        htmlRenderContext.setShowDefaultTableBorderInTableCell(this.config.isShowDefaultTableBorderInTableCell());
        htmlRenderContext.renderDocument(document);
    }

    protected void afterRender(RenderContext<String> context) {
        List bodyElements;
        boolean hasSibling = this.hasSibling(context.getRun());
        this.clearPlaceholder(context, !hasSibling);
        IBody container = context.getContainer();
        if (container.getPartType() == BodyType.TABLECELL && ((bodyElements = container.getBodyElements()).isEmpty() || ((IBodyElement)bodyElements.get(bodyElements.size() - 1)).getElementType() != BodyElementType.PARAGRAPH)) {
            ((XWPFTableCell)container).addParagraph();
        }
    }

    private boolean hasSibling(XWPFRun run) {
        boolean hasSibling = false;
        CTR ctr = run.getCTR();
        XmlCursor xmlCursor = ctr.newCursor();
        xmlCursor.push();
        while (xmlCursor.toNextSibling()) {
            if (!this.isValidSibling(xmlCursor.getObject())) continue;
            hasSibling = true;
            break;
        }
        if (!hasSibling) {
            xmlCursor.pop();
            while (xmlCursor.toPrevSibling()) {
                if (!this.isValidSibling(xmlCursor.getObject())) continue;
                hasSibling = true;
                break;
            }
        }
        xmlCursor.dispose();
        return hasSibling;
    }

    private boolean isValidSibling(XmlObject object) {
        return !(object instanceof CTPPr) && !(object instanceof CTBookmark);
    }
}

