/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.util.List;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.HtmlTreeBuilder;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;
import org.jsoup.parser.Token;

public class CustomHtmlTreeBuilder
extends HtmlTreeBuilder {
    void reconstructFormattingElements() {
        boolean settingsChanged = false;
        ParseSettings origin = this.settings;
        if (this.isSvgElement()) {
            this.settings = ParseSettings.preserveCase;
            settingsChanged = true;
        }
        super.reconstructFormattingElements();
        if (settingsChanged) {
            this.settings = origin;
        }
    }

    Element insert(Token.StartTag startTag) {
        boolean settingsChanged = false;
        ParseSettings origin = this.settings;
        if (this.isSvgElement()) {
            this.settings = ParseSettings.preserveCase;
            settingsChanged = true;
        }
        Element element = super.insert(startTag);
        if (settingsChanged) {
            this.settings = origin;
        }
        return element;
    }

    public List<Node> parseFragment(String inputFragment, Element context, String baseUri, Parser parser) {
        return super.parseFragment(inputFragment, context, baseUri, parser);
    }

    private boolean isSvgElement() {
        if (this.currentToken.isStartTag() && "svg".equals(this.currentToken.asStartTag().normalName)) {
            return true;
        }
        return this.getFromStack("svg") != null;
    }
}

