/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html.tag;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.imageio.ImageIO;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.ddr.image.ImageType;
import org.ddr.poi.html.HtmlRenderContext;
import org.ddr.poi.html.tag.ImageRenderer;
import org.ddr.poi.util.ByteArrayCopyStream;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SvgRenderer
extends ImageRenderer {
    private static final Logger log = LoggerFactory.getLogger(SvgRenderer.class);
    private static final String[] TAGS = new String[]{"svg"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean renderStart(Element element, HtmlRenderContext context) {
        if (!element.hasAttr("xmlns")) {
            element.attr("xmlns", "http://www.w3.org/2000/svg");
        }
        String svg = element.outerHtml().replace(" />", "/>");
        byte[] bytes = svg.getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream svgStream = new ByteArrayInputStream(bytes);){
            BufferedImage image = ImageIO.read(svgStream);
            ImageType type = this.typeOf(image);
            int size = image.getData().getDataBuffer().getSize();
            ByteArrayCopyStream outputStream = new ByteArrayCopyStream(size);
            ImageIO.write((RenderedImage)image, type.getExtension(), outputStream);
            ByteArrayInputStream imageStream = outputStream.toInput();
            this.addPicture(element, context, imageStream, type.getType(), image.getWidth(), image.getHeight(), bytes);
        }
        catch (IOException | InvalidFormatException e) {
            log.warn("Failed to render svg as image: {}", (Object)svg, (Object)e);
        }
        finally {
            Object image = null;
        }
        return false;
    }

    @Override
    public String[] supportedTags() {
        return TAGS;
    }
}

