/*
 * Decompiled with CFR 0.152.
 */
package io.github.burukeyou.dataframe.iframe.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import io.github.burukeyou.dataframe.iframe.IFrame;
import io.github.burukeyou.dataframe.iframe.JDFrame;
import io.github.burukeyou.dataframe.iframe.SDFrame;
import io.github.burukeyou.dataframe.iframe.function.CompareTwo;
import io.github.burukeyou.dataframe.iframe.function.ConsumerNext;
import io.github.burukeyou.dataframe.iframe.function.ConsumerPrevious;
import io.github.burukeyou.dataframe.iframe.function.ListSelectOneFunction;
import io.github.burukeyou.dataframe.iframe.function.ListToOneValueFunction;
import io.github.burukeyou.dataframe.iframe.function.ReplenishFunction;
import io.github.burukeyou.dataframe.iframe.function.SetFunction;
import io.github.burukeyou.dataframe.iframe.group.GroupConcat;
import io.github.burukeyou.dataframe.iframe.group.GroupConcatImpl;
import io.github.burukeyou.dataframe.iframe.impl.AbstractWindowDataFrame;
import io.github.burukeyou.dataframe.iframe.item.FI2;
import io.github.burukeyou.dataframe.iframe.item.FI3;
import io.github.burukeyou.dataframe.iframe.item.FI4;
import io.github.burukeyou.dataframe.iframe.support.Join;
import io.github.burukeyou.dataframe.iframe.support.JoinOn;
import io.github.burukeyou.dataframe.iframe.support.MaxMin;
import io.github.burukeyou.dataframe.iframe.support.VoidJoin;
import io.github.burukeyou.dataframe.util.BeanCopyUtil;
import io.github.burukeyou.dataframe.util.CollectorsPlusUtil;
import io.github.burukeyou.dataframe.util.FrameUtil;
import io.github.burukeyou.dataframe.util.ListUtils;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataFrameImpl<T>
extends AbstractWindowDataFrame<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractDataFrameImpl.class);

    protected AbstractDataFrameImpl() {
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        super.forEach(action);
    }

    @Override
    public Spliterator<T> spliterator() {
        return super.spliterator();
    }

    @Override
    public Iterator<T> iterator() {
        return this.viewList().iterator();
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.stream().collect(collector);
    }

    @Override
    public T[] toArray() {
        List ts = this.viewList();
        if (ts.isEmpty() && this.fieldClass == null) {
            return null;
        }
        Object[] arr = (Object[])Array.newInstance(this.fieldClass, ts.size());
        for (int i = 0; i < ts.size(); ++i) {
            arr[i] = ts.get(i);
        }
        return arr;
    }

    @Override
    public T[] toArray(Class<T> elementClass) {
        List ts = this.viewList();
        if (ts == null || ts.isEmpty()) {
            return (Object[])Array.newInstance(elementClass, 0);
        }
        Object[] array = (Object[])Array.newInstance(elementClass, ts.size());
        for (int i = 0; i < ts.size(); ++i) {
            array[i] = ts.get(i);
        }
        return array;
    }

    @Override
    public boolean isContains(T other) {
        return this.viewList().contains(other);
    }

    @Override
    public <U> boolean isContainValue(Function<T, U> valueFunction, U value) {
        return this.stream().anyMatch(e -> {
            if (e == null) {
                return false;
            }
            Object fieldValue = valueFunction.apply(e);
            if (fieldValue == null && value == null) {
                return true;
            }
            if (value != null) {
                return value.equals(fieldValue);
            }
            return false;
        });
    }

    @Override
    public <U> boolean isNotContainValue(Function<T, U> valueFunction, U value) {
        return !this.isContainValue(valueFunction, value);
    }

    @Override
    public <U> boolean hasNullValue(Function<T, U> valueFunction) {
        return this.stream().map(valueFunction).anyMatch(e -> {
            if (e == null) {
                return true;
            }
            return e instanceof String && StringUtils.isBlank((CharSequence)((String)e));
        });
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.stream().anyMatch(predicate);
    }

    @Override
    public <U> boolean anyMatchValue(Function<T, U> valueFunction, U value) {
        return this.stream().map(valueFunction).anyMatch(e -> AbstractDataFrameImpl.safeCompareValue(e, value));
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        return this.stream().allMatch(predicate);
    }

    @Override
    public <U> boolean allMatchValue(Function<T, U> valueFunction, U value) {
        return this.stream().map(valueFunction).allMatch(e -> AbstractDataFrameImpl.safeCompareValue(value, e));
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return this.stream().noneMatch(predicate);
    }

    @Override
    public <U> boolean noneMatchValue(Function<T, U> valueFunction, U value) {
        return this.stream().map(valueFunction).noneMatch(e -> AbstractDataFrameImpl.safeCompareValue(e, value));
    }

    protected static <U> boolean safeCompareValue(U value, U otherValue) {
        if (otherValue == null && value == null) {
            return true;
        }
        if (value != null) {
            return value.equals(otherValue);
        }
        return false;
    }

    protected void forEachPreStreamDo(ConsumerPrevious<? super T> action) {
        Object pre = null;
        for (T cur : this) {
            action.accept(pre, cur);
            pre = cur;
        }
    }

    protected void forEachNextStreamDo(ConsumerNext<? super T> action) {
        Iterator<T> iterator = this.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        T cur = iterator.next();
        while (iterator.hasNext()) {
            T next = iterator.next();
            action.accept(cur, next);
            cur = next;
        }
        action.accept(cur, null);
    }

    @Override
    public <U> String joining(Function<T, U> joinField, CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return this.stream().map(joinField).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(delimiter, prefix, suffix));
    }

    @Override
    public <U> String joining(Function<T, U> joinField, CharSequence delimiter) {
        return this.joining(joinField, delimiter, "", "");
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        return this.stream().reduce(identity, accumulator);
    }

    @Override
    public T reduce(BinaryOperator<T> accumulator) {
        Optional<Object> reduce = this.stream().reduce(accumulator);
        return reduce.orElse(null);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return this.stream().reduce(identity, accumulator, combiner);
    }

    @Override
    public <K, V> Map<K, V> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        List list = this.viewList();
        if (ListUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(list.size());
        for (Object t : list) {
            map.put(keyMapper.apply(t), valueMapper.apply(t));
        }
        return map;
    }

    @Override
    public <K, K2, V> Map<K, Map<K2, V>> toMulti2Map(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends K2> key2Mapper, Function<? super T, ? extends V> valueMapper) {
        return this.stream().collect(Collectors.groupingBy(keyMapper, LinkedHashMap::new, Collectors.collectingAndThen(Collectors.toList(), list -> JDFrame.read(list).toMap(key2Mapper, valueMapper))));
    }

    @Override
    public <K, K2, K3, V> Map<K, Map<K2, Map<K3, V>>> toMulti3Map(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends K2> key2Mapper, Function<? super T, ? extends K3> key3Mapper, Function<? super T, ? extends V> valueMapper) {
        return this.stream().collect(Collectors.groupingBy(keyMapper, LinkedHashMap::new, Collectors.groupingBy(key2Mapper, LinkedHashMap::new, Collectors.collectingAndThen(Collectors.toList(), list -> JDFrame.read(list).toMap(key3Mapper, valueMapper)))));
    }

    protected <R> Stream<T> whereNullStream(Function<T, R> function) {
        return this.stream().filter(item -> {
            if (item == null) {
                return true;
            }
            Object r = function.apply(item);
            if (r == null) {
                return true;
            }
            if (r instanceof String) {
                return "".equals(r);
            }
            return false;
        });
    }

    protected <R> Stream<T> whereNotNullStream(Function<T, R> function) {
        return this.stream().filter(item -> {
            if (item == null) {
                return false;
            }
            Object r = function.apply(item);
            if (r == null) {
                return false;
            }
            if (r instanceof String) {
                return !"".equals(r);
            }
            return true;
        });
    }

    public <R extends Comparable<R>> Stream<T> whereBetweenStream(Function<T, R> function, R start, R end) {
        Stream<Object> stream = this.streamFilterNull(function);
        stream = start == null ? stream.filter(e -> ((Comparable)function.apply(e)).compareTo(end) <= 0) : (end == null ? stream.filter(e -> ((Comparable)function.apply(e)).compareTo(start) >= 0) : stream.filter(e -> ((Comparable)function.apply(e)).compareTo(start) >= 0 && ((Comparable)function.apply(e)).compareTo(end) <= 0));
        return stream;
    }

    public <R extends Comparable<R>> Stream<T> whereBetweenNStream(Function<T, R> function, R start, R end) {
        Stream<Object> stream = this.streamFilterNull(function);
        stream = start == null ? stream.filter(e -> ((Comparable)function.apply(e)).compareTo(end) < 0) : (end == null ? stream.filter(e -> ((Comparable)function.apply(e)).compareTo(start) > 0) : stream.filter(e -> ((Comparable)function.apply(e)).compareTo(start) > 0 && ((Comparable)function.apply(e)).compareTo(end) < 0));
        return stream;
    }

    public <R extends Comparable<R>> Stream<T> whereBetweenRStream(Function<T, R> function, R start, R end) {
        Stream<Object> stream = this.streamFilterNull(function);
        stream = start == null ? stream.filter(e -> ((Comparable)function.apply(e)).compareTo(end) <= 0) : (end == null ? stream.filter(e -> ((Comparable)function.apply(e)).compareTo(start) > 0) : stream.filter(e -> ((Comparable)function.apply(e)).compareTo(start) > 0 && ((Comparable)function.apply(e)).compareTo(end) <= 0));
        return stream;
    }

    public <R extends Comparable<R>> Stream<T> whereBetweenLStream(Function<T, R> function, R start, R end) {
        Stream<Object> stream = this.streamFilterNull(function);
        stream = start == null ? stream.filter(e -> ((Comparable)function.apply(e)).compareTo(end) < 0) : (end == null ? stream.filter(e -> ((Comparable)function.apply(e)).compareTo(start) >= 0) : stream.filter(e -> ((Comparable)function.apply(e)).compareTo(start) >= 0 && ((Comparable)function.apply(e)).compareTo(end) < 0));
        return stream;
    }

    public <R extends Comparable<R>> Stream<T> whereNotBetweenStream(Function<T, R> function, R start, R end) {
        return this.stream().filter(e -> {
            if (e == null || function.apply(e) == null) {
                return true;
            }
            return ((Comparable)function.apply(e)).compareTo(start) <= 0 || ((Comparable)function.apply(e)).compareTo(end) >= 0;
        });
    }

    public <R extends Comparable<R>> Stream<T> whereNotBetweenNStream(Function<T, R> function, R start, R end) {
        return this.stream().filter(e -> {
            if (e == null || function.apply(e) == null) {
                return true;
            }
            return ((Comparable)function.apply(e)).compareTo(start) < 0 || ((Comparable)function.apply(e)).compareTo(end) > 0;
        });
    }

    public <R> Stream<T> whereInStream(Function<T, R> function, List<R> list) {
        HashSet set = new HashSet(list);
        return this.stream().filter(e -> set.contains(e == null ? null : function.apply(e)));
    }

    public <R> Stream<T> whereNotInStream(Function<T, R> function, List<R> list) {
        HashSet set = new HashSet(list);
        return this.stream().filter(e -> {
            if (e == null) {
                return true;
            }
            return !set.contains(function.apply(e));
        });
    }

    public <R> Stream<T> whereEqStream(Function<T, R> function, R value) {
        return this.stream().filter(e -> {
            if (e == null) {
                return value == null;
            }
            Object fieldValue = function.apply(e);
            if (fieldValue == null && value == null) {
                return true;
            }
            if (value != null) {
                return value.equals(fieldValue);
            }
            return false;
        });
    }

    public <R> Stream<T> whereNotEqStream(Function<T, R> function, R value) {
        return this.stream().filter(e -> {
            if (value == null) {
                if (e == null) {
                    return false;
                }
                return function.apply(e) != null;
            }
            if (e == null) {
                return true;
            }
            return !value.equals(function.apply(e));
        });
    }

    public <R extends Comparable<R>> Stream<T> whereGtStream(Function<T, R> function, R value) {
        return this.streamFilterNull(function).filter(e -> ((Comparable)function.apply(e)).compareTo(value) > 0);
    }

    public <R extends Comparable<R>> Stream<T> whereGeStream(Function<T, R> function, R value) {
        return this.streamFilterNull(function).filter(e -> ((Comparable)function.apply(e)).compareTo(value) >= 0);
    }

    public <R extends Comparable<R>> Stream<T> whereLtStream(Function<T, R> function, R value) {
        return this.streamFilterNull(function).filter(e -> ((Comparable)function.apply(e)).compareTo(value) < 0);
    }

    public <R extends Comparable<R>> Stream<T> whereLeStream(Function<T, R> function, R value) {
        return this.streamFilterNull(function).filter(e -> ((Comparable)function.apply(e)).compareTo(value) <= 0);
    }

    public <R> Stream<T> whereLikeStream(Function<T, R> function, R value) {
        return this.streamFilterNull(function).filter(e -> String.valueOf(function.apply(e)).contains(String.valueOf(value)));
    }

    public <R> Stream<T> whereNotLikeStream(Function<T, R> function, R value) {
        return this.stream().filter(e -> {
            if (e == null || function.apply(e) == null) {
                return true;
            }
            return !String.valueOf(function.apply(e)).contains(String.valueOf(value));
        });
    }

    public <R> Stream<T> whereLikeLeftStream(Function<T, R> function, R value) {
        return this.streamFilterNull(function).filter(e -> String.valueOf(function.apply(e)).startsWith(String.valueOf(value)));
    }

    public <R> Stream<T> whereLikeRightStream(Function<T, R> function, R value) {
        return this.streamFilterNull(function).filter(e -> String.valueOf(function.apply(e)).endsWith(String.valueOf(value)));
    }

    @Override
    public <R> BigDecimal sum(Function<T, R> function) {
        return this.stream().map(function).filter(Objects::nonNull).collect(CollectorsPlusUtil.summingBigDecimal(e -> {
            if (e instanceof BigDecimal) {
                return (BigDecimal)e;
            }
            return new BigDecimal(String.valueOf(e));
        }));
    }

    @Override
    public <R> BigDecimal avg(Function<T, R> function) {
        List bigDecimalList = this.stream().map(function).filter(Objects::nonNull).map((? super T e) -> {
            if (e instanceof BigDecimal) {
                return (BigDecimal)e;
            }
            return new BigDecimal(String.valueOf(e));
        }).collect(Collectors.toList());
        if (bigDecimalList.isEmpty()) {
            return null;
        }
        return bigDecimalList.stream().reduce(BigDecimal.ZERO, BigDecimal::add).divide(BigDecimal.valueOf(bigDecimalList.size()), this.defaultScale, this.defaultRoundingMode);
    }

    @Override
    public <R extends Comparable<? super R>> MaxMin<R> maxMinValue(Function<T, R> function) {
        MaxMin<T> maxAndMin = this.maxMin(function);
        return new MaxMin<Comparable>((Comparable)this.getApplyValue(function, maxAndMin.getMax()), (Comparable)this.getApplyValue(function, maxAndMin.getMin()));
    }

    @Override
    public <R extends Comparable<? super R>> MaxMin<T> maxMin(Function<T, R> function) {
        List itemList = this.stream().filter(e -> e != null && function.apply(e) != null).collect(Collectors.toList());
        if (itemList.isEmpty()) {
            return new MaxMin<Object>(null, null);
        }
        Object max = itemList.get(0);
        Object min = itemList.get(0);
        for (int i = 1; i < itemList.size(); ++i) {
            Object cur = itemList.get(i);
            Comparable curValue = (Comparable)function.apply(cur);
            Comparable maxValue = (Comparable)function.apply(max);
            Comparable minValue = (Comparable)function.apply(min);
            if (curValue.compareTo(maxValue) >= 0) {
                max = cur;
            }
            if (curValue.compareTo(minValue) > 0) continue;
            min = cur;
        }
        return new MaxMin(max, min);
    }

    @Override
    public <R extends Comparable<? super R>> R maxValue(Function<T, R> function) {
        Optional<Comparable> value = this.stream().map(function).filter(Objects::nonNull).max(Comparator.comparing(e -> e));
        return (R)((Comparable)value.orElse(null));
    }

    @Override
    public <R extends Comparable<R>> T max(Function<T, R> function) {
        Optional<Object> max = this.stream().filter(e -> function.apply(e) != null).max(Comparator.comparing(function));
        return max.orElse(null);
    }

    @Override
    public <R extends Comparable<? super R>> R minValue(Function<T, R> function) {
        Optional<Comparable> value = this.stream().map(function).filter(Objects::nonNull).min(Comparator.comparing(e -> e));
        return (R)((Comparable)value.orElse(null));
    }

    @Override
    public <R extends Comparable<R>> T min(Function<T, R> function) {
        Optional<Object> min = this.stream().filter(e -> function.apply(e) != null).min(Comparator.comparing(function));
        return min.orElse(null);
    }

    @Override
    public long count() {
        return this.stream().count();
    }

    @Override
    public boolean isEmpty() {
        return this.count() <= 0L;
    }

    @Override
    public boolean isNotEmpty() {
        return this.count() > 0L;
    }

    protected <K> List<FI2<K, List<T>>> groupListKey(Function<? super T, ? extends K> key) {
        return FrameUtil.toListFI2(this.stream().collect(Collectors.groupingBy(key)));
    }

    protected <K, V> List<FI2<K, V>> groupListKey(Function<T, K> key, ListToOneValueFunction<T, V> function) {
        return this.groupListKey(key).stream().map((? super T e) -> new FI2(e.getC1(), function.apply((List)e.getC2()))).collect(Collectors.toList());
    }

    protected <K, J> List<FI3<K, J, List<T>>> groupListKey(Function<T, K> key, Function<T, J> key2) {
        return FrameUtil.toListFI3(this.stream().collect(Collectors.groupingBy(key, Collectors.groupingBy(key2))));
    }

    protected <K, J, V> List<FI3<K, J, V>> groupListKey(Function<T, K> key, Function<T, J> key2, ListToOneValueFunction<T, V> function) {
        return this.groupListKey(key, key2).stream().map((? super T e) -> new FI3(e.getC1(), e.getC2(), function.apply((List)e.getC3()))).collect(Collectors.toList());
    }

    protected <K, J, H> List<FI4<K, J, H, List<T>>> groupListKey(Function<T, K> key, Function<T, J> key2, Function<T, H> key3) {
        return FrameUtil.toListFI4(this.stream().collect(Collectors.groupingBy(key, Collectors.groupingBy(key2, Collectors.groupingBy(key3)))));
    }

    protected <K, J, H, V> List<FI4<K, J, H, V>> groupListKey(Function<T, K> key, Function<T, J> key2, Function<T, H> key3, ListToOneValueFunction<T, V> function) {
        return this.groupListKey(key, key2, key3).stream().map((? super T e) -> new FI4(e.getC1(), e.getC2(), e.getC3(), function.apply((List)e.getC4()))).collect(Collectors.toList());
    }

    public <K, V> List<FI2<K, V>> groupAfterCustom(Function<T, K> key, Function<List<T>, V> groupList) {
        Map<K, V> map = this.stream().collect(Collectors.groupingBy(key, Collectors.collectingAndThen(Collectors.toList(), groupList)));
        return FrameUtil.toListFI2(map);
    }

    public <K, J, V> List<FI3<K, J, V>> groupAfterCustom(Function<T, K> key, Function<T, J> key2, Function<List<T>, V> groupList) {
        Map<K, Map<J, V>> map = this.stream().collect(Collectors.groupingBy(key, Collectors.groupingBy(key2, Collectors.collectingAndThen(Collectors.toList(), groupList))));
        return FrameUtil.toListFI3(map);
    }

    public <K, J, H, V> List<FI4<K, J, H, V>> groupAfterCustom(Function<T, K> key, Function<T, J> key2, Function<T, H> key3, Function<List<T>, V> groupList) {
        Map<K, Map<J, Map<H, V>>> map = this.stream().collect(Collectors.groupingBy(key, Collectors.groupingBy(key2, Collectors.groupingBy(key3, Collectors.collectingAndThen(Collectors.toList(), groupList)))));
        return FrameUtil.toListFI4(map);
    }

    public <K> List<FI2<K, String>> groupByConcatStream(Function<T, K> key, GroupConcat<T> concat) {
        return this.groupAfterCustom(key, list -> this.groupByConcatListToString(concat, (List<T>)list));
    }

    public <K, J> List<FI3<K, J, String>> groupByConcatStream(Function<T, K> key, Function<T, J> key2, GroupConcat<T> concat) {
        return this.groupAfterCustom(key, key2, list -> this.groupByConcatListToString(concat, (List<T>)list));
    }

    public <K, J, H> List<FI4<K, J, H, String>> groupByConcatStream(Function<T, K> key, Function<T, J> key2, Function<T, H> key3, GroupConcat<T> concat) {
        return this.groupAfterCustom(key, key2, key3, list -> this.groupByConcatListToString(concat, (List<T>)list));
    }

    protected String groupByConcatListToString(GroupConcat<T> concat, List<T> list) {
        GroupConcatImpl concatImpl = (GroupConcatImpl)concat;
        return SDFrame.read(list).joining(concatImpl.getAggField(), concatImpl.getDelimiter(), concatImpl.getPrefix(), concatImpl.getSuffix());
    }

    protected <K, V> List<FI2<K, V>> groupKey(Function<T, K> K, Collector<T, ?, V> tBigDecimalCollector) {
        Map<K, V> resultMap = this.stream().collect(Collectors.groupingBy(K, tBigDecimalCollector));
        return FrameUtil.toListFI2(resultMap);
    }

    protected <K, J, V> List<FI3<K, J, V>> groupKey(Function<T, K> K, Function<T, J> J, Collector<T, ?, V> tBigDecimalCollector) {
        Map<K, Map<J, V>> map = this.stream().collect(Collectors.groupingBy(K, Collectors.groupingBy(J, tBigDecimalCollector)));
        return FrameUtil.toListFI3(map);
    }

    protected <K, J, H, V> List<FI4<K, J, H, V>> groupKey(Function<T, K> K, Function<T, J> J, Function<T, H> H, Collector<T, ?, V> collectorType) {
        Map<K, Map<J, Map<H, V>>> map = this.stream().collect(Collectors.groupingBy(K, Collectors.groupingBy(J, Collectors.groupingBy(H, collectorType))));
        return FrameUtil.toListFI4(map);
    }

    protected <K, J, V extends Comparable<V>> Map<K, Map<J, T>> groupToMap(Function<T, K> key, Function<T, J> key2, Function<List<T>, T> getListMaxFunction) {
        return this.stream().collect(Collectors.groupingBy(key, Collectors.groupingBy(key2, Collectors.collectingAndThen(Collectors.toList(), getListMaxFunction))));
    }

    protected <V extends Comparable<? super V>> Function<List<T>, T> getListMaxFunction(Function<T, V> value) {
        return e -> e.stream().filter(a -> value.apply(a) != null).max(Comparator.comparing(value)).orElse(null);
    }

    protected <V extends Comparable<? super V>> Function<List<T>, T> getListMinFunction(Function<T, V> value) {
        return e -> e.stream().min(Comparator.comparing(value)).orElse(null);
    }

    protected <V extends Comparable<? super V>> Function<List<T>, MaxMin<V>> getListGroupMaxMinValueFunction(Function<T, V> value) {
        return list -> {
            if (list == null || list.isEmpty()) {
                return null;
            }
            MaxMin<Comparable> maxMin = new MaxMin<Comparable>();
            maxMin.setMax(list.stream().max(Comparator.comparing(value)).map(value).orElse(null));
            maxMin.setMin(list.stream().min(Comparator.comparing(value)).map(value).orElse(null));
            return maxMin;
        };
    }

    protected <V extends Comparable<? super V>> Function<List<T>, MaxMin<T>> getListGroupMaxMinFunction(Function<T, V> value) {
        return list -> {
            if (list == null || list.isEmpty()) {
                return new MaxMin();
            }
            MaxMin<Object> maxMin = new MaxMin<Object>();
            maxMin.setMax(list.stream().max(Comparator.comparing(value)).orElse(null));
            maxMin.setMin(list.stream().min(Comparator.comparing(value)).orElse(null));
            return maxMin;
        };
    }

    public <R> Stream<T> streamFilterNull(Function<T, R> function) {
        return this.stream().filter(e -> e != null && function.apply(e) != null);
    }

    @Override
    public List<String> columns() {
        return this.getFieldList();
    }

    @Override
    public <R> List<R> col(Function<T, R> function) {
        return this.stream().map(function).collect(Collectors.toList());
    }

    @Override
    public <R> Set<R> colSet(Function<T, R> function) {
        return this.stream().map(function).collect(Collectors.toSet());
    }

    @Override
    public List<T> page(int page, int pageSize) {
        int count;
        int startIndex;
        if (page < 0 || pageSize < 1) {
            throw new IllegalArgumentException("Page and pageSize must be positive integers.");
        }
        if (page == 0) {
            page = 1;
        }
        if ((startIndex = (page - 1) * pageSize) >= (count = (int)this.count())) {
            return Collections.emptyList();
        }
        int endIndex = Math.min(startIndex + pageSize, count);
        return this.viewList().subList(startIndex, endIndex);
    }

    public String toString() {
        return this.getShowString(15).toString();
    }

    @Override
    public void show() {
        this.show(15);
    }

    @Override
    public void show(int n) {
        StringBuilder sb = this.getShowString(n);
        System.out.println(sb);
    }

    protected List<T> distinctList(List<T> dataList, Comparator<T> comparator, ListSelectOneFunction<T> function) {
        if (ListUtils.isEmpty(dataList) || dataList.size() == 1) {
            return dataList;
        }
        TreeMap treeMap = new TreeMap(comparator);
        for (T t : dataList) {
            treeMap.putIfAbsent(t, new ArrayList());
            List tmpList = (List)treeMap.get(t);
            tmpList.add(t);
        }
        return treeMap.values().stream().map((? super T list) -> {
            if (list.size() == 1) {
                return list.get(0);
            }
            return function.apply((List)list);
        }).collect(Collectors.toList());
    }

    protected <R, K> List<R> joinList(IFrame<K> other, JoinOn<T, K> on, Join<T, K, R> join) {
        return this.joinList(other, on, join, false);
    }

    protected <R, K> List<R> joinList(IFrame<K> other, JoinOn<T, K> on, Join<T, K, R> join, boolean isJoinOnce) {
        ArrayList<R> resultList = new ArrayList<R>();
        block0: for (T cur : this) {
            for (Object k : other) {
                if (!on.on(cur, k)) continue;
                resultList.add(join.join(cur, k));
                if (!isJoinOnce) continue;
                continue block0;
            }
        }
        return resultList;
    }

    protected <K> void joinListLink(IFrame<K> other, JoinOn<T, K> on, VoidJoin<T, K> join) {
        this.joinListLink(other, on, join, false);
    }

    protected <K> void joinListLink(IFrame<K> other, JoinOn<T, K> on, VoidJoin<T, K> join, boolean isJoinOnce) {
        block0: for (T cur : this) {
            for (Object k : other) {
                if (!on.on(cur, k)) continue;
                join.join(cur, k);
                if (!isJoinOnce) continue;
                continue block0;
            }
        }
    }

    protected <R, K> List<R> leftJoinList(IFrame<K> other, JoinOn<T, K> on, Join<T, K, R> join) {
        return this.leftJoinList(other, on, join, false);
    }

    protected <R, K> List<R> leftJoinList(IFrame<K> other, JoinOn<T, K> on, Join<T, K, R> join, boolean isJoinOnce) {
        ArrayList<R> resultList = new ArrayList<R>();
        for (T cur : this) {
            boolean flag = false;
            for (Object k : other) {
                if (!on.on(cur, k)) continue;
                resultList.add(join.join(cur, k));
                flag = true;
                if (!isJoinOnce) continue;
                break;
            }
            if (flag) continue;
            resultList.add(join.join(cur, null));
        }
        return resultList;
    }

    protected <K> void leftJoinListLink(IFrame<K> other, JoinOn<T, K> on, VoidJoin<T, K> join) {
        this.leftJoinListLink(other, on, join, false);
    }

    protected <K> void leftJoinListLink(IFrame<K> other, JoinOn<T, K> on, VoidJoin<T, K> join, boolean isJoinOnce) {
        for (T cur : this) {
            boolean flag = false;
            for (Object k : other) {
                if (!on.on(cur, k)) continue;
                join.join(cur, k);
                flag = true;
                if (!isJoinOnce) continue;
                break;
            }
            if (flag) continue;
            join.join(cur, null);
        }
    }

    protected <R, K> List<R> rightJoinList(IFrame<K> other, JoinOn<T, K> on, Join<T, K, R> join) {
        return this.rightJoinList(other, on, join, false);
    }

    protected <R, K> List<R> rightJoinList(IFrame<K> other, JoinOn<T, K> on, Join<T, K, R> join, boolean isJoinOnce) {
        ArrayList<R> resultList = new ArrayList<R>();
        for (Object k : other) {
            boolean flag = false;
            for (T cur : this) {
                if (!on.on(cur, k)) continue;
                resultList.add(join.join(cur, k));
                flag = true;
                if (!isJoinOnce) continue;
                break;
            }
            if (flag) continue;
            resultList.add(join.join(null, k));
        }
        return resultList;
    }

    protected <K> void rightJoinListLink(IFrame<K> other, JoinOn<T, K> on, VoidJoin<T, K> join) {
        this.rightJoinListLink(other, on, join, false);
    }

    protected <K> void rightJoinListLink(IFrame<K> other, JoinOn<T, K> on, VoidJoin<T, K> join, boolean isJoinOnce) {
        for (Object k : other) {
            boolean flag = false;
            for (T cur : this) {
                if (!on.on(cur, k)) continue;
                join.join(cur, k);
                flag = true;
                if (!isJoinOnce) continue;
                break;
            }
            if (flag) continue;
            join.join(null, k);
        }
    }

    @Override
    public List<T> head(int n) {
        List tsList = this.viewList();
        if (tsList.isEmpty()) {
            return Collections.emptyList();
        }
        if (n >= tsList.size()) {
            return tsList;
        }
        return tsList.subList(0, n);
    }

    @Override
    public List<T> tail(int n) {
        List tsList = this.viewList();
        if (tsList.isEmpty()) {
            return Collections.emptyList();
        }
        if (n >= tsList.size()) {
            return tsList;
        }
        return tsList.subList(tsList.size() - 1 - n + 1, tsList.size());
    }

    @Override
    public T head() {
        List ts = this.viewList();
        return ts.isEmpty() ? null : (T)ts.get(0);
    }

    @Override
    public T tail() {
        List ts = this.viewList();
        return ts.isEmpty() ? null : (T)ts.get(ts.size() - 1);
    }

    @Override
    public List<T> getList(Integer startIndex, Integer endIndex) {
        List ts = this.viewList();
        if (startIndex == null || startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex == null || endIndex > ts.size()) {
            endIndex = ts.size();
        }
        return ts.subList(startIndex, endIndex);
    }

    protected List<T> unionList(List<T> leftList, Collection<T> rightList) {
        if (ListUtils.isEmpty(rightList)) {
            return leftList;
        }
        if (ListUtils.isEmpty(leftList)) {
            return new ArrayList<T>(rightList);
        }
        HashSet<T> set = new HashSet<T>(leftList);
        set.addAll(rightList);
        return new ArrayList<T>(set);
    }

    protected List<T> unionList(List<T> leftList, Collection<T> rightList, Comparator<T> comparator) {
        if (ListUtils.isEmpty(rightList)) {
            return leftList;
        }
        if (ListUtils.isEmpty(leftList)) {
            return new ArrayList<T>(rightList);
        }
        TreeSet<T> set = new TreeSet<T>(comparator);
        set.addAll(leftList);
        set.addAll(rightList);
        return new ArrayList<T>(set);
    }

    protected List<T> retainAllList(List<T> leftList, Collection<T> rightList) {
        if (ListUtils.isEmpty(rightList)) {
            return Collections.emptyList();
        }
        HashSet<T> set = new HashSet<T>(rightList);
        return leftList.stream().filter(set::contains).collect(Collectors.toList());
    }

    protected List<T> retainAllList(List<T> leftList, Collection<T> rightList, Comparator<T> comparator) {
        if (ListUtils.isEmpty(rightList)) {
            return Collections.emptyList();
        }
        TreeSet<T> set = new TreeSet<T>(comparator);
        set.addAll(rightList);
        return leftList.stream().filter(set::contains).collect(Collectors.toList());
    }

    protected <K> List<T> retainAllOtherList(List<T> leftList, Collection<K> rightList, CompareTwo<T, K> comparator) {
        if (ListUtils.isEmpty(rightList)) {
            return Collections.emptyList();
        }
        return leftList.stream().filter(e -> {
            for (Object k : rightList) {
                if (comparator.compare(e, k) != 0) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
    }

    protected List<T> intersectionList(List<T> leftList, Collection<T> rightList) {
        if (ListUtils.isEmpty(leftList) || ListUtils.isEmpty(rightList)) {
            return Collections.emptyList();
        }
        HashSet<T> set = new HashSet<T>(rightList);
        return leftList.stream().filter(set::contains).distinct().collect(Collectors.toList());
    }

    protected List<T> intersectionList(List<T> leftList, Collection<T> rightList, Comparator<T> comparator) {
        if (ListUtils.isEmpty(leftList) || ListUtils.isEmpty(rightList)) {
            return Collections.emptyList();
        }
        TreeSet<T> set = new TreeSet<T>(comparator);
        set.addAll(rightList);
        return leftList.stream().filter(set::contains).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet(comparator)), ArrayList::new));
    }

    protected List<T> differentList(List<T> leftList, Collection<T> rightList) {
        if (ListUtils.isEmpty(leftList)) {
            return leftList;
        }
        if (ListUtils.isEmpty(rightList)) {
            return leftList;
        }
        HashSet otherSet = new HashSet(rightList);
        leftList = leftList.stream().filter(e -> !otherSet.contains(e)).collect(Collectors.toList());
        return leftList;
    }

    protected List<T> differentList(List<T> leftList, Collection<T> rightList, Comparator<T> comparator) {
        if (ListUtils.isEmpty(leftList)) {
            return leftList;
        }
        if (ListUtils.isEmpty(rightList)) {
            return leftList;
        }
        TreeSet otherSet = new TreeSet(comparator);
        otherSet.addAll(rightList);
        leftList = leftList.stream().filter(e -> !otherSet.contains(e)).collect(Collectors.toList());
        return leftList;
    }

    protected <K> List<T> differentOtherList(List<T> leftList, Collection<K> rightList, CompareTwo<T, K> comparator) {
        if (ListUtils.isEmpty(leftList)) {
            return leftList;
        }
        if (ListUtils.isEmpty(rightList)) {
            return leftList;
        }
        return leftList.stream().filter(e -> {
            for (Object k : rightList) {
                if (comparator.compare(e, k) != 0) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    protected List<T> subtractList(List<T> leftList, Collection<T> rightList) {
        if (ListUtils.isEmpty(rightList)) {
            return leftList;
        }
        LinkedList<T> result = new LinkedList<T>(leftList);
        for (T t : rightList) {
            result.remove(t);
        }
        return result;
    }

    protected List<T> subtractList(List<T> leftList, Collection<T> rightList, Comparator<T> comparator) {
        if (ListUtils.isEmpty(rightList)) {
            return leftList;
        }
        LinkedList<T> result = new LinkedList<T>(leftList);
        block0: for (T t : rightList) {
            Iterator each = result.iterator();
            while (each.hasNext()) {
                if (comparator.compare(each.next(), t) != 0) continue;
                each.remove();
                continue block0;
            }
        }
        return result;
    }

    protected static <T, C> List<T> replenishList(List<T> itemDTOList, Function<T, C> collectDim, List<C> allDim, Function<C, T> getEmptyObject) {
        allDim = new ArrayList<C>(new HashSet<C>(allDim));
        List collect = itemDTOList.stream().map(collectDim).collect(Collectors.toList());
        collect = new ArrayList(new HashSet(collect));
        allDim.removeAll(collect);
        return allDim.stream().map(getEmptyObject).collect(Collectors.toList());
    }

    protected static <T, C> List<T> replenish(List<T> itemDTOList, Function<T, C> collectDim, List<C> allDim, Function<C, T> getEmptyObject) {
        itemDTOList = new ArrayList<T>(itemDTOList);
        List<T> otherList = AbstractDataFrameImpl.replenishList(itemDTOList, collectDim, allDim, getEmptyObject);
        itemDTOList.addAll(otherList);
        return itemDTOList;
    }

    @Override
    public <C> List<T> replenishList(Function<T, C> collectDim, List<C> allDim, Function<C, T> getEmptyObject) {
        return AbstractDataFrameImpl.replenishList(this.viewList(), collectDim, allDim, getEmptyObject);
    }

    public static <T, G, C> List<T> replenish(List<T> itemDTOList, Function<T, G> groupDim, Function<T, C> collectDim, List<C> allDim, ReplenishFunction<G, C, T> getEmptyObject) {
        Map<G, List<T>> nameItemListMap = itemDTOList.stream().collect(Collectors.groupingBy(groupDim));
        nameItemListMap.forEach((? super K name, ? super V itemList) -> {
            ArrayList tmpAll = new ArrayList(allDim);
            List abasicssaList = itemList.stream().map(collectDim).collect(Collectors.toList());
            tmpAll.removeAll(abasicssaList);
            if (ListUtils.isNotEmpty(tmpAll)) {
                List missingList = tmpAll.stream().map((? super T e) -> getEmptyObject.apply(name, e)).collect(Collectors.toList());
                itemList.addAll(missingList);
            }
        });
        return nameItemListMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    protected static <T, G, C> List<T> replenish(List<T> itemDTOList, Function<T, G> groupDim, Function<T, C> collectDim, ReplenishFunction<G, C, T> getEmptyObject) {
        List allDim = itemDTOList.stream().map(collectDim).filter(Objects::nonNull).collect(Collectors.toList());
        allDim = new ArrayList(new HashSet(allDim));
        return AbstractDataFrameImpl.replenish(itemDTOList, groupDim, collectDim, allDim, getEmptyObject);
    }

    protected static <C> List<C> mergeCollection(Collection<List<C>> values) {
        List allAbscissa = values.stream().flatMap(Collection::stream).collect(Collectors.toList());
        allAbscissa = new HashSet(allAbscissa).stream().collect(Collectors.toList());
        return allAbscissa;
    }

    protected <R> R getApplyValue(Function<T, R> fun, T obj) {
        return obj == null ? null : (R)fun.apply(obj);
    }

    protected <F> Stream<T> fi2Stream(Stream<FI2<T, F>> stream, SetFunction<T, F> setFunction) {
        return stream.map((? super T e) -> {
            setFunction.accept(e.getC1(), e.getC2());
            return e.getC1();
        });
    }

    protected Stream<FI2<T, String>> explodeStringStream(Function<T, String> getFunction, String delimiter) {
        return this.stream().flatMap(e -> {
            String fieldValue = (String)getFunction.apply(e);
            if (StringUtils.isBlank((CharSequence)fieldValue)) {
                return Stream.of(new FI2<Object, String>(e, fieldValue));
            }
            fieldValue = fieldValue.trim();
            String[] arrText = (fieldValue = StringUtils.strip((String)fieldValue, (String)"[]")).split(delimiter);
            int length = arrText.length;
            if (length <= 1) {
                return Stream.of(new FI2<Object, String>(e, (String)getFunction.apply(e)));
            }
            return Arrays.stream(arrText).map((? super T text) -> new FI2(BeanCopyUtil.copyProperties(e, e.getClass()), StringUtils.strip((String)text, (String)"\""))).collect(Collectors.toList()).stream();
        });
    }

    protected Stream<FI2<T, String>> explodeJsonArrayStream(Function<T, String> getFunction) {
        return this.stream().flatMap(e -> {
            String fieldValue = (String)getFunction.apply(e);
            if (StringUtils.isBlank((CharSequence)fieldValue) || !JSON.isValidArray((String)fieldValue)) {
                return Stream.of(new FI2<Object, String>(e, fieldValue));
            }
            JSONArray objects = JSON.parseArray((String)fieldValue);
            if (objects.isEmpty()) {
                return Stream.of(new FI2<Object, String>(e, fieldValue));
            }
            if (objects.size() == 1) {
                return Stream.of(new FI2<Object, String>(e, objects.get(0).toString()));
            }
            return objects.stream().map((? super T text) -> new FI2(BeanCopyUtil.copyProperties(e, e.getClass()), text.toString())).collect(Collectors.toList()).stream();
        });
    }

    protected <E> Stream<FI2<T, E>> explodeCollectionStream(Function<T, ? extends Collection<E>> getFunction) {
        return this.stream().flatMap(e -> {
            Object fieldValue = getFunction.apply(e);
            if (fieldValue == null) {
                return Stream.of(new FI2<Object, Object>(e, null));
            }
            Class<?> fieldValueClass = fieldValue.getClass();
            if (!Collection.class.isAssignableFrom(fieldValueClass)) {
                return Stream.of(new FI2<Object, Object>(e, null));
            }
            Collection objects = (Collection)fieldValue;
            if (objects.isEmpty()) {
                return Stream.of(new FI2<Object, Object>(e, null));
            }
            if (objects.size() == 1) {
                return Stream.of(new FI2(e, objects.iterator().next()));
            }
            return objects.stream().map((? super T text) -> new FI2(BeanCopyUtil.copyProperties(e, e.getClass()), text)).collect(Collectors.toList()).stream();
        });
    }

    protected <E> Stream<FI2<T, E>> explodeCollectionArrayStream(Function<T, ?> getFunction, Class<E> elementClass) {
        return this.stream().flatMap(e -> {
            Object fieldValue = getFunction.apply(e);
            if (fieldValue == null) {
                return Stream.of(new FI2<Object, Object>(e, null));
            }
            Class<?> fieldValueClass = fieldValue.getClass();
            if (!fieldValueClass.isArray() && !Collection.class.isAssignableFrom(fieldValueClass)) {
                return Stream.of(new FI2<Object, Object>(e, null));
            }
            Stream<Object> stream = null;
            if (fieldValueClass.isArray()) {
                Object[] objects = (Object[])fieldValue;
                stream = Arrays.stream(objects);
                if (objects.length == 0) {
                    return Stream.of(new FI2<Object, Object>(e, null));
                }
                if (objects.length == 1) {
                    return Stream.of(new FI2(e, elementClass.cast(objects[0])));
                }
            } else if (Collection.class.isAssignableFrom(fieldValueClass)) {
                Collection objects = (Collection)fieldValue;
                if (objects.isEmpty()) {
                    return Stream.of(new FI2<Object, Object>(e, null));
                }
                if (objects.size() == 1) {
                    return Stream.of(new FI2(e, elementClass.cast(objects.iterator().next())));
                }
                stream = objects.stream();
            }
            return stream.map((? super T text) -> new FI2(BeanCopyUtil.copyProperties(e, e.getClass()), elementClass.cast(text))).collect(Collectors.toList()).stream();
        });
    }
}

