/*
 * Decompiled with CFR 0.152.
 */
package io.github.burukeyou.dataframe.iframe.group;

import io.github.burukeyou.dataframe.iframe.group.GroupWindowImpl;
import io.github.burukeyou.dataframe.iframe.window.Sorter;
import java.util.Comparator;
import java.util.function.Function;

public interface GroupWindow<T> {
    public static <T, U extends Comparable<? super U>> GroupWindow<T> sortAscBy(Function<T, U> sortField) {
        return new GroupWindowImpl<T>(Sorter.sortAscBy(sortField));
    }

    public static <T, U extends Comparable<? super U>> GroupWindow<T> sortDescBy(Function<T, U> sortField) {
        return new GroupWindowImpl<T>(Sorter.sortDescBy(sortField));
    }

    public static <T, U extends Comparable<? super U>> GroupWindow<T> sortBy(Comparator<T> comparator) {
        return new GroupWindowImpl<T>(Sorter.toSorter(comparator));
    }

    public static <T, U extends Comparable<? super U>> GroupWindow<T> distinctBy(Function<T, U> sortField) {
        return new GroupWindowImpl<T>(Comparator.comparing(sortField));
    }

    public static <T, U extends Comparable<? super U>> GroupWindow<T> distinctBy(Comparator<T> distinctComparator) {
        return new GroupWindowImpl<T>(distinctComparator);
    }

    public <U extends Comparable<? super U>> GroupWindow<T> sortAsc(Function<T, U> var1);

    public <U extends Comparable<? super U>> GroupWindow<T> sortDesc(Function<T, U> var1);

    public <U extends Comparable<? super U>> GroupWindow<T> distinct(Function<T, U> var1);

    public GroupWindow<T> distinct(Comparator<T> var1);

    public Sorter<T> getSorter();

    public Comparator<T> getDistincter();
}

