/*
 * Decompiled with CFR 0.152.
 */
package io.github.burukeyou.dataframe.iframe.function;

import java.io.Serializable;
import java.util.function.Function;

public interface CompareTwo<L, R> {
    public int compare(L var1, R var2);

    public static <L, R, U extends Comparable<? super U>> CompareTwo<L, R> on(Function<L, U> leftField, Function<R, U> rightField) {
        return (t, k) -> {
            if (t == null && k == null) {
                return 0;
            }
            if (t == null) {
                return -1;
            }
            if (k == null) {
                return 1;
            }
            Comparable leftFieldValue = (Comparable)leftField.apply(t);
            Comparable rightFieldValue = (Comparable)rightField.apply(k);
            if (leftFieldValue == null && rightFieldValue == null) {
                return 0;
            }
            if (leftFieldValue == null) {
                return -1;
            }
            if (rightFieldValue == null) {
                return 1;
            }
            return leftFieldValue.compareTo(rightFieldValue);
        };
    }

    default public <U extends Comparable<? super U>> CompareTwo<L, R> thenOn(Function<L, U> leftField, Function<R, U> rightField) {
        CompareTwo<L, R> other = CompareTwo.on(leftField, rightField);
        return (CompareTwo<Object, Object> & Serializable)(c1, c2) -> {
            int res = this.compare(c1, c2);
            return res != 0 ? res : other.compare(c1, c2);
        };
    }

    default public CompareTwo<L, R> thenCompare(CompareTwo<L, R> other) {
        return (CompareTwo<Object, Object> & Serializable)(c1, c2) -> {
            int res = this.compare(c1, c2);
            return res != 0 ? res : other.compare(c1, c2);
        };
    }
}

