/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.docker;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.bonigarcia.wdm.config.Config;
import io.github.bonigarcia.wdm.docker.DockerHubTags;
import io.github.bonigarcia.wdm.online.HttpClient;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerHubService {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String GET_IMAGE_TAGS_PATH_FORMAT = "%sv2/repositories/%s/tags?page=%s&page_size=1024";
    private Config config;
    private HttpClient client;

    public DockerHubService(Config config, HttpClient client) {
        this.config = config;
        this.client = client;
    }

    public List<DockerHubTags.DockerHubTag> listTags(String dockerImageFormat) {
        this.log.debug("Getting browser image list from Docker Hub");
        ArrayList<DockerHubTags.DockerHubTag> results = new ArrayList<DockerHubTags.DockerHubTag>();
        String dockerHubUrl = this.config.getDockerHubUrl();
        String repo = dockerImageFormat.substring(0, dockerImageFormat.indexOf(":"));
        Object url = String.format(GET_IMAGE_TAGS_PATH_FORMAT, dockerHubUrl, repo, 1);
        Gson gson = new GsonBuilder().create();
        try {
            do {
                this.log.trace("Sending request to {}", url);
                HttpGet createHttpGet = this.client.createHttpGet(new URL(url.toString()));
                ClassicHttpResponse response = this.client.execute((ClassicHttpRequest)createHttpGet);
                BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                DockerHubTags dockerHubTags = (DockerHubTags)gson.fromJson((Reader)reader, DockerHubTags.class);
                results.addAll(dockerHubTags.getResults());
                url = dockerHubTags.next;
                response.close();
            } while (url != null);
        }
        catch (Exception e) {
            this.log.warn("Exception getting browser image list from Docker Hub", (Throwable)e);
        }
        return results;
    }
}

