/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.type.TypeReference;
import io.a2a.spec.EventKind;
import io.a2a.spec.Part;
import io.a2a.spec.StreamingEventKind;
import io.a2a.util.Assert;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class Message
implements EventKind,
StreamingEventKind {
    public static final TypeReference<Message> TYPE_REFERENCE = new TypeReference<Message>(){};
    public static final String MESSAGE = "message";
    private final Role role;
    private final List<Part<?>> parts;
    private final String messageId;
    private String contextId;
    private String taskId;
    private final Map<String, Object> metadata;
    private final String kind;
    private final List<String> referenceTaskIds;

    public Message(Role role, List<Part<?>> parts, String messageId, String contextId, String taskId, List<String> referenceTaskIds, Map<String, Object> metadata) {
        this(role, parts, messageId, contextId, taskId, referenceTaskIds, metadata, MESSAGE);
    }

    @JsonCreator
    public Message(@JsonProperty(value="role") Role role, @JsonProperty(value="parts") List<Part<?>> parts, @JsonProperty(value="messageId") String messageId, @JsonProperty(value="contextId") String contextId, @JsonProperty(value="taskId") String taskId, @JsonProperty(value="referenceTaskIds") List<String> referenceTaskIds, @JsonProperty(value="metadata") Map<String, Object> metadata, @JsonProperty(value="kind") String kind) {
        Assert.checkNotNullParam((String)"kind", (Object)kind);
        Assert.checkNotNullParam((String)"parts", parts);
        if (parts.isEmpty()) {
            throw new IllegalArgumentException("Parts cannot be empty");
        }
        Assert.checkNotNullParam((String)"role", (Object)((Object)role));
        if (!kind.equals(MESSAGE)) {
            throw new IllegalArgumentException("Invalid Message");
        }
        this.role = role;
        this.parts = parts;
        this.messageId = messageId == null ? UUID.randomUUID().toString() : messageId;
        this.contextId = contextId;
        this.taskId = taskId;
        this.referenceTaskIds = referenceTaskIds;
        this.metadata = metadata;
        this.kind = kind;
    }

    public Role getRole() {
        return this.role;
    }

    public List<Part<?>> getParts() {
        return this.parts;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getContextId() {
        return this.contextId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public List<String> getReferenceTaskIds() {
        return this.referenceTaskIds;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    public static enum Role {
        USER("user"),
        AGENT("agent");

        private String role;

        private Role(String role) {
            this.role = role;
        }

        @JsonValue
        public String asString() {
            return this.role;
        }
    }

    public static class Builder {
        private Role role;
        private List<Part<?>> parts;
        private String messageId;
        private String contextId;
        private String taskId;
        private List<String> referenceTaskIds;
        private Map<String, Object> metadata;

        public Builder() {
        }

        public Builder(Message message) {
            this.role = message.role;
            this.parts = message.parts;
            this.messageId = message.messageId;
            this.contextId = message.contextId;
            this.taskId = message.taskId;
            this.referenceTaskIds = message.referenceTaskIds;
            this.metadata = message.metadata;
        }

        public Builder role(Role role) {
            this.role = role;
            return this;
        }

        public Builder parts(List<Part<?>> parts) {
            this.parts = parts;
            return this;
        }

        public Builder parts(Part<?> ... parts) {
            this.parts = List.of(parts);
            return this;
        }

        public Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public Builder contextId(String contextId) {
            this.contextId = contextId;
            return this;
        }

        public Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public Builder referenceTaskIds(List<String> referenceTaskIds) {
            this.referenceTaskIds = referenceTaskIds;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Message build() {
            return new Message(this.role, this.parts, this.messageId, this.contextId, this.taskId, this.referenceTaskIds, this.metadata);
        }
    }
}

