/*
 * Decompiled with CFR 0.152.
 */
package zju.cst.aces.util;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.Position;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.platform.launcher.listeners.TestExecutionSummary;
import zju.cst.aces.dto.PromptInfo;

public class TestProcessor {
    private static final JavaParser parser = new JavaParser();
    private String fullTestName;

    public TestProcessor(String fullTestName) {
        this.fullTestName = fullTestName;
    }

    public List<Integer> getErrorLineNum(TestExecutionSummary summary) {
        ArrayList<Integer> errorLineNum = new ArrayList<Integer>();
        summary.getFailures().forEach(failure -> {
            for (StackTraceElement st : failure.getException().getStackTrace()) {
                if (!st.getClassName().contains(this.fullTestName)) continue;
                int lineNum = st.getLineNumber();
                errorLineNum.add(lineNum);
            }
        });
        return errorLineNum;
    }

    public boolean containError(List<Integer> errorLineNum, MethodDeclaration method) {
        int beginPosition = ((Position)method.getBegin().get()).line;
        int endPosition = ((Position)method.getEnd().get()).line;
        return !errorLineNum.stream().filter(lineNum -> lineNum >= beginPosition && lineNum <= endPosition).collect(Collectors.toList()).isEmpty();
    }

    public boolean isTestCase(MethodDeclaration method) {
        return !method.getAnnotations().stream().filter(annotationExpr -> {
            String annotationName = annotationExpr.getNameAsString();
            return annotationName.equals("Test") || annotationName.equals("ParameterizedTest");
        }).collect(Collectors.toList()).isEmpty();
    }

    public String removeErrorTest(PromptInfo promptInfo, TestExecutionSummary summary) {
        String result = promptInfo.getUnitTest();
        try {
            ParseResult parseResult = parser.parse(result);
            CompilationUnit cu = (CompilationUnit)parseResult.getResult().orElseThrow();
            List methods = cu.findAll(MethodDeclaration.class);
            List<Integer> errorLineNum = this.getErrorLineNum(summary);
            for (MethodDeclaration method : methods) {
                if (!this.containError(errorLineNum, method)) continue;
                method.remove();
            }
            if (cu.findAll(MethodDeclaration.class).stream().filter(this::isTestCase).collect(Collectors.toList()).isEmpty()) {
                return null;
            }
            result = cu.toString();
        }
        catch (Exception e) {
            System.out.println("In TestProcessor.removeErrorTest: " + e);
            return null;
        }
        return result;
    }

    public String removeCorrectTest(PromptInfo promptInfo, TestExecutionSummary summary) {
        String result = promptInfo.getUnitTest();
        try {
            ParseResult parseResult = parser.parse(result);
            CompilationUnit cu = (CompilationUnit)parseResult.getResult().orElseThrow();
            List methods = cu.findAll(MethodDeclaration.class);
            List<Integer> errorLineNum = this.getErrorLineNum(summary);
            for (MethodDeclaration method : methods) {
                if (this.containError(errorLineNum, method) || !this.isTestCase(method)) continue;
                promptInfo.addCorrectTest(method);
                method.remove();
            }
            result = cu.toString();
            if (cu.findAll(MethodDeclaration.class).stream().filter(this::isTestCase).collect(Collectors.toList()).isEmpty()) {
                System.out.println("In TestProcessor.removeCorrectTest: No test case left");
            }
        }
        catch (Exception e) {
            System.out.println("In TestProcessor.removeCorrectTest: " + e);
        }
        promptInfo.setUnitTest(result);
        return result;
    }

    public String addCorrectTest(PromptInfo promptInfo) {
        String result = promptInfo.getUnitTest();
        try {
            ParseResult parseResult = parser.parse(result);
            CompilationUnit cu = (CompilationUnit)parseResult.getResult().orElseThrow();
            promptInfo.getCorrectTests().keySet().forEach(className -> cu.getClassByName(className).ifPresent(classOrInterfaceDeclaration -> promptInfo.getCorrectTests().get(className).forEach(methodDeclaration -> {
                if (classOrInterfaceDeclaration.getMethodsByName(methodDeclaration.getNameAsString()).isEmpty()) {
                    classOrInterfaceDeclaration.addMember((BodyDeclaration)methodDeclaration);
                }
            })));
            promptInfo.getCorrectTests().clear();
            result = cu.toString();
        }
        catch (Exception e) {
            System.out.println("In TestProcessor.addCorrectTest: " + e);
        }
        promptInfo.setUnitTest(result);
        return result;
    }
}

