/*
 * Decompiled with CFR 0.152.
 */
package zju.cst.aces.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.CharBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.codehaus.plexus.util.FileUtils;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherConfig;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;
import zju.cst.aces.dto.PromptInfo;
import zju.cst.aces.dto.TestMessage;
import zju.cst.aces.parser.ProjectParser;

public class TestCompiler {
    public static String OS = System.getProperty("os.name").toLowerCase();
    public static File srcTestFolder = new File("src" + File.separator + "test" + File.separator + "java");
    public static File testBackupFolder = new File("src" + File.separator + "backup");
    public static File testOutputFolder;
    public static File buildFolder;
    public static File targetTestsFolder;
    public static File buildBackupFolder;
    public List<String> classpathElements;
    public String testName;
    public String fullTestName;
    public String code;

    public TestCompiler(Path testOutputPath, Path compileOutputPath, Path targetPath, List<String> classpathElements) {
        this.code = "";
        testOutputFolder = testOutputPath.toFile();
        buildFolder = compileOutputPath.toFile();
        buildBackupFolder = targetPath.resolve("test-classes-backup").toFile();
        targetTestsFolder = targetPath.resolve("test-classes").toFile();
        this.classpathElements = classpathElements;
    }

    public TestCompiler(String code, Path testOutputPath, Path compileOutputPath, Path targetPath, List<String> classpathElements) {
        this.code = code;
        testOutputFolder = testOutputPath.toFile();
        buildFolder = compileOutputPath.toFile();
        buildBackupFolder = targetPath.resolve("test-classes-backup").toFile();
        targetTestsFolder = targetPath.resolve("test-classes").toFile();
        this.classpathElements = classpathElements;
    }

    public TestExecutionSummary executeTest(String fullTestName) {
        this.fullTestName = fullTestName;
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String classpath : this.classpathElements) {
                URL url = new File(classpath).toURI().toURL();
                urls.add(url);
            }
            urls.add(buildFolder.toURI().toURL());
            URLClassLoader classLoader = new URLClassLoader(urls.toArray(new URL[0]), this.getClass().getClassLoader());
            ServiceLoader<TestEngine> testEngineServiceLoader = ServiceLoader.load(TestEngine.class, classLoader);
            LauncherConfig launcherConfig = LauncherConfig.builder().enableTestEngineAutoRegistration(false).enableTestExecutionListenerAutoRegistration(false).addTestEngines(new TestEngine[]{testEngineServiceLoader.findFirst().orElseThrow()}).build();
            Launcher launcher = LauncherFactory.create((LauncherConfig)launcherConfig);
            SummaryGeneratingListener listener = new SummaryGeneratingListener();
            launcher.registerTestExecutionListeners(new TestExecutionListener[]{listener});
            LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass(classLoader.loadClass(fullTestName))}).build();
            launcher.execute(request, new TestExecutionListener[0]);
            TestExecutionSummary summary = listener.getSummary();
            return summary;
        }
        catch (Exception e) {
            throw new RuntimeException("In TestCompiler.executeTest: " + e);
        }
    }

    public boolean compileTest(String className, Path outputPath, PromptInfo promptInfo) {
        boolean result;
        if (this.code == "") {
            throw new RuntimeException("In TestCompiler.compileTest: code is empty");
        }
        this.testName = className;
        try {
            if (!outputPath.toAbsolutePath().getParent().toFile().exists()) {
                outputPath.toAbsolutePath().getParent().toFile().mkdirs();
            }
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
            SimpleJavaFileObject sourceJavaFileObject = new SimpleJavaFileObject(URI.create(className + ".java"), JavaFileObject.Kind.SOURCE){

                @Override
                public CharBuffer getCharContent(boolean b) {
                    return CharBuffer.wrap(TestCompiler.this.code);
                }
            };
            List<SimpleJavaFileObject> compilationUnits = Arrays.asList(sourceJavaFileObject);
            String[] stringArray = new String[4];
            stringArray[0] = "-classpath";
            stringArray[1] = String.join((CharSequence)(OS.contains("win") ? ";" : ":"), this.classpathElements);
            stringArray[2] = "-d";
            stringArray[3] = buildFolder.toPath().toString();
            DiagnosticCollector diagnostics = new DiagnosticCollector();
            List<String> options = Arrays.asList(stringArray);
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, options, null, compilationUnits);
            result = task.call();
            if (!result && promptInfo != null) {
                TestMessage testMessage = new TestMessage();
                ArrayList<String> errors = new ArrayList<String>();
                diagnostics.getDiagnostics().forEach(diagnostic -> errors.add("Error in " + this.testName + ": line " + diagnostic.getLineNumber() + " : " + diagnostic.getMessage(null)));
                testMessage.setErrorType(TestMessage.ErrorType.COMPILE_ERROR);
                testMessage.setErrorMessage(errors);
                promptInfo.setErrorMsg(testMessage);
                this.exportError(errors, outputPath);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("In TestCompiler.compileTest: " + e);
        }
        return result;
    }

    public void exportError(List<String> errors, Path outputPath) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(outputPath.toFile()));
            writer.write(this.code);
            writer.write("\n--------------------------------------------\n");
            writer.write(errors.stream().collect(Collectors.joining("\n")));
            writer.close();
        }
        catch (Exception e) {
            throw new RuntimeException("In TestCompiler.exportError: " + e);
        }
    }

    public static List<String> listClassPaths(MavenProject project, DependencyGraphBuilder dependencyGraphBuilder) {
        ArrayList<String> classPaths = new ArrayList<String>();
        Path artifactPath = Paths.get(project.getBuild().getDirectory(), new String[0]).resolve(project.getBuild().getFinalName() + ".jar");
        if (!artifactPath.toFile().exists()) {
            throw new RuntimeException("In TestCompiler.listClassPaths: " + artifactPath + " does not exist. Run mvn install first.");
        }
        classPaths.add(artifactPath.toString());
        try {
            classPaths.addAll(project.getCompileClasspathElements());
            Class<?> clazz = project.getClass();
            Field privateField = clazz.getDeclaredField("projectBuilderConfiguration");
            privateField.setAccessible(true);
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest((ProjectBuildingRequest)((DefaultProjectBuildingRequest)privateField.get(project)));
            buildingRequest.setProject(project);
            DependencyNode root = dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)buildingRequest, null);
            HashSet<DependencyNode> depSet = new HashSet<DependencyNode>();
            ProjectParser.walkDep(root, depSet);
            for (DependencyNode dep : depSet) {
                if (dep.getArtifact().getFile() == null) continue;
                classPaths.add(dep.getArtifact().getFile().getAbsolutePath());
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return classPaths;
    }

    public void copyAndBackupTestFolder() {
        this.restoreBackupFolder();
        if (srcTestFolder.exists()) {
            try {
                FileUtils.copyDirectoryStructure((File)srcTestFolder, (File)testBackupFolder);
                FileUtils.deleteDirectory((File)srcTestFolder);
                FileUtils.copyDirectoryStructure((File)testOutputFolder, (File)srcTestFolder);
            }
            catch (IOException e) {
                throw new RuntimeException("In TestCompiler.copyAndBackupTestFolder: " + e);
            }
        }
    }

    public void copyAndBackupCompiledTest() {
        File target = targetTestsFolder;
        try {
            if (!buildBackupFolder.exists() && target.exists()) {
                FileUtils.copyDirectoryStructure((File)target, (File)buildBackupFolder);
                FileUtils.deleteDirectory((File)target);
            }
            FileUtils.copyDirectoryStructure((File)buildFolder, (File)target);
        }
        catch (IOException e) {
            throw new RuntimeException("In TestCompiler.copyAndBackupCompiledTest: " + e);
        }
    }

    public void restoreBackupFolder() {
        if (testBackupFolder.exists()) {
            try {
                if (srcTestFolder.exists()) {
                    FileUtils.deleteDirectory((File)srcTestFolder);
                }
                FileUtils.copyDirectoryStructure((File)testBackupFolder, (File)srcTestFolder);
                FileUtils.deleteDirectory((File)testBackupFolder);
            }
            catch (IOException e) {
                throw new RuntimeException("In TestCompiler.restoreTestFolder: " + e);
            }
        }
        if (buildBackupFolder.exists()) {
            File target = targetTestsFolder;
            try {
                if (target.exists()) {
                    FileUtils.deleteDirectory((File)target);
                }
                FileUtils.copyDirectoryStructure((File)buildBackupFolder, (File)target);
                FileUtils.deleteDirectory((File)buildBackupFolder);
            }
            catch (IOException e) {
                throw new RuntimeException("In TestCompiler.restoreTestFolder: " + e);
            }
        }
    }

    public List<String> getClasspathElements() {
        return this.classpathElements;
    }

    public String getTestName() {
        return this.testName;
    }

    public String getFullTestName() {
        return this.fullTestName;
    }

    public String getCode() {
        return this.code;
    }

    public void setClasspathElements(List<String> classpathElements) {
        this.classpathElements = classpathElements;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }

    public void setFullTestName(String fullTestName) {
        this.fullTestName = fullTestName;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestCompiler)) {
            return false;
        }
        TestCompiler other = (TestCompiler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$classpathElements = this.getClasspathElements();
        List<String> other$classpathElements = other.getClasspathElements();
        if (this$classpathElements == null ? other$classpathElements != null : !((Object)this$classpathElements).equals(other$classpathElements)) {
            return false;
        }
        String this$testName = this.getTestName();
        String other$testName = other.getTestName();
        if (this$testName == null ? other$testName != null : !this$testName.equals(other$testName)) {
            return false;
        }
        String this$fullTestName = this.getFullTestName();
        String other$fullTestName = other.getFullTestName();
        if (this$fullTestName == null ? other$fullTestName != null : !this$fullTestName.equals(other$fullTestName)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        return !(this$code == null ? other$code != null : !this$code.equals(other$code));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestCompiler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $classpathElements = this.getClasspathElements();
        result = result * 59 + ($classpathElements == null ? 43 : ((Object)$classpathElements).hashCode());
        String $testName = this.getTestName();
        result = result * 59 + ($testName == null ? 43 : $testName.hashCode());
        String $fullTestName = this.getFullTestName();
        result = result * 59 + ($fullTestName == null ? 43 : $fullTestName.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        return result;
    }

    public String toString() {
        return "TestCompiler(classpathElements=" + this.getClasspathElements() + ", testName=" + this.getTestName() + ", fullTestName=" + this.getFullTestName() + ", code=" + this.getCode() + ")";
    }
}

