/*
 * Decompiled with CFR 0.152.
 */
package zju.cst.aces.util;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import zju.cst.aces.api.config.Config;
import zju.cst.aces.parser.ProjectParser;
import zju.cst.aces.runner.AbstractRunner;

public class TestClassMerger {
    private String sourceFullClassName;
    private String sourceClassName;
    private String packageName;
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private String targetClassName;
    public Config config;

    public TestClassMerger(Config config, String fullClassName) {
        this.config = config;
        this.sourceFullClassName = fullClassName;
        this.sourceClassName = StaticJavaParser.parseClassOrInterfaceType((String)fullClassName).getNameAsString();
        this.packageName = StaticJavaParser.parseClassOrInterfaceType((String)fullClassName).getScope().isPresent() ? ((ClassOrInterfaceType)StaticJavaParser.parseClassOrInterfaceType((String)fullClassName).getScope().get()).asString() : "";
    }

    public boolean mergeWithSuite() throws IOException {
        this.targetClassName = this.sourceClassName + "_Suite";
        Path testSourcePath = this.config.getTestOutput().resolve(this.packageName.replace(".", File.separator));
        if (!Files.exists(testSourcePath, new LinkOption[0])) {
            return false;
        }
        List<String> testNames = TestClassMerger.findTestByClassName(this.sourceClassName, testSourcePath);
        if (testNames.isEmpty()) {
            return false;
        }
        CompilationUnit cu = new CompilationUnit();
        cu.setPackageDeclaration(this.packageName);
        cu.addImport("org.junit.runner.RunWith");
        cu.addImport("org.junit.platform.runner.JUnitPlatform");
        cu.addImport("org.junit.platform.suite.api.SelectClasses");
        ClassOrInterfaceDeclaration classNode = cu.addClass(this.targetClassName);
        classNode.setModifier(Modifier.Keyword.PUBLIC, true);
        NormalAnnotationExpr runWithAnnotation = new NormalAnnotationExpr();
        runWithAnnotation.setName("RunWith");
        runWithAnnotation.addPair("value", (Expression)new NameExpr("JUnitPlatform.class"));
        classNode.addAnnotation((AnnotationExpr)runWithAnnotation);
        NormalAnnotationExpr selectClassesAnnotation = new NormalAnnotationExpr();
        selectClassesAnnotation.setName("SelectClasses");
        ArrayInitializerExpr array = new ArrayInitializerExpr();
        testNames.forEach(testName -> array.getValues().add((Node)new NameExpr(testName.replace(".java", ".class"))));
        MemberValuePair pair = new MemberValuePair("value", (Expression)array);
        selectClassesAnnotation.getPairs().add((Node)pair);
        classNode.addAnnotation((AnnotationExpr)selectClassesAnnotation);
        this.deleteRepeatTestFile(Collections.singletonList(this.targetClassName));
        return this.export(cu.toString());
    }

    private static List<String> findTestByClassName(String className, Path testSourcePath) throws IOException {
        ArrayList<String> testNames = new ArrayList<String>();
        Files.list(testSourcePath).forEach(path -> {
            String name = path.getFileName().toString();
            if (name.endsWith(".java") && name.startsWith(className + "_")) {
                testNames.add(name);
            }
        });
        return testNames;
    }

    private void deleteRepeatTestFile(List<String> classNameToDel) {
        List<String> classPaths = ProjectParser.scanSourceDirectory(this.config.getProject());
        classPaths.forEach(classPath -> {
            String className = classPath.substring(classPath.lastIndexOf(File.separator) + 1, classPath.lastIndexOf("."));
            if (classNameToDel.contains(className)) {
                File classFile = new File((String)classPath);
                classFile.delete();
            }
        });
    }

    public boolean export(String code) {
        Path testSourcePath = this.config.getTestOutput().resolve(this.packageName.replace(".", File.separator));
        Path savePath = testSourcePath.resolve(this.targetClassName + ".java");
        AbstractRunner.exportTest(code, savePath);
        return true;
    }
}

