/*
 * Decompiled with CFR 0.152.
 */
package zju.cst.aces.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import zju.cst.aces.dto.ClassInfo;
import zju.cst.aces.dto.MethodInfo;
import zju.cst.aces.parser.ClassParser;

public class Counter {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static void main(String[] args) throws IOException {
        String classInfoPath = "/private/tmp/chatunitest-info/commons-cli/class-info";
        String allMethodCsvPath = "/private/tmp/chatunitest-info/commons-csv/focal_methods_all.csv";
        String sampledCsvPath = "/private/tmp/chatunitest-info/commons-csv/focal_methods_sampled.csv";
        int sampleSize = 10;
        Counter.countClassMethod(Paths.get(classInfoPath, new String[0]), allMethodCsvPath);
        Counter.sampleMethods(allMethodCsvPath, sampledCsvPath, sampleSize);
    }

    public static void sampleMethods(String inputCsvPath, String sampledCsvPath, int sampleSize) throws IOException {
        List<String> lines = Files.readAllLines(Paths.get(inputCsvPath, new String[0]));
        List<String> dataLines = lines.subList(1, lines.size());
        Collections.shuffle(dataLines, new Random());
        List<String> sampledLines = dataLines.subList(0, Math.min(sampleSize, dataLines.size()));
        try (FileWriter csvWriter = new FileWriter(sampledCsvPath);){
            csvWriter.append("Class Name,Method Signature\n");
            for (String line : sampledLines) {
                csvWriter.append(line).append("\n");
            }
            System.out.println("Sampled CSV file created successfully at: " + sampledCsvPath);
        }
    }

    public static Map<String, List<String>> countClassMethod(Path parseOutputPath) throws IOException {
        HashMap<String, List<String>> testMap = new HashMap<String, List<String>>();
        List classJsonFiles = Files.walk(parseOutputPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toString).filter(f -> f.endsWith("class.json")).collect(Collectors.toList());
        for (String classJsonFile : classJsonFiles) {
            File classInfoFile = new File(classJsonFile);
            ClassInfo classInfo = (ClassInfo)GSON.fromJson(Files.readString(classInfoFile.toPath(), StandardCharsets.UTF_8), ClassInfo.class);
            if (!Counter.filter(classInfo)) continue;
            ArrayList<String> methodList = new ArrayList<String>();
            for (String mSig : classInfo.methodSigs.keySet()) {
                MethodInfo methodInfo = Counter.getMethodInfo(parseOutputPath, classInfo, mSig);
                if (!Counter.filter(methodInfo)) continue;
                methodList.add(mSig);
            }
            testMap.put(classInfo.fullClassName, methodList);
        }
        for (String className : testMap.keySet()) {
            System.out.println("-----------------------");
            System.out.println(className + ":\n");
            ((List)testMap.get(className)).forEach(m -> System.out.println(m + "\n"));
            System.out.println("\n");
        }
        System.out.println("Total class count: " + testMap.size());
        System.out.println("Total method count: " + testMap.values().stream().mapToInt(List::size).sum());
        return testMap;
    }

    public static void countClassMethod(Path parseOutputPath, String outputCsvPath) throws IOException {
        HashMap testMap = new HashMap();
        List classJsonFiles = Files.walk(parseOutputPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toString).filter(f -> f.endsWith("class.json")).collect(Collectors.toList());
        for (String classJsonFile : classJsonFiles) {
            File classInfoFile = new File(classJsonFile);
            ClassInfo classInfo = (ClassInfo)GSON.fromJson(Files.readString(classInfoFile.toPath(), StandardCharsets.UTF_8), ClassInfo.class);
            if (!Counter.filter(classInfo)) continue;
            ArrayList<String> methodList = new ArrayList<String>();
            for (String mSig : classInfo.methodSigs.keySet()) {
                MethodInfo methodInfo = Counter.getMethodInfo(parseOutputPath, classInfo, mSig);
                if (!Counter.filter(methodInfo)) continue;
                methodList.add(mSig);
            }
            testMap.put(classInfo.fullClassName, methodList);
        }
        try (FileWriter csvWriter = new FileWriter(outputCsvPath);){
            csvWriter.append("Class Name,Method Signature\n");
            for (String className : testMap.keySet()) {
                List methods = (List)testMap.get(className);
                for (String method : methods) {
                    csvWriter.append(className).append(",\"").append(method).append("\"\n");
                }
            }
            System.out.println("CSV file created successfully at: " + outputCsvPath);
        }
        System.out.println("Total class count: " + testMap.size());
        System.out.println("Total method count: " + testMap.values().stream().mapToInt(List::size).sum());
    }

    public static MethodInfo getMethodInfo(Path parseOutputPath, ClassInfo info, String mSig) throws IOException {
        String packagePath = info.getPackageName().replace("package ", "").replace(".", File.separator).replace(";", "");
        Path depMethodInfoPath = parseOutputPath.resolve(packagePath).resolve(info.className).resolve(ClassParser.getFilePathBySig(mSig, info));
        if (!depMethodInfoPath.toFile().exists()) {
            return null;
        }
        return (MethodInfo)GSON.fromJson(Files.readString(depMethodInfoPath, StandardCharsets.UTF_8), MethodInfo.class);
    }

    public static boolean filter(ClassInfo classInfo) {
        return classInfo.isPublic && !classInfo.isAbstract && !classInfo.isInterface;
    }

    public static boolean filter(MethodInfo methodInfo) {
        return methodInfo != null && !methodInfo.isConstructor && !methodInfo.isGetSet && !methodInfo.isBoolean && methodInfo.isPublic;
    }
}

