/*
 * Decompiled with CFR 0.152.
 */
package zju.cst.aces.util;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zju.cst.aces.runner.AbstractRunner;

public class CodeExtractor {
    private boolean hasCode;
    private boolean hasSyntacticError;
    private String extractedCode;

    public CodeExtractor(String text) {
        this.extractedCode = this.extractText(text);
    }

    public String extractText(String text) {
        if (text.contains("<INFO>")) {
            List<String> infoList = List.of(text.split("<INFO>"));
            String importsInfo = infoList.get(1);
            Pattern pattern = Pattern.compile("```[java]*([\\s\\S]*?)```");
            Matcher matcher = pattern.matcher(importsInfo);
            ArrayList<String> importList = new ArrayList<String>();
            if (matcher.find()) {
                importList.addAll(Arrays.asList(matcher.group(1).trim().split("\n")));
            }
            for (int i = infoList.size() - 1; i >= 0; --i) {
                String info = infoList.get(i);
                if (!info.contains("```")) continue;
                text = AbstractRunner.repairImports(this.extract(info), importList);
                return text;
            }
        }
        return this.extract(text);
    }

    public String extract(String text) {
        String ec = "";
        if (CodeExtractor.isSyntacticCorrect(text)) {
            this.hasCode = true;
            ec = text;
            this.hasSyntacticError = false;
        } else {
            this.hasCode = false;
            this.hasSyntacticError = false;
            Pattern pattern = Pattern.compile("```[java]*([\\s\\S]*?)```");
            Matcher matcher = pattern.matcher(text);
            while (matcher.find()) {
                String match = matcher.group(1).trim();
                if (!CodeExtractor.isTest(match)) continue;
                if (match.contains("class") && match.contains("import")) {
                    ec = this.syntacticCheck(match);
                    boolean bl = this.hasSyntacticError = !match.equals(ec);
                    if (ec.equals("")) continue;
                    this.hasCode = true;
                    break;
                }
                if (!CodeExtractor.isTestMethod(match)) continue;
                ec = this.syntacticCheck(match);
                boolean bl = this.hasSyntacticError = !match.equals(ec);
                if (ec.equals("")) continue;
                this.hasCode = true;
                break;
            }
            if (!this.hasCode) {
                if (text.contains("```java")) {
                    String separateString = text.split("```java")[1];
                    if (CodeExtractor.isTest(separateString)) {
                        ec = this.syntacticCheck(separateString);
                        boolean bl = this.hasSyntacticError = !separateString.equals(ec);
                        if (!ec.equals("")) {
                            this.hasCode = true;
                        }
                    }
                } else if (text.contains("```")) {
                    String[] separateStrings;
                    for (String separateString : separateStrings = text.split("```")) {
                        if (!CodeExtractor.isTest(separateString)) continue;
                        ec = this.syntacticCheck(separateString);
                        boolean bl = this.hasSyntacticError = !separateString.equals(ec);
                        if (ec.equals("")) continue;
                        this.hasCode = true;
                        break;
                    }
                } else {
                    String[] allowed = new String[]{"import", "packages", "", "@"};
                    String[] codeLines = text.split("\\n");
                    int start = -1;
                    int anchor = -1;
                    int end = -1;
                    boolean[] allowedLines = new boolean[codeLines.length];
                    HashMap<Integer, Integer> leftBrace = new HashMap<Integer, Integer>();
                    HashMap<Integer, Integer> rightBrace = new HashMap<Integer, Integer>();
                    for (int i = 0; i < codeLines.length; ++i) {
                        leftBrace.put(i, codeLines[i].length() - codeLines[i].replace("{", "").length());
                        rightBrace.put(i, codeLines[i].length() - codeLines[i].replace("}", "").length());
                        String stripedLine = codeLines[i].trim();
                        for (String allowStart : allowed) {
                            if (!stripedLine.startsWith(allowStart)) continue;
                            allowedLines[i] = true;
                            break;
                        }
                        if (!codeLines[i].matches(".*public class .*Test.*") || anchor != -1) continue;
                        anchor = i;
                    }
                    if (anchor != -1) {
                        for (start = anchor; start > 0 && allowedLines[start]; --start) {
                        }
                        int leftSum = 0;
                        int rightSum = 0;
                        for (end = anchor; end < codeLines.length && ((leftSum += ((Integer)leftBrace.get(end)).intValue()) != (rightSum += ((Integer)rightBrace.get(end)).intValue()) || leftSum < 1 || rightSum < 1); ++end) {
                        }
                        String tempCode = String.join((CharSequence)"\n", Arrays.copyOfRange(codeLines, start, end + 1));
                        boolean bl = this.hasSyntacticError = !tempCode.equals(ec = this.syntacticCheck(tempCode));
                        if (!ec.equals("")) {
                            this.hasCode = true;
                        }
                    }
                }
            }
        }
        ec = ec.trim();
        return ec;
    }

    private static boolean isSyntacticCorrect(String code) {
        return CodeExtractor.checkFileCorrect(code) || CodeExtractor.checkClassCorrect(code) || CodeExtractor.checkMethodCorrect(code);
    }

    private static boolean checkMethodCorrect(String code) {
        try {
            MethodDeclaration md = StaticJavaParser.parseMethodDeclaration((String)code);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean checkClassCorrect(String code) {
        try {
            ClassOrInterfaceType cd = StaticJavaParser.parseClassOrInterfaceType((String)code);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean checkFileCorrect(String code) {
        try {
            CompilationUnit cu = StaticJavaParser.parse((String)code);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isTest(String code) {
        return code.contains("@Test") || code.contains("@ParameterizedTest");
    }

    public static boolean isTestMethod(String code) {
        if (CodeExtractor.isTest(code)) {
            return CodeExtractor.checkMethodCorrect(code);
        }
        return false;
    }

    public String syntacticCheck(String code) {
        if (CodeExtractor.isSyntacticCorrect((String)code)) {
            return code;
        }
        String[] stopPoints = new String[]{";", "}", "{", " "};
        for (int idx = ((String)code).length() - 1; idx >= 0; --idx) {
            if (!this.contains(stopPoints, ((String)code).charAt(idx))) continue;
            code = ((String)code).substring(0, idx + 1);
            break;
        }
        int leftBracket = this.countOccurrences((String)code, "{");
        int rightBracket = this.countOccurrences((String)code, "}");
        for (int idx = leftBracket - rightBracket; idx > 0; --idx) {
            code = (String)code + "}\n";
        }
        if (CodeExtractor.isSyntacticCorrect((String)code)) {
            return code;
        }
        Pattern pattern = Pattern.compile("(?<=\\})[^\\}]+(?=@)");
        Matcher matcher = pattern.matcher((CharSequence)code);
        ArrayList<String> matches = new ArrayList<String>();
        while (matcher.find()) {
            matches.add(matcher.group());
        }
        if (!matches.isEmpty()) {
            String lastMatch = (String)matches.get(matches.size() - 1);
            int endIdx = ((String)code).lastIndexOf(lastMatch) + lastMatch.length();
            code = ((String)code).substring(0, endIdx).trim();
            int leftCount = this.countOccurrences((String)code, "{");
            int rightCount = this.countOccurrences((String)code, "}");
            for (int i = leftCount - rightCount; i > 0; --i) {
                code = (String)code + "\n}";
            }
        }
        if (CodeExtractor.isSyntacticCorrect((String)code)) {
            return code;
        }
        return "";
    }

    private boolean contains(String[] arr, char target) {
        for (String c : arr) {
            if (c.charAt(0) != target) continue;
            return true;
        }
        return false;
    }

    private int countOccurrences(String str, String target) {
        int count = 0;
        int idx = 0;
        while ((idx = str.indexOf(target, idx)) != -1) {
            ++count;
            idx += target.length();
        }
        return count;
    }

    public boolean getHasCode() {
        return this.hasCode;
    }

    public boolean getHasSyntacticError() {
        return this.hasSyntacticError;
    }

    public String getExtractedCode() {
        if (this.extractedCode == null) {
            System.out.println("=^^^^^^^^^^^^^^^^^^^^^^\n    Extracted code is null!");
            return "";
        }
        return this.extractedCode;
    }
}

