/*
 * Decompiled with CFR 0.152.
 */
package zju.cst.aces.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import zju.cst.aces.api.config.Config;
import zju.cst.aces.api.config.ModelConfig;
import zju.cst.aces.dto.ChatResponse;
import zju.cst.aces.dto.Message;

public class AskGPT {
    private static final MediaType MEDIA_TYPE = MediaType.parse((String)"application/json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public Config config;

    public AskGPT(Config config) {
        this.config = config;
    }

    public ChatResponse askChatGPT(List<Message> messages) {
        String apiKey = this.config.getRandomKey();
        for (int maxTry = 5; maxTry > 0; --maxTry) {
            Response response = null;
            try {
                HashMap<String, Object> payload = new HashMap<String, Object>();
                ModelConfig modelConfig = this.config.getModel().getDefaultConfig();
                payload.put("messages", messages);
                payload.put("model", modelConfig.getModelName());
                payload.put("temperature", this.config.getTemperature());
                payload.put("frequency_penalty", this.config.getFrequencyPenalty());
                payload.put("presence_penalty", this.config.getPresencePenalty());
                payload.put("max_tokens", this.config.getMaxResponseTokens());
                String jsonPayload = GSON.toJson(payload);
                RequestBody body = RequestBody.create((MediaType)MEDIA_TYPE, (String)jsonPayload);
                Request request = new Request.Builder().url(modelConfig.getUrl()).post(body).addHeader("Content-Type", "application/json").addHeader("Authorization", "Bearer " + apiKey).build();
                response = this.config.getClient().newCall(request).execute();
                if (!response.isSuccessful()) {
                    throw new IOException("Unexpected code " + response);
                }
                try {
                    Thread.sleep(this.config.sleepTime);
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException("In AskGPT.askChatGPT: " + ie);
                }
                if (response.body() == null) {
                    throw new IOException("Response body is null.");
                }
                ChatResponse chatResponse = (ChatResponse)GSON.fromJson(response.body().string(), ChatResponse.class);
                response.close();
                return chatResponse;
            }
            catch (IOException e) {
                if (response != null) {
                    response.close();
                }
                this.config.getLog().error("In AskGPT.askChatGPT: " + e);
                continue;
            }
        }
        this.config.getLog().debug("AskGPT: Failed to get response\n");
        return null;
    }
}

