/*
 * Decompiled with CFR 0.152.
 */
package zju.cst.aces.runner;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import zju.cst.aces.api.config.Config;
import zju.cst.aces.dto.ClassInfo;
import zju.cst.aces.dto.MethodInfo;
import zju.cst.aces.runner.AbstractRunner;
import zju.cst.aces.runner.MethodRunner;
import zju.cst.aces.util.Counter;
import zju.cst.aces.util.TestClassMerger;

public class ClassRunner
extends AbstractRunner {
    public ClassInfo classInfo;
    public File infoDir;
    public int index;

    public ClassRunner(Config config, String fullClassName) throws IOException {
        super(config, fullClassName);
        this.infoDir = config.getParseOutput().resolve(fullClassName.replace(".", File.separator)).toFile();
        if (!this.infoDir.isDirectory()) {
            config.getLog().warn("Error: " + fullClassName + " no parsed info found");
        }
        File classInfoFile = new File(this.infoDir + File.separator + "class.json");
        this.classInfo = (ClassInfo)GSON.fromJson(Files.readString(classInfoFile.toPath(), StandardCharsets.UTF_8), ClassInfo.class);
    }

    @Override
    public void start() throws IOException {
        if (this.config.isEnableMultithreading()) {
            this.methodJob();
        } else {
            for (String mSig : this.classInfo.methodSigs.keySet()) {
                MethodInfo methodInfo = ClassRunner.getMethodInfo(this.config, this.classInfo, mSig);
                if (!Counter.filter(methodInfo)) {
                    this.config.getLog().info("Skip method: " + mSig + " in class: " + this.fullClassName);
                    continue;
                }
                new MethodRunner(this.config, this.fullClassName, methodInfo).start();
            }
        }
        if (this.config.isEnableMerge()) {
            new TestClassMerger(this.config, this.fullClassName).mergeWithSuite();
        }
    }

    public void methodJob() {
        final ExecutorService executor = Executors.newFixedThreadPool(this.config.getMethodThreads());
        ArrayList<Future<String>> futures = new ArrayList<Future<String>>();
        for (final String string : this.classInfo.methodSigs.keySet()) {
            Callable<String> callable = new Callable<String>(){

                @Override
                public String call() throws Exception {
                    MethodInfo methodInfo = AbstractRunner.getMethodInfo(ClassRunner.this.config, ClassRunner.this.classInfo, string);
                    if (methodInfo == null) {
                        return "No parsed info found for " + string + " in " + ClassRunner.this.fullClassName;
                    }
                    if (!Counter.filter(methodInfo)) {
                        return "Skip method: " + string + " in class: " + ClassRunner.this.fullClassName;
                    }
                    new MethodRunner(ClassRunner.this.config, ClassRunner.this.fullClassName, methodInfo).start();
                    return "Processed " + string;
                }
            };
            Future<String> future = executor.submit(callable);
            futures.add(future);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                executor.shutdownNow();
            }
        });
        for (Future future : futures) {
            try {
                String result = (String)future.get();
                System.out.println(result);
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        executor.shutdown();
    }
}

