/*
 * Decompiled with CFR 0.152.
 */
package zju.cst.aces.prompt;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zju.cst.aces.api.Task;
import zju.cst.aces.api.config.Config;
import zju.cst.aces.dto.ClassInfo;
import zju.cst.aces.dto.ExampleUsage;
import zju.cst.aces.dto.MethodInfo;
import zju.cst.aces.dto.PromptInfo;
import zju.cst.aces.parser.ProjectParser;
import zju.cst.aces.runner.AbstractRunner;

public class PromptTemplate {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final String CONFIG_FILE = "config.properties";
    public String TEMPLATE_INIT = "";
    public String TEMPLATE_EXTRA = "";
    public String TEMPLATE_REPAIR = "";
    public Map<String, Object> dataModel = new HashMap<String, Object>();
    public Properties properties;
    public Path promptPath;
    public int maxPromptTokens;
    public Config config;

    public PromptTemplate(Config config, Properties properties, Path promptPath, int maxPromptTokens) {
        this.config = config;
        this.properties = properties;
        this.promptPath = promptPath;
        this.maxPromptTokens = maxPromptTokens;
        this.TEMPLATE_INIT = properties.getProperty("PROMPT_TEMPLATE_INIT");
        this.TEMPLATE_EXTRA = properties.getProperty("PROMPT_TEMPLATE_EXTRA");
        this.TEMPLATE_REPAIR = properties.getProperty("PROMPT_TEMPLATE_REPAIR");
    }

    public String renderTemplate(String templateFileName) throws IOException, TemplateException {
        String generatedText;
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_30);
        if (this.promptPath == null) {
            configuration.setClassForTemplateLoading(PromptTemplate.class, "/prompt");
        } else {
            configuration.setDirectoryForTemplateLoading(this.promptPath.toFile());
        }
        configuration.setDefaultEncoding("utf-8");
        Template template = configuration.getTemplate(templateFileName);
        Pattern pattern = Pattern.compile("\\$\\{([a-zA-Z_][\\w]*)\\}");
        Matcher matcher = pattern.matcher(template.toString());
        ArrayList<String> matches = new ArrayList<String>();
        while (matcher.find()) {
            String e = matcher.group(1);
            if (matches.contains(e)) continue;
            matches.add(e);
        }
        do {
            StringWriter writer = new StringWriter();
            template.process(this.dataModel, (Writer)writer);
            generatedText = writer.toString();
            if (matches.size() <= 0) continue;
            String key = (String)matches.get(matches.size() - 1);
            if (this.dataModel.containsKey(key)) {
                if (this.dataModel.get(key) instanceof String) {
                    this.dataModel.put(key, "");
                } else if (this.dataModel.get(key) instanceof List) {
                    this.dataModel.put(key, new ArrayList());
                } else {
                    if (!(this.dataModel.get(key) instanceof Map)) break;
                    this.dataModel.put(key, new HashMap());
                }
            }
            matches.remove(matches.size() - 1);
        } while (AbstractRunner.isExceedMaxTokens(this.maxPromptTokens, generatedText) && matches.size() > 0);
        return generatedText;
    }

    public void buildDataModel(Config config, PromptInfo promptInfo) throws IOException {
        ExampleUsage exampleUsage = new ExampleUsage(config.getExamplePath(), promptInfo.className);
        HashMap<String, String> cdep_temp = new HashMap<String, String>();
        HashMap<String, String> mdep_temp = new HashMap<String, String>();
        this.dataModel.put("dep_packages", this.getDepPackages(promptInfo.getClassInfo(), promptInfo.getMethodInfo()));
        this.dataModel.put("dep_imports", this.getDepImports(promptInfo.getClassInfo(), promptInfo.getMethodInfo()));
        this.dataModel.put("dep_class_sigs", this.getDepClassSigs(promptInfo.getClassInfo(), promptInfo.getMethodInfo()));
        this.dataModel.put("dep_class_bodies", this.getDepClassBodies(promptInfo.getClassInfo(), promptInfo.getMethodInfo()));
        this.dataModel.put("dep_m_sigs", this.getDepBrief(promptInfo.getMethodInfo()));
        this.dataModel.put("dep_m_bodies", this.getDepBodies(promptInfo.getMethodInfo()));
        this.dataModel.put("dep_c_sigs", this.getDepConstructorSigs(promptInfo.getClassInfo(), promptInfo.getMethodInfo()));
        this.dataModel.put("dep_c_bodies", this.getDepConstructorBodies(promptInfo.getClassInfo(), promptInfo.getMethodInfo()));
        this.dataModel.put("dep_fields", this.getDepFields(promptInfo.getClassInfo(), promptInfo.getMethodInfo()));
        this.dataModel.put("dep_gs_sigs", this.getDepGSSigs(promptInfo.getClassInfo(), promptInfo.getMethodInfo()));
        this.dataModel.put("dep_gs_bodies", this.getDepGSBodies(promptInfo.getClassInfo(), promptInfo.getMethodInfo()));
        this.dataModel.put("dep_m_sigs_ano_com", this.getDepBriefWithAnoAndCom(promptInfo.getClassInfo(), promptInfo.getMethodInfo()));
        if (this.isTokenExceed(promptInfo.getMethodInfo().full_method_info, this.getDepClassSigs(promptInfo.getClassInfo(), promptInfo.getMethodInfo()), this.getDepBriefWithAnoAndCom(promptInfo.getClassInfo(), promptInfo.getMethodInfo()))) {
            this.dataModel.put("dep_m_sigs_ano_com", this.getDepBriefWithAno(promptInfo.getClassInfo(), promptInfo.getMethodInfo()));
        }
        this.dataModel.put("example_usage", exampleUsage.getShortestUsage(promptInfo.getMethodInfo().methodSignature));
        this.dataModel.put("project_full_code", this.getFullProjectCode(promptInfo.getClassName(), config));
        this.dataModel.put("method_name", promptInfo.getMethodName());
        this.dataModel.put("full_class_name", promptInfo.getFullClassName());
        this.dataModel.put("method_sig", promptInfo.getMethodSignature());
        this.dataModel.put("method_body", promptInfo.getMethodInfo().sourceCode);
        this.dataModel.put("class_name", promptInfo.getClassName());
        this.dataModel.put("class_sig", promptInfo.getClassInfo().classSignature);
        this.dataModel.put("package", promptInfo.getClassInfo().packageDeclaration);
        this.dataModel.put("class_body", promptInfo.getClassInfo().classDeclarationCode);
        this.dataModel.put("file_content", promptInfo.getClassInfo().compilationUnitCode);
        this.dataModel.put("imports", AbstractRunner.joinLines(promptInfo.getClassInfo().imports));
        this.dataModel.put("fields", AbstractRunner.joinLines(promptInfo.getClassInfo().fields));
        this.dataModel.put("full_method_info", promptInfo.getMethodInfo().full_method_info);
        this.dataModel.put("subClasses", promptInfo.getClassInfo().subClasses);
        if (!promptInfo.getClassInfo().constructorSigs.isEmpty()) {
            this.dataModel.put("constructor_sigs", AbstractRunner.joinLines(promptInfo.getClassInfo().constructorBrief));
            this.dataModel.put("constructor_bodies", AbstractRunner.getBodies(config, promptInfo.getClassInfo(), promptInfo.getClassInfo().constructorSigs));
        } else {
            this.dataModel.put("constructor_sigs", null);
            this.dataModel.put("constructor_bodies", null);
        }
        if (!promptInfo.getClassInfo().getterSetterSigs.isEmpty()) {
            this.dataModel.put("getter_setter_sigs", AbstractRunner.joinLines(promptInfo.getClassInfo().getterSetterBrief));
            this.dataModel.put("getter_setter_bodies", AbstractRunner.getBodies(config, promptInfo.getClassInfo(), promptInfo.getClassInfo().getterSetterSigs));
        } else {
            this.dataModel.put("getter_setter_sigs", null);
            this.dataModel.put("getter_setter_bodies", null);
        }
        if (!promptInfo.getOtherMethodBrief().trim().isEmpty()) {
            this.dataModel.put("other_method_sigs", promptInfo.getOtherMethodBrief());
            this.dataModel.put("other_method_bodies", promptInfo.getOtherMethodBodies());
        } else {
            this.dataModel.put("other_method_sigs", null);
            this.dataModel.put("other_method_bodies", null);
        }
        for (Map.Entry<String, String> entry : promptInfo.getConstructorDeps().entrySet()) {
            cdep_temp.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : promptInfo.getMethodDeps().entrySet()) {
            mdep_temp.put(entry.getKey(), entry.getValue());
        }
        this.dataModel.put("c_deps", cdep_temp);
        this.dataModel.put("m_deps", mdep_temp);
        this.dataModel.put("full_fm", promptInfo.getContext());
    }

    public Map<String, String> getDepBrief(MethodInfo methodInfo) throws IOException {
        HashMap<String, String> depBrief = new HashMap<String, String>();
        for (Map.Entry<String, Set<String>> entry : methodInfo.dependentMethods.entrySet()) {
            String depClassName = entry.getKey();
            String fullDepClassName = Task.getFullClassName(this.config, depClassName);
            Path depClassInfoPath = this.config.getParseOutput().resolve(fullDepClassName.replace(".", File.separator)).resolve("class.json");
            if (!depClassInfoPath.toFile().exists()) {
                return depBrief;
            }
            ClassInfo depClassInfo = (ClassInfo)GSON.fromJson(Files.readString(depClassInfoPath, StandardCharsets.UTF_8), ClassInfo.class);
            if (depClassInfo == null) continue;
            Object info = "";
            for (String depMethodSig : entry.getValue()) {
                MethodInfo depMethodInfo = AbstractRunner.getMethodInfo(this.config, depClassInfo, depMethodSig);
                if (depMethodInfo == null) continue;
                info = (String)info + depMethodInfo.brief + "\n";
            }
            depBrief.put(depClassName, ((String)info).trim());
        }
        return depBrief;
    }

    public Map<String, String> getDepBriefWithAnoAndCom(ClassInfo classInfo, MethodInfo methodInfo) throws IOException {
        HashMap<String, String> depBrief = new HashMap<String, String>();
        for (Map.Entry<String, ClassInfo> entry : this.getDepClassInfos(classInfo, methodInfo).entrySet()) {
            String depClassName = entry.getKey();
            ClassInfo depClassInfo = entry.getValue();
            if (depClassInfo == null) continue;
            Map<String, String> methodSigs = depClassInfo.getMethodSigs();
            Set<String> msigs = methodSigs.keySet();
            Object info = "";
            for (String msig : msigs) {
                MethodInfo mInfo = AbstractRunner.getMethodInfo(this.config, depClassInfo, msig);
                if (mInfo == null) continue;
                info = (String)info + "-" + mInfo.method_comment + mInfo.brief.replace("{}", "").replace("\r", "") + "\n";
            }
            depBrief.put(depClassName, ((String)info).trim());
        }
        return depBrief;
    }

    public boolean isTokenExceed(String full_method_info, Map<String, String> dep_class_sigs, Map<String, String> dep_m_sigs_ano_com) {
        Object prompt = full_method_info;
        for (String dep_class_sig : dep_class_sigs.keySet()) {
            prompt = (String)prompt + dep_class_sig;
            prompt = (String)prompt + dep_m_sigs_ano_com.get(dep_class_sig);
        }
        return AbstractRunner.isExceedMaxTokens(this.config.maxPromptTokens, (String)prompt);
    }

    public Map<String, String> getDepBriefWithAno(ClassInfo classInfo, MethodInfo methodInfo) throws IOException {
        HashMap<String, String> depBrief = new HashMap<String, String>();
        for (Map.Entry<String, ClassInfo> entry : this.getDepClassInfos(classInfo, methodInfo).entrySet()) {
            String depClassName = entry.getKey();
            ClassInfo depClassInfo = entry.getValue();
            if (depClassInfo == null) continue;
            Map<String, String> methodSigs = depClassInfo.getMethodSigs();
            Set<String> msigs = methodSigs.keySet();
            Object info = "";
            for (String msig : msigs) {
                MethodInfo mInfo = AbstractRunner.getMethodInfo(this.config, depClassInfo, msig);
                if (mInfo == null) continue;
                info = (String)info + "-" + mInfo.brief.replace("{}", "") + "\n";
            }
            depBrief.put(depClassName, ((String)info).trim());
        }
        return depBrief;
    }

    public Map<String, String> getDepBodies(MethodInfo methodInfo) throws IOException {
        HashMap<String, String> depBodies = new HashMap<String, String>();
        for (Map.Entry<String, Set<String>> entry : methodInfo.dependentMethods.entrySet()) {
            String depClassName = entry.getKey();
            String fullDepClassName = Task.getFullClassName(this.config, depClassName);
            Path depClassInfoPath = this.config.getParseOutput().resolve(fullDepClassName.replace(".", File.separator)).resolve("class.json");
            if (!depClassInfoPath.toFile().exists()) {
                return depBodies;
            }
            ClassInfo depClassInfo = (ClassInfo)GSON.fromJson(Files.readString(depClassInfoPath, StandardCharsets.UTF_8), ClassInfo.class);
            if (depClassInfo == null) continue;
            Object info = "";
            for (String depMethodSig : entry.getValue()) {
                MethodInfo depMethodInfo = AbstractRunner.getMethodInfo(this.config, depClassInfo, depMethodSig);
                if (depMethodInfo == null) continue;
                info = (String)info + depMethodInfo.sourceCode + "\n";
            }
            depBodies.put(depClassName, ((String)info).trim());
        }
        return depBodies;
    }

    public Map<String, String> getDepFields(ClassInfo classInfo, MethodInfo methodInfo) throws IOException {
        ClassInfo depClassInfo;
        Path depClassInfoPath;
        String fullDepClassName;
        String depClassName;
        HashMap<String, String> depFields = new HashMap<String, String>();
        for (Map.Entry<String, Set<String>> entry : classInfo.constructorDeps.entrySet()) {
            depClassName = entry.getKey();
            fullDepClassName = Task.getFullClassName(this.config, depClassName);
            depClassInfoPath = this.config.getParseOutput().resolve(fullDepClassName.replace(".", File.separator)).resolve("class.json");
            if (!depClassInfoPath.toFile().exists()) {
                return depFields;
            }
            depClassInfo = (ClassInfo)GSON.fromJson(Files.readString(depClassInfoPath, StandardCharsets.UTF_8), ClassInfo.class);
            if (depClassInfo == null) continue;
            depFields.put(depClassName, AbstractRunner.joinLines(depClassInfo.fields));
        }
        for (Map.Entry<String, Set<String>> entry : methodInfo.dependentMethods.entrySet()) {
            depClassName = entry.getKey();
            if (depFields.containsKey(depClassName)) continue;
            fullDepClassName = Task.getFullClassName(this.config, depClassName);
            depClassInfoPath = this.config.getParseOutput().resolve(fullDepClassName.replace(".", File.separator)).resolve("class.json");
            if (!depClassInfoPath.toFile().exists()) {
                return depFields;
            }
            depClassInfo = (ClassInfo)GSON.fromJson(Files.readString(depClassInfoPath, StandardCharsets.UTF_8), ClassInfo.class);
            if (depClassInfo == null) continue;
            depFields.put(depClassName, AbstractRunner.joinLines(depClassInfo.fields));
        }
        return depFields;
    }

    public Map<String, String> getDepConstructorSigs(ClassInfo classInfo, MethodInfo methodInfo) throws IOException {
        ClassInfo depClassInfo;
        Path depClassInfoPath;
        String fullDepClassName;
        String depClassName;
        HashMap<String, String> depConstructorSigs = new HashMap<String, String>();
        for (Map.Entry<String, Set<String>> entry : classInfo.constructorDeps.entrySet()) {
            depClassName = entry.getKey();
            fullDepClassName = Task.getFullClassName(this.config, depClassName);
            depClassInfoPath = this.config.getParseOutput().resolve(fullDepClassName.replace(".", File.separator)).resolve("class.json");
            if (!depClassInfoPath.toFile().exists()) {
                return depConstructorSigs;
            }
            depClassInfo = (ClassInfo)GSON.fromJson(Files.readString(depClassInfoPath, StandardCharsets.UTF_8), ClassInfo.class);
            if (depClassInfo == null) continue;
            depConstructorSigs.put(depClassName, AbstractRunner.joinLines(depClassInfo.constructorBrief));
        }
        for (Map.Entry<String, Set<String>> entry : methodInfo.dependentMethods.entrySet()) {
            depClassName = entry.getKey();
            if (depConstructorSigs.containsKey(depClassName)) continue;
            fullDepClassName = Task.getFullClassName(this.config, depClassName);
            depClassInfoPath = this.config.getParseOutput().resolve(fullDepClassName.replace(".", File.separator)).resolve("class.json");
            if (!depClassInfoPath.toFile().exists()) {
                return depConstructorSigs;
            }
            depClassInfo = (ClassInfo)GSON.fromJson(Files.readString(depClassInfoPath, StandardCharsets.UTF_8), ClassInfo.class);
            if (depClassInfo == null) continue;
            depConstructorSigs.put(depClassName, AbstractRunner.joinLines(depClassInfo.constructorBrief));
        }
        return depConstructorSigs;
    }

    public Map<String, String> getDepConstructorBodies(ClassInfo classInfo, MethodInfo methodInfo) throws IOException {
        MethodInfo depConstructorInfo;
        Object info;
        ClassInfo depClassInfo;
        Path depClassInfoPath;
        String fullDepClassName;
        String depClassName;
        HashMap<String, String> depConstructorBodies = new HashMap<String, String>();
        for (Map.Entry<String, Set<String>> entry : classInfo.constructorDeps.entrySet()) {
            depClassName = entry.getKey();
            fullDepClassName = Task.getFullClassName(this.config, depClassName);
            depClassInfoPath = this.config.getParseOutput().resolve(fullDepClassName.replace(".", File.separator)).resolve("class.json");
            if (!depClassInfoPath.toFile().exists()) {
                return depConstructorBodies;
            }
            depClassInfo = (ClassInfo)GSON.fromJson(Files.readString(depClassInfoPath, StandardCharsets.UTF_8), ClassInfo.class);
            if (depClassInfo == null) continue;
            info = "";
            for (String sig : depClassInfo.constructorSigs) {
                depConstructorInfo = AbstractRunner.getMethodInfo(this.config, depClassInfo, sig);
                if (depConstructorInfo == null) continue;
                info = (String)info + depConstructorInfo.sourceCode + "\n";
            }
            depConstructorBodies.put(depClassName, ((String)info).trim());
        }
        for (Map.Entry<String, Set<String>> entry : methodInfo.dependentMethods.entrySet()) {
            depClassName = entry.getKey();
            if (depConstructorBodies.containsKey(depClassName)) continue;
            fullDepClassName = Task.getFullClassName(this.config, depClassName);
            depClassInfoPath = this.config.getParseOutput().resolve(fullDepClassName.replace(".", File.separator)).resolve("class.json");
            if (!depClassInfoPath.toFile().exists()) {
                return depConstructorBodies;
            }
            depClassInfo = (ClassInfo)GSON.fromJson(Files.readString(depClassInfoPath, StandardCharsets.UTF_8), ClassInfo.class);
            if (depClassInfo == null) continue;
            info = "";
            for (String sig : depClassInfo.constructorSigs) {
                depConstructorInfo = AbstractRunner.getMethodInfo(this.config, depClassInfo, sig);
                if (depConstructorInfo == null) continue;
                info = (String)info + depConstructorInfo.sourceCode + "\n";
            }
            depConstructorBodies.put(depClassName, ((String)info).trim());
        }
        return depConstructorBodies;
    }

    public Map<String, String> getDepClassSigs(ClassInfo classInfo, MethodInfo methodInfo) throws IOException {
        ClassInfo depClassInfo;
        Path depClassInfoPath;
        String fullDepClassName;
        String depClassName;
        HashMap<String, String> depClassSigs = new HashMap<String, String>();
        for (Map.Entry<String, Set<String>> entry : classInfo.constructorDeps.entrySet()) {
            depClassName = entry.getKey();
            fullDepClassName = Task.getFullClassName(this.config, depClassName);
            depClassInfoPath = this.config.getParseOutput().resolve(fullDepClassName.replace(".", File.separator)).resolve("class.json");
            if (!depClassInfoPath.toFile().exists() || (depClassInfo = (ClassInfo)GSON.fromJson(Files.readString(depClassInfoPath, StandardCharsets.UTF_8), ClassInfo.class)) == null) continue;
            depClassSigs.put(depClassName, depClassInfo.classSignature);
        }
        for (Map.Entry<String, Set<String>> entry : methodInfo.dependentMethods.entrySet()) {
            depClassName = entry.getKey();
            if (depClassSigs.containsKey(depClassName)) continue;
            fullDepClassName = Task.getFullClassName(this.config, depClassName);
            depClassInfoPath = this.config.getParseOutput().resolve(fullDepClassName.replace(".", File.separator)).resolve("class.json");
            if (!depClassInfoPath.toFile().exists() || (depClassInfo = (ClassInfo)GSON.fromJson(Files.readString(depClassInfoPath, StandardCharsets.UTF_8), ClassInfo.class)) == null) continue;
            depClassSigs.put(depClassName, depClassInfo.classSignature);
        }
        return depClassSigs;
    }

    public Map<String, ClassInfo> getDepClassInfos(ClassInfo classInfo, MethodInfo methodInfo) throws IOException {
        ClassInfo depClassInfo;
        Path depClassInfoPath;
        String fullDepClassName;
        String depClassName;
        HashMap<String, ClassInfo> depClassSigs = new HashMap<String, ClassInfo>();
        for (Map.Entry<String, Set<String>> entry : classInfo.constructorDeps.entrySet()) {
            depClassName = entry.getKey();
            fullDepClassName = Task.getFullClassName(this.config, depClassName);
            depClassInfoPath = this.config.getParseOutput().resolve(fullDepClassName.replace(".", File.separator)).resolve("class.json");
            if (!depClassInfoPath.toFile().exists()) {
                return depClassSigs;
            }
            depClassInfo = (ClassInfo)GSON.fromJson(Files.readString(depClassInfoPath, StandardCharsets.UTF_8), ClassInfo.class);
            if (depClassInfo == null) continue;
            depClassSigs.put(depClassName, depClassInfo);
        }
        for (Map.Entry<String, Set<String>> entry : methodInfo.dependentMethods.entrySet()) {
            depClassName = entry.getKey();
            if (depClassSigs.containsKey(depClassName)) continue;
            fullDepClassName = Task.getFullClassName(this.config, depClassName);
            depClassInfoPath = this.config.getParseOutput().resolve(fullDepClassName.replace(".", File.separator)).resolve("class.json");
            if (!depClassInfoPath.toFile().exists() || (depClassInfo = (ClassInfo)GSON.fromJson(Files.readString(depClassInfoPath, StandardCharsets.UTF_8), ClassInfo.class)) == null) continue;
            depClassSigs.put(depClassName, depClassInfo);
        }
        return depClassSigs;
    }

    public Map<String, String> getDepClassBodies(ClassInfo classInfo, MethodInfo methodInfo) throws IOException {
        ClassInfo depClassInfo;
        Path depClassInfoPath;
        String fullDepClassName;
        String depClassName;
        HashMap<String, String> depClassBodies = new HashMap<String, String>();
        for (Map.Entry<String, Set<String>> entry : classInfo.constructorDeps.entrySet()) {
            depClassName = entry.getKey();
            fullDepClassName = Task.getFullClassName(this.config, depClassName);
            depClassInfoPath = this.config.getParseOutput().resolve(fullDepClassName.replace(".", File.separator)).resolve("class.json");
            if (!depClassInfoPath.toFile().exists()) {
                return depClassBodies;
            }
            depClassInfo = (ClassInfo)GSON.fromJson(Files.readString(depClassInfoPath, StandardCharsets.UTF_8), ClassInfo.class);
            if (depClassInfo == null) continue;
            depClassBodies.put(depClassName, depClassInfo.classDeclarationCode);
        }
        for (Map.Entry<String, Set<String>> entry : methodInfo.dependentMethods.entrySet()) {
            depClassName = entry.getKey();
            if (depClassBodies.containsKey(depClassName)) continue;
            fullDepClassName = Task.getFullClassName(this.config, depClassName);
            depClassInfoPath = this.config.getParseOutput().resolve(fullDepClassName.replace(".", File.separator)).resolve("class.json");
            if (!depClassInfoPath.toFile().exists()) {
                return depClassBodies;
            }
            depClassInfo = (ClassInfo)GSON.fromJson(Files.readString(depClassInfoPath, StandardCharsets.UTF_8), ClassInfo.class);
            if (depClassInfo == null) continue;
            depClassBodies.put(depClassName, depClassInfo.classDeclarationCode);
        }
        return depClassBodies;
    }

    public Map<String, String> getDepPackages(ClassInfo classInfo, MethodInfo methodInfo) throws IOException {
        ClassInfo depClassInfo;
        Path depClassInfoPath;
        String fullDepClassName;
        String depClassName;
        HashMap<String, String> depPackages = new HashMap<String, String>();
        for (Map.Entry<String, Set<String>> entry : classInfo.constructorDeps.entrySet()) {
            depClassName = entry.getKey();
            fullDepClassName = Task.getFullClassName(this.config, depClassName);
            depClassInfoPath = this.config.getParseOutput().resolve(fullDepClassName.replace(".", File.separator)).resolve("class.json");
            if (!depClassInfoPath.toFile().exists()) {
                return depPackages;
            }
            depClassInfo = (ClassInfo)GSON.fromJson(Files.readString(depClassInfoPath, StandardCharsets.UTF_8), ClassInfo.class);
            if (depClassInfo == null) continue;
            depPackages.put(depClassName, depClassInfo.packageDeclaration);
        }
        for (Map.Entry<String, Set<String>> entry : methodInfo.dependentMethods.entrySet()) {
            depClassName = entry.getKey();
            if (depPackages.containsKey(depClassName)) continue;
            fullDepClassName = Task.getFullClassName(this.config, depClassName);
            depClassInfoPath = this.config.getParseOutput().resolve(fullDepClassName.replace(".", File.separator)).resolve("class.json");
            if (!depClassInfoPath.toFile().exists()) {
                return depPackages;
            }
            depClassInfo = (ClassInfo)GSON.fromJson(Files.readString(depClassInfoPath, StandardCharsets.UTF_8), ClassInfo.class);
            if (depClassInfo == null) continue;
            depPackages.put(depClassName, depClassInfo.packageDeclaration);
        }
        return depPackages;
    }

    public Map<String, String> getDepImports(ClassInfo classInfo, MethodInfo methodInfo) throws IOException {
        ClassInfo depClassInfo;
        Path depClassInfoPath;
        String fullDepClassName;
        String depClassName;
        HashMap<String, String> depImports = new HashMap<String, String>();
        for (Map.Entry<String, Set<String>> entry : classInfo.constructorDeps.entrySet()) {
            depClassName = entry.getKey();
            fullDepClassName = Task.getFullClassName(this.config, depClassName);
            depClassInfoPath = this.config.getParseOutput().resolve(fullDepClassName.replace(".", File.separator)).resolve("class.json");
            if (!depClassInfoPath.toFile().exists()) {
                return depImports;
            }
            depClassInfo = (ClassInfo)GSON.fromJson(Files.readString(depClassInfoPath, StandardCharsets.UTF_8), ClassInfo.class);
            if (depClassInfo == null) continue;
            depImports.put(depClassName, AbstractRunner.joinLines(depClassInfo.imports));
        }
        for (Map.Entry<String, Set<String>> entry : methodInfo.dependentMethods.entrySet()) {
            depClassName = entry.getKey();
            if (depImports.containsKey(depClassName)) continue;
            fullDepClassName = Task.getFullClassName(this.config, depClassName);
            depClassInfoPath = this.config.getParseOutput().resolve(fullDepClassName.replace(".", File.separator)).resolve("class.json");
            if (!depClassInfoPath.toFile().exists()) {
                return depImports;
            }
            depClassInfo = (ClassInfo)GSON.fromJson(Files.readString(depClassInfoPath, StandardCharsets.UTF_8), ClassInfo.class);
            if (depClassInfo == null) continue;
            depImports.put(depClassName, AbstractRunner.joinLines(depClassInfo.imports));
        }
        return depImports;
    }

    public Map<String, String> getDepGSSigs(ClassInfo classInfo, MethodInfo methodInfo) throws IOException {
        ClassInfo depClassInfo;
        Path depClassInfoPath;
        String fullDepClassName;
        String depClassName;
        HashMap<String, String> depGSSigs = new HashMap<String, String>();
        for (Map.Entry<String, Set<String>> entry : classInfo.constructorDeps.entrySet()) {
            depClassName = entry.getKey();
            fullDepClassName = Task.getFullClassName(this.config, depClassName);
            depClassInfoPath = this.config.getParseOutput().resolve(fullDepClassName.replace(".", File.separator)).resolve("class.json");
            if (!depClassInfoPath.toFile().exists()) {
                return depGSSigs;
            }
            depClassInfo = (ClassInfo)GSON.fromJson(Files.readString(depClassInfoPath, StandardCharsets.UTF_8), ClassInfo.class);
            if (depClassInfo == null) continue;
            depGSSigs.put(depClassName, AbstractRunner.joinLines(depClassInfo.getterSetterSigs));
        }
        for (Map.Entry<String, Set<String>> entry : methodInfo.dependentMethods.entrySet()) {
            depClassName = entry.getKey();
            if (depGSSigs.containsKey(depClassName)) continue;
            fullDepClassName = Task.getFullClassName(this.config, depClassName);
            depClassInfoPath = this.config.getParseOutput().resolve(fullDepClassName.replace(".", File.separator)).resolve("class.json");
            if (!depClassInfoPath.toFile().exists()) {
                return depGSSigs;
            }
            depClassInfo = (ClassInfo)GSON.fromJson(Files.readString(depClassInfoPath, StandardCharsets.UTF_8), ClassInfo.class);
            if (depClassInfo == null) continue;
            depGSSigs.put(depClassName, AbstractRunner.joinLines(depClassInfo.getterSetterSigs));
        }
        return depGSSigs;
    }

    public Map<String, String> getDepGSBodies(ClassInfo classInfo, MethodInfo methodInfo) throws IOException {
        MethodInfo depConstructorInfo;
        Object info;
        ClassInfo depClassInfo;
        Path depClassInfoPath;
        String fullDepClassName;
        String depClassName;
        HashMap<String, String> depGSBodies = new HashMap<String, String>();
        for (Map.Entry<String, Set<String>> entry : classInfo.constructorDeps.entrySet()) {
            depClassName = entry.getKey();
            fullDepClassName = Task.getFullClassName(this.config, depClassName);
            depClassInfoPath = this.config.getParseOutput().resolve(fullDepClassName.replace(".", File.separator)).resolve("class.json");
            if (!depClassInfoPath.toFile().exists()) {
                return depGSBodies;
            }
            depClassInfo = (ClassInfo)GSON.fromJson(Files.readString(depClassInfoPath, StandardCharsets.UTF_8), ClassInfo.class);
            if (depClassInfo == null) continue;
            info = "";
            for (String sig : depClassInfo.getterSetterSigs) {
                depConstructorInfo = AbstractRunner.getMethodInfo(this.config, depClassInfo, sig);
                if (depConstructorInfo == null) continue;
                info = (String)info + depConstructorInfo.sourceCode + "\n";
            }
            depGSBodies.put(depClassName, ((String)info).trim());
        }
        for (Map.Entry<String, Set<String>> entry : methodInfo.dependentMethods.entrySet()) {
            depClassName = entry.getKey();
            if (depGSBodies.containsKey(depClassName)) continue;
            fullDepClassName = Task.getFullClassName(this.config, depClassName);
            depClassInfoPath = this.config.getParseOutput().resolve(fullDepClassName.replace(".", File.separator)).resolve("class.json");
            if (!depClassInfoPath.toFile().exists()) {
                return depGSBodies;
            }
            depClassInfo = (ClassInfo)GSON.fromJson(Files.readString(depClassInfoPath, StandardCharsets.UTF_8), ClassInfo.class);
            if (depClassInfo == null) continue;
            info = "";
            for (String sig : depClassInfo.getterSetterSigs) {
                depConstructorInfo = AbstractRunner.getMethodInfo(this.config, depClassInfo, sig);
                if (depConstructorInfo == null) continue;
                info = (String)info + depConstructorInfo.sourceCode + "\n";
            }
            depGSBodies.put(depClassName, ((String)info).trim());
        }
        return depGSBodies;
    }

    public String getFullProjectCode(String className, Config config) {
        Object fullProjectCode = "";
        List<String> classPaths = ProjectParser.scanSourceDirectory(config.project);
        for (String path : classPaths) {
            String cn = path.substring(path.lastIndexOf(File.separator) + 1, path.lastIndexOf("."));
            if (cn.equals(className)) continue;
            try {
                fullProjectCode = (String)fullProjectCode + Files.readString(Paths.get(path, new String[0]), StandardCharsets.UTF_8) + "\n";
            }
            catch (IOException e) {
                config.getLog().warn("Failed to append class code for " + className);
            }
        }
        return fullProjectCode;
    }
}

