/*
 * Decompiled with CFR 0.152.
 */
package zju.cst.aces.prompt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import zju.cst.aces.api.config.Config;
import zju.cst.aces.dto.Message;
import zju.cst.aces.dto.PromptInfo;
import zju.cst.aces.dto.TestMessage;
import zju.cst.aces.prompt.COT;
import zju.cst.aces.prompt.PromptTemplate;
import zju.cst.aces.prompt.TOT;
import zju.cst.aces.util.TokenCounter;

public class PromptGenerator {
    public Config config;
    public PromptTemplate promptTemplate;

    public PromptGenerator(Config config) throws IOException {
        this.config = config;
        this.promptTemplate = new PromptTemplate(config, config.properties, config.getPromptPath(), config.getMaxPromptTokens());
    }

    public void setConfig(Config config) {
        this.config = config;
        this.promptTemplate = new PromptTemplate(config, config.properties, config.getPromptPath(), config.getMaxPromptTokens());
    }

    public List<Message> generateMessages(PromptInfo promptInfo) {
        ArrayList<Message> messages = new ArrayList<Message>();
        if (promptInfo.errorMsg == null) {
            messages.add(Message.ofSystem(this.createSystemPrompt(promptInfo, this.promptTemplate.TEMPLATE_INIT)));
            messages.add(Message.of(this.createUserPrompt(promptInfo, this.promptTemplate.TEMPLATE_INIT)));
        } else {
            messages.add(Message.of(this.createUserPrompt(promptInfo, this.promptTemplate.TEMPLATE_REPAIR)));
        }
        return messages;
    }

    public List<Message> generateMessages(PromptInfo promptInfo, String templateName) {
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.add(Message.ofSystem(this.createSystemPrompt(promptInfo, templateName)));
        messages.add(Message.of(this.createUserPrompt(promptInfo, templateName)));
        return messages;
    }

    public String createUserPrompt(PromptInfo promptInfo, String templateName) {
        try {
            this.promptTemplate.buildDataModel(this.config, promptInfo);
            if (templateName.equals(this.promptTemplate.TEMPLATE_REPAIR)) {
                int promptTokens = TokenCounter.countToken(promptInfo.getUnitTest()) + TokenCounter.countToken(promptInfo.getMethodSignature()) + TokenCounter.countToken(promptInfo.getClassName()) + TokenCounter.countToken(promptInfo.getContext()) + TokenCounter.countToken(promptInfo.getOtherMethodBrief());
                int allowedTokens = Math.max(this.config.getMaxPromptTokens() - promptTokens, this.config.getMinErrorTokens());
                TestMessage errorMsg = promptInfo.getErrorMsg();
                Object processedErrorMsg = "";
                for (String error : errorMsg.getErrorMessage()) {
                    if (TokenCounter.countToken((String)processedErrorMsg + error + "\n") > allowedTokens) continue;
                    processedErrorMsg = (String)processedErrorMsg + error + "\n";
                }
                this.config.getLog().debug("Allowed tokens: " + allowedTokens);
                this.config.getLog().debug("Processed error message: \n" + (String)processedErrorMsg);
                this.promptTemplate.dataModel.put("unit_test", promptInfo.getUnitTest());
                this.promptTemplate.dataModel.put("error_message", processedErrorMsg);
                return this.promptTemplate.renderTemplate(this.promptTemplate.TEMPLATE_REPAIR);
            }
            return this.promptTemplate.renderTemplate(templateName);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while generating the user prompt: " + e);
        }
    }

    public String createSystemPrompt(PromptInfo promptInfo, String templateName) {
        try {
            String filename = this.addSystemFileName(templateName);
            return this.promptTemplate.renderTemplate(filename);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                return "";
            }
            throw new RuntimeException("An error occurred while generating the system prompt: " + e);
        }
    }

    public String addSystemFileName(String filename) {
        String[] parts = filename.split("\\.");
        if (parts.length > 1) {
            return parts[0] + "_system." + parts[1];
        }
        return filename;
    }

    public String buildCOT(COT<?> cot) {
        return "";
    }

    public String buildTOT(TOT<?> tot) {
        return "";
    }
}

