/*
 * Decompiled with CFR 0.152.
 */
package zju.cst.aces.parser;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.resolution.SymbolResolver;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.JavaSymbolSolver;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.resolution.typesolvers.CombinedTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JarTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JavaParserTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import zju.cst.aces.api.Project;
import zju.cst.aces.api.config.Config;
import zju.cst.aces.parser.ClassParser;

public class ProjectParser {
    public static final JavaParser parser = new JavaParser();
    public Path srcFolderPath;
    public Path outputPath;
    public Map<String, Set<String>> classMap = new HashMap<String, Set<String>>();
    public static Config config;
    public int classCount = 0;
    public int methodCount = 0;

    public ProjectParser(Config config) {
        this.srcFolderPath = Paths.get(config.getProject().getBasedir().getAbsolutePath(), "src", "main", "java");
        ProjectParser.config = config;
        this.outputPath = config.getParseOutput();
        JavaSymbolSolver symbolSolver = this.getSymbolSolver();
        parser.getParserConfiguration().setSymbolResolver((SymbolResolver)symbolSolver);
        this.setLanguageLevel(parser.getParserConfiguration());
        if (config.parser == null) {
            config.setParser(parser);
        }
    }

    public void parse() {
        List<String> classPaths = ProjectParser.scanSourceDirectory(config.getProject());
        if (classPaths.isEmpty()) {
            config.getLog().warn("No java file found in " + this.srcFolderPath);
            return;
        }
        for (String classPath : classPaths) {
            try {
                String packagePath = classPath.substring(this.srcFolderPath.toString().length() + 1);
                Path output = this.outputPath.resolve(packagePath).getParent();
                ClassParser classParser = new ClassParser(config, output);
                int classNum = classParser.extractClass(classPath);
                if (classNum == 0) continue;
                this.addClassMap(this.outputPath, packagePath);
                this.classCount += classNum;
                this.methodCount += classParser.methodCount;
            }
            catch (Exception e) {
                throw new RuntimeException("In ProjectParser.parse: " + e);
            }
        }
        this.exportClassMapping();
        ProjectParser.exportJson(config.getClassNameMapPath(), this.classMap);
        config.getLog().info("\nParsed classes: " + this.classCount + "\nParsed methods: " + this.methodCount);
    }

    public void addClassMap(Path outputPath, String packagePath) {
        if (Paths.get(packagePath, new String[0]).getParent() == null) {
            return;
        }
        Path path = outputPath.resolve(packagePath).getParent();
        String packageDeclaration = path.toString().substring(outputPath.toString().length() + 1).replace(File.separator, ".");
        File[] files = path.toFile().listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (!file.isDirectory()) continue;
            String className = file.getName();
            String fullClassName = packageDeclaration + "." + className;
            if (this.classMap.containsKey(className)) {
                this.classMap.get(className).add(fullClassName);
                continue;
            }
            HashSet<CallSite> fullClassNames = new HashSet<CallSite>();
            fullClassNames.add((CallSite)((Object)fullClassName));
            this.classMap.put(className, fullClassNames);
        }
    }

    public static void exportJson(Path path, Object obj) {
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(path.toFile()), StandardCharsets.UTF_8);){
            writer.write(config.getGSON().toJson(obj));
        }
        catch (Exception e) {
            throw new RuntimeException("In ProjectParser.exportJson: " + e);
        }
    }

    public static List<String> scanSourceDirectory(Project project) {
        ArrayList<String> classPaths = new ArrayList<String>();
        File[] files = Paths.get(project.getCompileSourceRoots().get(0), new String[0]).toFile().listFiles();
        if (files != null) {
            for (File file : files) {
                try {
                    Files.walk(file.toPath(), new FileVisitOption[0]).forEach(path -> {
                        if (path.toString().endsWith(".java")) {
                            classPaths.add(path.toString());
                        }
                    });
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return classPaths;
    }

    public JavaSymbolSolver getSymbolSolver() {
        CombinedTypeSolver combinedTypeSolver = new CombinedTypeSolver(new TypeSolver[0]);
        combinedTypeSolver.add((TypeSolver)new ReflectionTypeSolver());
        for (String dep : config.getClassPaths()) {
            try {
                File depFile = new File(dep);
                if (!depFile.exists() || !dep.endsWith("jar")) continue;
                combinedTypeSolver.add((TypeSolver)new JarTypeSolver(depFile));
            }
            catch (Exception e) {
                config.getLog().warn(e.getMessage());
                config.getLog().debug(e.getMessage());
            }
        }
        for (String src : config.getProject().getCompileSourceRoots()) {
            if (!new File(src).exists()) continue;
            combinedTypeSolver.add((TypeSolver)new JavaParserTypeSolver(src));
        }
        JavaSymbolSolver symbolSolver = new JavaSymbolSolver((TypeSolver)combinedTypeSolver);
        config.setParserFacade(JavaParserFacade.get((TypeSolver)combinedTypeSolver));
        return symbolSolver;
    }

    public static void walkDep(DependencyNode node, Set<DependencyNode> depSet) {
        depSet.add(node);
        for (DependencyNode dep : node.getChildren()) {
            ProjectParser.walkDep(dep, depSet);
        }
    }

    public void exportClassMapping() {
        Path savePath = ProjectParser.config.tmpOutput.resolve("classMapping.json");
        ProjectParser.exportJson(savePath, Config.classMapping);
    }

    private void setLanguageLevel(ParserConfiguration configuration) {
        int version = Runtime.version().feature();
        switch (version) {
            case 8: {
                configuration.setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_8);
                break;
            }
            case 9: {
                configuration.setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_9);
                break;
            }
            case 10: {
                configuration.setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_10);
                break;
            }
            case 11: {
                configuration.setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_11);
                break;
            }
            case 12: {
                configuration.setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_12);
                break;
            }
            case 13: {
                configuration.setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_13);
                break;
            }
            case 14: {
                configuration.setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_14);
                break;
            }
            case 15: {
                configuration.setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_15);
                break;
            }
            case 16: {
                configuration.setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_16);
                break;
            }
            default: {
                configuration.setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_17);
            }
        }
    }
}

