/*
 * Decompiled with CFR 0.152.
 */
package zju.cst.aces.parser;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.Position;
import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.CallableDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import zju.cst.aces.api.config.Config;
import zju.cst.aces.dto.ClassInfo;
import zju.cst.aces.dto.MethodInfo;
import zju.cst.aces.parser.ProjectParser;

public class ClassParser {
    private static final String separator = "_";
    private static Path classOutputPath;
    private static ClassInfo classInfo;
    private static JavaParser parser;
    public int methodCount = 0;
    private final Config config;

    public ClassParser(Config config, String path) {
        this.config = config;
        parser = config.getParser();
        this.setOutputPath(path);
    }

    public ClassParser(Config config, Path path) {
        this.config = config;
        parser = config.getParser();
        this.setOutputPath(path.toString());
    }

    public int extractClass(String classPath) throws FileNotFoundException {
        File file = new File(classPath);
        ParseResult parseResult = parser.parse(file);
        CompilationUnit cu = (CompilationUnit)parseResult.getResult().orElseThrow();
        List classes = cu.findAll(ClassOrInterfaceDeclaration.class);
        for (ClassOrInterfaceDeclaration classDeclaration : classes) {
            try {
                classInfo = this.getInfoByClass(cu, classDeclaration);
                this.exportClassInfo(classInfo, classDeclaration);
                this.extractMethods(cu, classDeclaration);
                this.extractConstructors(cu, classDeclaration);
                this.addClassMapping(classInfo);
                this.methodCount += classDeclaration.getMethods().size();
            }
            catch (Exception e) {
                this.config.getLog().error("In ClassParser.extractClass Exception: when parse class " + classDeclaration.getNameAsString() + " :\n" + e);
            }
        }
        return classes.size();
    }

    private static boolean isJavaSourceDir(Path path) {
        return Files.isDirectory(path, new LinkOption[0]) && Files.exists(path.resolve("src" + File.separator + "main" + File.separator + "java"), new LinkOption[0]);
    }

    private void setOutputPath(String path) {
        classOutputPath = Paths.get(path, new String[0]);
    }

    private void extractMethods(CompilationUnit cu, ClassOrInterfaceDeclaration classDeclaration) throws IOException {
        List methods = classDeclaration.getMethods();
        for (MethodDeclaration m : methods) {
            MethodInfo info = this.getInfoByMethod(cu, classDeclaration, (CallableDeclaration)m);
            this.exportMethodInfo(info, classDeclaration, m);
        }
    }

    private void extractConstructors(CompilationUnit cu, ClassOrInterfaceDeclaration classDeclaration) throws IOException {
        List constructors = classDeclaration.getConstructors();
        for (ConstructorDeclaration c : constructors) {
            MethodInfo info = this.getInfoByMethod(cu, classDeclaration, (CallableDeclaration)c);
            this.exportConstructorInfo(info, classDeclaration, c);
        }
    }

    private ClassInfo getInfoByClass(CompilationUnit cu, ClassOrInterfaceDeclaration classNode) {
        ClassInfo ci = new ClassInfo(cu, classNode, Config.sharedInteger.getAndIncrement(), ClassParser.getClassSignature(cu, classNode), this.getImports(this.getImportDeclarations(cu)), this.getFields(cu, classNode.getFields()), this.getSuperClasses(classNode), this.getMethodSignatures(classNode), this.getBriefMethods(cu, classNode), this.hasConstructors(classNode), this.getConstructorSignatures(classNode), this.getBriefConstructors(cu, classNode), this.getGetterSetterSig(cu, classNode), this.getGetterSetter(cu, classNode), this.getConstructorDeps(cu, classNode), this.getSubClasses(classNode));
        ci.setPublic(classNode.isPublic());
        ci.setAbstract(classNode.isAbstract());
        ci.setInterface(classNode.isInterface());
        ci.setCode(cu.toString(), classNode.toString());
        ci.setFullClassName(((PackageDeclaration)cu.getPackageDeclaration().orElseThrow()).getNameAsString() + "." + ci.className);
        ci.setImplementedTypes(this.getInterfaces(classNode));
        return ci;
    }

    private MethodInfo getInfoByMethod(CompilationUnit cu, ClassOrInterfaceDeclaration classNode, CallableDeclaration node) {
        MethodInfo mi = new MethodInfo(classNode.getNameAsString(), node.getNameAsString(), this.getBriefMethod(cu, node), this.getMethodSig(node), this.getMethodCode(cu, node), this.getParameters(node), this.getDependentMethods(cu, node), node.toString(), this.getMethodComment(node), this.getMethodAnnotation(node));
        mi.setUseField(this.useField(node));
        mi.setConstructor(node.isConstructorDeclaration());
        mi.setGetSet(this.isGetSet2(node));
        mi.setPublic(this.isPublic(node));
        mi.setBoolean(this.isBoolean(node));
        mi.setAbstract(node.isAbstract());
        return mi;
    }

    private Map<String, Set<String>> getConstructorDeps(CompilationUnit cu, ClassOrInterfaceDeclaration classNode) {
        LinkedHashMap<String, Set<String>> constructorDeps = new LinkedHashMap<String, Set<String>>();
        for (ConstructorDeclaration c : classNode.getConstructors()) {
            Map<String, Set<String>> tmp = this.getDependentMethods(cu, (CallableDeclaration)c);
            for (String key : tmp.keySet()) {
                if (constructorDeps.containsKey(key)) continue;
                constructorDeps.put(key, tmp.get(key));
            }
        }
        return constructorDeps;
    }

    private List<String> getGetterSetter(CompilationUnit cu, ClassOrInterfaceDeclaration classNode) {
        ArrayList<String> getterSetter = new ArrayList<String>();
        for (MethodDeclaration m : classNode.getMethods()) {
            if (!this.isGetSet2((CallableDeclaration)m)) continue;
            getterSetter.add(this.getBriefMethod(cu, (CallableDeclaration)m));
        }
        return getterSetter;
    }

    private List<String> getGetterSetterSig(CompilationUnit cu, ClassOrInterfaceDeclaration classNode) {
        ArrayList<String> getterSetter = new ArrayList<String>();
        for (MethodDeclaration m : classNode.getMethods()) {
            if (!this.isGetSet2((CallableDeclaration)m)) continue;
            getterSetter.add(m.getSignature().asString());
        }
        return getterSetter;
    }

    private String getMethodSig(CallableDeclaration node) {
        if (node instanceof MethodDeclaration) {
            return node.getSignature().asString();
        }
        return node.getSignature().asString();
    }

    private List<ImportDeclaration> getImportDeclarations(CompilationUnit compilationUnit) {
        return compilationUnit.getImports();
    }

    private List<String> getImports(List<ImportDeclaration> importDeclarations) {
        ArrayList<String> imports = new ArrayList<String>();
        for (ImportDeclaration i : importDeclarations) {
            imports.add(i.toString().trim());
        }
        return imports;
    }

    private boolean hasConstructors(ClassOrInterfaceDeclaration classNode) {
        return classNode.getConstructors().size() > 0;
    }

    private List<String> getSuperClasses(ClassOrInterfaceDeclaration node) {
        ArrayList<String> superClasses = new ArrayList<String>();
        node.getExtendedTypes().forEach(sup -> superClasses.add(sup.getNameAsString()));
        return superClasses;
    }

    public List<String> getSubClasses(ClassOrInterfaceDeclaration node) {
        String targetClassName = ((String)node.getFullyQualifiedName().orElseThrow()).toString();
        ArrayList<String> subClasses = new ArrayList<String>();
        List<String> classPaths = ProjectParser.scanSourceDirectory(this.config.project);
        if (classPaths.isEmpty()) {
            return null;
        }
        try {
            for (String classPath : classPaths) {
                ParseResult parseResult = parser.parse(new File(classPath));
                CompilationUnit cu = (CompilationUnit)parseResult.getResult().orElseThrow();
                String packageName = cu.getPackageDeclaration().isEmpty() ? "" : ((PackageDeclaration)cu.getPackageDeclaration().get()).getNameAsString();
                List classes = cu.findAll(ClassOrInterfaceDeclaration.class);
                for (ClassOrInterfaceDeclaration classDeclaration : classes) {
                    for (ClassOrInterfaceType extendedType : classDeclaration.getExtendedTypes()) {
                        if (!targetClassName.equals(packageName + "." + extendedType.getNameAsString())) continue;
                        subClasses.add(((String)classDeclaration.getFullyQualifiedName().orElseThrow()).toString());
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return subClasses;
    }

    private List<String> getInterfaces(ClassOrInterfaceDeclaration node) {
        ArrayList<String> interfaces = new ArrayList<String>();
        node.getImplementedTypes().forEach(sup -> interfaces.add(sup.getNameAsString()));
        return interfaces;
    }

    private Map<String, String> getMethodSignatures(ClassOrInterfaceDeclaration node) {
        int i;
        LinkedHashMap<String, String> mSigs = new LinkedHashMap<String, String>();
        List methods = node.getMethods();
        for (i = 0; i < methods.size(); ++i) {
            try {
                mSigs.put(((MethodDeclaration)methods.get(i)).getSignature().asString(), String.valueOf(i));
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("In ClassParser getMethodSignatures: when resolve method: " + ((MethodDeclaration)methods.get(i)).getNameAsString() + ": " + e);
            }
        }
        List constructors = node.getConstructors();
        while (i < methods.size() + constructors.size()) {
            mSigs.put(((ConstructorDeclaration)constructors.get(i - methods.size())).getSignature().asString(), String.valueOf(i));
            ++i;
        }
        return mSigs;
    }

    private List<String> getConstructorSignatures(ClassOrInterfaceDeclaration node) {
        ArrayList<String> cSigs = new ArrayList<String>();
        node.getConstructors().forEach(c -> cSigs.add(c.getSignature().asString()));
        return cSigs;
    }

    private List<String> getBriefConstructors(CompilationUnit cu, ClassOrInterfaceDeclaration node) {
        List constructors = node.getConstructors();
        ArrayList<String> cSigs = new ArrayList<String>();
        for (ConstructorDeclaration c : constructors) {
            cSigs.add(this.getBriefMethod(cu, (CallableDeclaration)c));
        }
        return cSigs;
    }

    private List<String> getBriefMethods(CompilationUnit cu, ClassOrInterfaceDeclaration node) {
        ArrayList<String> mSigs = new ArrayList<String>();
        node.getMethods().forEach(m -> mSigs.add(this.getBriefMethod(cu, (CallableDeclaration)m)));
        node.getConstructors().forEach(c -> mSigs.add(this.getBriefMethod(cu, (CallableDeclaration)c)));
        return mSigs;
    }

    private String getBriefMethod(CompilationUnit cu, CallableDeclaration node) {
        Object sig = "";
        if (node instanceof MethodDeclaration) {
            MethodDeclaration methodNode = (MethodDeclaration)node;
            if (methodNode.getBody().isPresent()) {
                sig = ClassParser.getSourceCodeByPosition(ClassParser.getTokenString((Node)cu), (Position)methodNode.getBegin().orElseThrow(), (Position)((BlockStmt)methodNode.getBody().get()).getBegin().orElseThrow());
                sig = ((String)sig).substring(0, ((String)sig).lastIndexOf("{") - 1) + "{}";
            } else {
                sig = ClassParser.getSourceCodeByPosition(ClassParser.getTokenString((Node)cu), (Position)methodNode.getBegin().orElseThrow(), (Position)methodNode.getEnd().orElseThrow());
            }
        } else if (node instanceof ConstructorDeclaration) {
            ConstructorDeclaration constructorNode = (ConstructorDeclaration)node.removeComment();
            sig = ClassParser.getSourceCodeByPosition(ClassParser.getTokenString((Node)cu), (Position)constructorNode.getBegin().orElseThrow(), (Position)constructorNode.getBody().getBegin().orElseThrow());
            sig = ((String)sig).substring(0, ((String)sig).lastIndexOf("{") - 1) + "{}";
        }
        return sig;
    }

    public static String getClassSignature(CompilationUnit cu, ClassOrInterfaceDeclaration node) {
        return ClassParser.getSourceCodeByPosition(ClassParser.getTokenString((Node)cu), (Position)node.getBegin().orElseThrow(), (Position)node.getName().getEnd().orElseThrow());
    }

    private String getMethodCode(CompilationUnit cu, CallableDeclaration node) {
        return ((TokenRange)node.getTokenRange().orElseThrow()).toString();
    }

    private String getMethodAnnotation(CallableDeclaration node) {
        StringBuffer sb = new StringBuffer();
        if (node.getAnnotations().isEmpty()) {
            return "";
        }
        for (Object annotation : node.getAnnotations()) {
            sb.append(annotation.toString() + "\n");
        }
        return sb.toString();
    }

    private String getMethodComment(CallableDeclaration node) {
        Optional comment = node.getComment();
        if (comment.isEmpty()) {
            return "";
        }
        return ((Comment)node.getComment().get()).toString();
    }

    private List<String> getFields(CompilationUnit cu, List<FieldDeclaration> nodes) {
        ArrayList<String> fields = new ArrayList<String>();
        for (FieldDeclaration f : nodes) {
            fields.add(this.getFieldCode(cu, f));
        }
        return fields;
    }

    private String getFieldCode(CompilationUnit cu, FieldDeclaration node) {
        return ((TokenRange)node.getTokenRange().orElseThrow()).toString();
    }

    private boolean useField(CallableDeclaration node) {
        return node.findAll(FieldAccessExpr.class).size() > 0;
    }

    private boolean isGetSet(CallableDeclaration node) {
        if (node.isConstructorDeclaration()) {
            return false;
        }
        if (!node.getNameAsString().startsWith("get") && !node.getNameAsString().startsWith("set")) {
            return false;
        }
        List fieldAccesses = node.findAll(FieldAccessExpr.class);
        for (FieldAccessExpr fa : fieldAccesses) {
            if (fa.getParentNode().orElse(null) instanceof ReturnStmt) {
                return true;
            }
            if (!(fa.getParentNode().orElse(null) instanceof AssignExpr) || !((AssignExpr)fa.getParentNode().orElseThrow()).getTarget().equals((Object)fa)) continue;
            return true;
        }
        return false;
    }

    private boolean isGetSet2(CallableDeclaration node) {
        if (node.isConstructorDeclaration()) {
            return false;
        }
        if (node.getNameAsString().startsWith("get") && node.getParameters().size() == 0) {
            return true;
        }
        return node.getNameAsString().startsWith("set");
    }

    private boolean isPublic(CallableDeclaration node) {
        return node.isPublic();
    }

    private boolean isBoolean(CallableDeclaration node) {
        if (node.isConstructorDeclaration()) {
            return false;
        }
        return node.getNameAsString().startsWith("is") && node.getParameters().size() == 0 && node.asMethodDeclaration().getTypeAsString().equals("boolean");
    }

    private List<String> getParameters(CallableDeclaration node) {
        ArrayList<String> parameters = new ArrayList<String>();
        node.getParameters().forEach(p -> parameters.add(((Parameter)p).getType().asString()));
        return parameters;
    }

    private Map<String, Set<String>> getDependentMethods(CompilationUnit cu, CallableDeclaration node) {
        LinkedHashMap<String, Set<String>> dependentMethods = new LinkedHashMap<String, Set<String>>();
        List methodCalls = node.findAll(MethodCallExpr.class);
        NodeList pars = node.getParameters();
        for (Parameter p : pars) {
            try {
                String dependentType;
                if (p.getType().isPrimitiveType()) continue;
                if (p.getType().isArrayType()) {
                    dependentType = p.resolve().getType().asArrayType().getComponentType().describe();
                    dependentMethods.put(dependentType, new HashSet());
                    continue;
                }
                if (p.getTypeAsString().split("<")[0].endsWith("Map") || p.getTypeAsString().split("<")[0].endsWith("List") || p.getTypeAsString().split("<")[0].endsWith("Set") || p.getType().getChildNodes().size() != 1) continue;
                dependentType = p.resolve().describeType();
                dependentMethods.put(dependentType, new HashSet());
            }
            catch (Exception dependentType) {}
        }
        for (MethodCallExpr m : methodCalls) {
            try {
                ResolvedMethodDeclaration md = m.resolve();
                String dependentType = md.declaringType().getQualifiedName();
                String mSig = ClassParser.getParamTypeInSig(md);
                HashSet<String> invocations = (HashSet<String>)dependentMethods.get(dependentType);
                if (invocations == null) {
                    invocations = new HashSet<String>();
                }
                invocations.add(mSig);
                dependentMethods.put(dependentType, invocations);
            }
            catch (Exception exception) {}
        }
        return dependentMethods;
    }

    private static String getParamTypeInSig(ResolvedMethodDeclaration md) {
        String sig = md.getName() + "(";
        for (int i = 0; i < md.getNumberOfParams(); ++i) {
            String paramType = md.getParam(i).getType().erasure().describe();
            if (paramType.contains(".")) {
                paramType = paramType.substring(paramType.lastIndexOf(".") + 1);
            }
            sig = i == md.getNumberOfParams() - 1 ? sig + paramType : sig + paramType + ", ";
        }
        sig = sig + ")";
        return sig;
    }

    public String getLastType(String type) {
        return type.substring(type.lastIndexOf(".") + 1);
    }

    private static String getSourceCodeByPosition(String code, Position begin, Position end) {
        String[] lines = code.split("\\n");
        StringBuilder sb = new StringBuilder();
        for (int i = begin.line - 1; i < end.line; ++i) {
            if (i == begin.line - 1 && i == end.line - 1) {
                sb.append(lines[i].substring(begin.column - 1, end.column));
            } else if (i == begin.line - 1) {
                sb.append(lines[i].substring(begin.column - 1));
            } else if (i == end.line - 1) {
                sb.append(lines[i].substring(0, end.column));
            } else {
                sb.append(lines[i]);
            }
            if (i >= end.line - 1) continue;
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    private static String getTokenString(@NotNull Node node) {
        if (node.getTokenRange().isPresent()) {
            return ((TokenRange)node.getTokenRange().get()).toString();
        }
        return "";
    }

    private void exportClassInfo(ClassInfo classInfo, ClassOrInterfaceDeclaration classNode) throws IOException {
        Path classOutputDir = classOutputPath.resolve(classNode.getName().getIdentifier());
        if (!Files.exists(classOutputDir, new LinkOption[0])) {
            Files.createDirectories(classOutputDir, new FileAttribute[0]);
        }
        Path classInfoPath = classOutputDir.resolve("class.json");
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(classInfoPath.toFile()), StandardCharsets.UTF_8);){
            writer.write(this.config.getGSON().toJson((Object)classInfo));
        }
    }

    private void exportMethodInfo(MethodInfo methodInfo, ClassOrInterfaceDeclaration classNode, MethodDeclaration node) throws IOException {
        Path classOutputDir = classOutputPath.resolve(classNode.getName().getIdentifier());
        if (!Files.exists(classOutputDir, new LinkOption[0])) {
            Files.createDirectories(classOutputDir, new FileAttribute[0]);
        }
        Path info = classOutputDir.resolve(this.getFilePathBySig(node.getSignature().asString()));
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(info.toFile()), StandardCharsets.UTF_8);){
            writer.write(this.config.getGSON().toJson((Object)methodInfo));
        }
    }

    private void exportConstructorInfo(MethodInfo methodInfo, ClassOrInterfaceDeclaration classNode, ConstructorDeclaration node) throws IOException {
        Path classOutputDir = classOutputPath.resolve(classNode.getName().getIdentifier());
        if (!Files.exists(classOutputDir, new LinkOption[0])) {
            Files.createDirectories(classOutputDir, new FileAttribute[0]);
        }
        Path info = classOutputDir.resolve(this.getFilePathBySig(node.getSignature().asString()));
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(info.toFile()), StandardCharsets.UTF_8);){
            writer.write(this.config.getGSON().toJson((Object)methodInfo));
        }
    }

    private Path getFilePathBySig(String sig) {
        Map<String, String> mSigs = ClassParser.classInfo.methodSigs;
        return Paths.get(mSigs.get(sig) + ".json", new String[0]);
    }

    public static Path getFilePathBySig(String mSig, ClassInfo info) {
        Map<String, String> mSigs = info.methodSigs;
        return Paths.get(mSigs.get(mSig) + ".json", new String[0]);
    }

    private List<Path> getSources() {
        List<Path> list;
        block8: {
            Stream<Path> paths = Files.walk(Path.of(System.getProperty("user.dir"), new String[0]), new FileVisitOption[0]);
            try {
                list = paths.filter(ClassParser::isJavaSourceDir).collect(Collectors.toList());
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("In ClassParser.getSources: " + e);
                }
            }
            paths.close();
        }
        return list;
    }

    public void addClassMapping(ClassInfo classInfo) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("className", classInfo.className);
        map.put("packageDeclaration", classInfo.packageDeclaration);
        map.put("modifier", classInfo.modifier);
        map.put("extend", classInfo.extend);
        map.put("implement", classInfo.implement);
        if (Config.classMapping == null) {
            Config.classMapping = new LinkedHashMap<String, Map<String, String>>();
        }
        Config.classMapping.put("class" + classInfo.index, map);
    }
}

